/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.java.debug.core.adapter.handler;

import com.microsoft.java.debug.core.adapter.AdapterUtils;
import com.microsoft.java.debug.core.adapter.ErrorCode;
import com.microsoft.java.debug.core.adapter.IDebugAdapterContext;
import com.microsoft.java.debug.core.adapter.IDebugRequestHandler;
import com.microsoft.java.debug.core.protocol.Messages;
import com.microsoft.java.debug.core.protocol.Requests;
import java.util.Arrays;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import org.apache.commons.lang3.ArrayUtils;

public class SetExceptionBreakpointsRequestHandler
implements IDebugRequestHandler {
    @Override
    public List<Requests.Command> getTargetCommands() {
        return Arrays.asList(Requests.Command.SETEXCEPTIONBREAKPOINTS);
    }

    @Override
    public CompletableFuture<Messages.Response> handle(Requests.Command command, Requests.Arguments arguments, Messages.Response response, IDebugAdapterContext context) {
        if (context.getDebugSession() == null) {
            return AdapterUtils.createAsyncErrorResponse(response, ErrorCode.EMPTY_DEBUG_SESSION, "Empty debug session.");
        }
        Object[] filters = ((Requests.SetExceptionBreakpointsArguments)arguments).filters;
        try {
            boolean notifyCaught = ArrayUtils.contains((Object[])filters, (Object)"caught");
            boolean notifyUncaught = ArrayUtils.contains((Object[])filters, (Object)"uncaught");
            context.getDebugSession().setExceptionBreakpoints(notifyCaught, notifyUncaught);
            return CompletableFuture.completedFuture(response);
        }
        catch (Exception ex) {
            throw AdapterUtils.createCompletionException(String.format("Failed to setExceptionBreakpoints. Reason: '%s'", ex.toString()), ErrorCode.SET_EXCEPTIONBREAKPOINT_FAILURE, ex);
        }
    }
}

