/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.java.debug.core.adapter.handler;

import com.microsoft.java.debug.core.DebugUtility;
import com.microsoft.java.debug.core.adapter.AdapterUtils;
import com.microsoft.java.debug.core.adapter.IDebugAdapterContext;
import com.microsoft.java.debug.core.adapter.IDebugRequestHandler;
import com.microsoft.java.debug.core.adapter.ISourceLookUpProvider;
import com.microsoft.java.debug.core.adapter.formatter.SimpleTypeFormatter;
import com.microsoft.java.debug.core.adapter.variables.StackFrameReference;
import com.microsoft.java.debug.core.protocol.Messages;
import com.microsoft.java.debug.core.protocol.Requests;
import com.microsoft.java.debug.core.protocol.Responses;
import com.microsoft.java.debug.core.protocol.Types;
import com.sun.jdi.AbsentInformationException;
import com.sun.jdi.IncompatibleThreadStateException;
import com.sun.jdi.Location;
import com.sun.jdi.Method;
import com.sun.jdi.ObjectCollectedException;
import com.sun.jdi.StackFrame;
import com.sun.jdi.ThreadReference;
import java.io.File;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;

public class StackTraceRequestHandler
implements IDebugRequestHandler {
    @Override
    public List<Requests.Command> getTargetCommands() {
        return Arrays.asList(Requests.Command.STACKTRACE);
    }

    @Override
    public CompletableFuture<Messages.Response> handle(Requests.Command command, Requests.Arguments arguments, Messages.Response response, IDebugAdapterContext context) {
        Requests.StackTraceArguments stacktraceArgs = (Requests.StackTraceArguments)arguments;
        ArrayList<Types.StackFrame> result = new ArrayList<Types.StackFrame>();
        if (stacktraceArgs.startFrame < 0 || stacktraceArgs.levels < 0) {
            response.body = new Responses.StackTraceResponseBody(result, 0);
            return CompletableFuture.completedFuture(response);
        }
        ThreadReference thread = DebugUtility.getThread(context.getDebugSession(), stacktraceArgs.threadId);
        int totalFrames = 0;
        if (thread != null) {
            try {
                totalFrames = thread.frameCount();
                if (totalFrames <= stacktraceArgs.startFrame) {
                    response.body = new Responses.StackTraceResponseBody(result, totalFrames);
                    return CompletableFuture.completedFuture(response);
                }
                StackFrame[] frames = context.getStackFrameManager().reloadStackFrames(thread);
                int count = stacktraceArgs.levels == 0 ? totalFrames - stacktraceArgs.startFrame : Math.min(totalFrames - stacktraceArgs.startFrame, stacktraceArgs.levels);
                for (int i = stacktraceArgs.startFrame; i < frames.length && count-- > 0; ++i) {
                    StackFrameReference stackframe = new StackFrameReference(thread, i);
                    int frameId = context.getRecyclableIdPool().addObject(thread.uniqueID(), stackframe);
                    result.add(this.convertDebuggerStackFrameToClient(frames[i], frameId, context));
                }
            }
            catch (AbsentInformationException | IncompatibleThreadStateException | ObjectCollectedException | IndexOutOfBoundsException | URISyntaxException exception) {
                // empty catch block
            }
        }
        response.body = new Responses.StackTraceResponseBody(result, totalFrames);
        return CompletableFuture.completedFuture(response);
    }

    private Types.StackFrame convertDebuggerStackFrameToClient(StackFrame stackFrame, int frameId, IDebugAdapterContext context) throws URISyntaxException, AbsentInformationException {
        Location location = stackFrame.location();
        Method method = location.method();
        Types.Source clientSource = this.convertDebuggerSourceToClient(location, context);
        String methodName = this.formatMethodName(method, true, true);
        int lineNumber = AdapterUtils.convertLineNumber(location.lineNumber(), context.isDebuggerLinesStartAt1(), context.isClientLinesStartAt1());
        if (lineNumber < 0) {
            if (method.isNative()) {
                methodName = methodName + "[native method]";
            } else {
                clientSource = null;
            }
        }
        return new Types.StackFrame(frameId, methodName, clientSource, lineNumber, 0);
    }

    private Types.Source convertDebuggerSourceToClient(Location location, IDebugAdapterContext context) throws URISyntaxException {
        String fullyQualifiedName = location.declaringType().name();
        String sourceName = "";
        String relativeSourcePath = "";
        try {
            sourceName = location.sourceName();
            relativeSourcePath = location.sourcePath();
        }
        catch (AbsentInformationException e) {
            String enclosingType = AdapterUtils.parseEnclosingType(fullyQualifiedName);
            sourceName = enclosingType.substring(enclosingType.lastIndexOf(46) + 1) + ".java";
            relativeSourcePath = enclosingType.replace('.', File.separatorChar) + ".java";
        }
        String finalRelativeSourcePath = relativeSourcePath;
        String uri = context.getSourceLookupCache().computeIfAbsent(fullyQualifiedName, key -> {
            String fromProvider = context.getProvider(ISourceLookUpProvider.class).getSourceFileURI((String)key, finalRelativeSourcePath);
            return StringUtils.isBlank((CharSequence)fromProvider) ? "" : fromProvider;
        });
        if (!StringUtils.isBlank((CharSequence)uri)) {
            if (uri.startsWith("file:")) {
                String clientPath = AdapterUtils.convertPath(uri, context.isDebuggerPathsAreUri(), context.isClientPathsAreUri());
                return new Types.Source(sourceName, clientPath, 0);
            }
            return new Types.Source(sourceName, uri, 0);
        }
        String absoluteSourcepath = AdapterUtils.sourceLookup(context.getSourcePaths(), relativeSourcePath);
        if (absoluteSourcepath != null) {
            return new Types.Source(sourceName, absoluteSourcepath, 0);
        }
        return null;
    }

    private String formatMethodName(Method method, boolean showContextClass, boolean showParameter) {
        StringBuilder formattedName = new StringBuilder();
        if (showContextClass) {
            String fullyQualifiedClassName = method.declaringType().name();
            formattedName.append(SimpleTypeFormatter.trimTypeName(fullyQualifiedClassName));
            formattedName.append(".");
        }
        formattedName.append(method.name());
        if (showParameter) {
            List argumentTypeNames = method.argumentTypeNames().stream().map(SimpleTypeFormatter::trimTypeName).collect(Collectors.toList());
            formattedName.append("(");
            formattedName.append(String.join((CharSequence)",", argumentTypeNames));
            formattedName.append(")");
        }
        return formattedName.toString();
    }
}

