/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.java.debug.core.adapter.variables;

import com.sun.jdi.ThreadReference;
import java.util.Objects;

public class VariableProxy {
    private final ThreadReference thread;
    private final String scopeName;
    private Object variable;
    private int hashCode;

    public VariableProxy(ThreadReference thread, String scopeName, Object variable) {
        this.thread = thread;
        this.scopeName = scopeName;
        this.variable = variable;
        this.hashCode = thread.hashCode() & scopeName.hashCode() & variable.hashCode();
    }

    public String toString() {
        return String.format("%s %s", String.valueOf(this.variable), this.scopeName);
    }

    public int hashCode() {
        return this.hashCode;
    }

    public boolean equals(Object o) {
        if (!(o instanceof VariableProxy)) {
            return false;
        }
        VariableProxy other = (VariableProxy)o;
        return this.getThreadId() == other.getThreadId() && Objects.equals(this.getScope(), other.getScope()) && Objects.equals(this.getProxiedVariable(), other.getProxiedVariable());
    }

    public ThreadReference getThread() {
        return this.thread;
    }

    public long getThreadId() {
        return this.thread.uniqueID();
    }

    public String getScope() {
        return this.scopeName;
    }

    public Object getProxiedVariable() {
        return this.variable;
    }
}

