/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.java.debug.core.adapter.handler;

import com.microsoft.java.debug.core.adapter.AdapterUtils;
import com.microsoft.java.debug.core.adapter.ErrorCode;
import com.microsoft.java.debug.core.adapter.ICompletionsProvider;
import com.microsoft.java.debug.core.adapter.IDebugAdapterContext;
import com.microsoft.java.debug.core.adapter.IDebugRequestHandler;
import com.microsoft.java.debug.core.adapter.variables.StackFrameReference;
import com.microsoft.java.debug.core.protocol.Messages;
import com.microsoft.java.debug.core.protocol.Requests;
import com.microsoft.java.debug.core.protocol.Responses;
import com.microsoft.java.debug.core.protocol.Types;
import com.sun.jdi.IncompatibleThreadStateException;
import com.sun.jdi.ThreadReference;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.concurrent.CompletableFuture;

public class CompletionsHandler
implements IDebugRequestHandler {
    @Override
    public List<Requests.Command> getTargetCommands() {
        return Arrays.asList(Requests.Command.COMPLETIONS);
    }

    @Override
    public CompletableFuture<Messages.Response> handle(Requests.Command command, Requests.Arguments arguments, Messages.Response response, IDebugAdapterContext context) {
        Requests.CompletionsArguments completionsArgs = (Requests.CompletionsArguments)arguments;
        if (completionsArgs.frameId == 0) {
            response.body = new ArrayList();
            return CompletableFuture.completedFuture(response);
        }
        StackFrameReference stackFrameReference = (StackFrameReference)context.getRecyclableIdPool().getObjectById(completionsArgs.frameId);
        if (stackFrameReference == null) {
            throw AdapterUtils.createCompletionException(String.format("Completions: cannot find the stack frame with frameID %s", completionsArgs.frameId), ErrorCode.COMPLETIONS_FAILURE);
        }
        return CompletableFuture.supplyAsync(() -> {
            try {
                ICompletionsProvider completionsProvider = context.getProvider(ICompletionsProvider.class);
                if (completionsProvider != null) {
                    ThreadReference thread = stackFrameReference.getThread();
                    List<Types.CompletionItem> res = completionsProvider.codeComplete(thread.frame(stackFrameReference.getDepth()), completionsArgs.text, completionsArgs.line, completionsArgs.column);
                    response.body = new Responses.CompletionsResponseBody(res);
                }
                return response;
            }
            catch (IncompatibleThreadStateException e) {
                throw AdapterUtils.createCompletionException(String.format("Cannot provide code completions because of %s.", e.toString()), ErrorCode.COMPLETIONS_FAILURE, e);
            }
        });
    }
}

