/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.java.debug.core.adapter.handler;

import com.google.gson.JsonObject;
import com.microsoft.java.debug.core.DebugException;
import com.microsoft.java.debug.core.adapter.ErrorCode;
import com.microsoft.java.debug.core.adapter.IDebugAdapterContext;
import com.microsoft.java.debug.core.adapter.ProcessConsole;
import com.microsoft.java.debug.core.adapter.handler.ILaunchDelegate;
import com.microsoft.java.debug.core.adapter.handler.LaunchRequestHandler;
import com.microsoft.java.debug.core.protocol.Events;
import com.microsoft.java.debug.core.protocol.JsonUtils;
import com.microsoft.java.debug.core.protocol.Messages;
import com.microsoft.java.debug.core.protocol.Requests;
import com.sun.jdi.connect.IllegalConnectorArgumentsException;
import com.sun.jdi.connect.VMStartException;
import io.reactivex.functions.Consumer;
import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Paths;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionException;
import java.util.logging.Logger;

public class LaunchWithoutDebuggingDelegate
implements ILaunchDelegate {
    protected static final Logger logger = Logger.getLogger("java-debug");
    protected static final String TERMINAL_TITLE = "Java Process Console";
    protected static final long RUNINTERMINAL_TIMEOUT = 10000L;

    private Process launchInternalDebuggeeProcess(Requests.LaunchArguments launchArguments, final IDebugAdapterContext context) throws IOException, IllegalConnectorArgumentsException, VMStartException {
        String[] cmds = LaunchRequestHandler.constructLaunchCommands(launchArguments, false, null);
        File workingDir = null;
        if (launchArguments.cwd != null && Files.isDirectory(Paths.get(launchArguments.cwd, new String[0]), new LinkOption[0])) {
            workingDir = new File(launchArguments.cwd);
        }
        final Process debuggeeProcess = Runtime.getRuntime().exec(cmds, LaunchRequestHandler.constructEnvironmentVariables(launchArguments), workingDir);
        new Thread(){

            @Override
            public void run() {
                try {
                    debuggeeProcess.waitFor();
                }
                catch (InterruptedException ignore) {
                    logger.warning(String.format("Current thread is interrupted. Reason: %s", ignore.toString()));
                    debuggeeProcess.destroy();
                }
                finally {
                    context.getProtocolServer().sendEvent(new Events.TerminatedEvent());
                }
            }
        }.start();
        logger.info("Launching debuggee proccess succeeded.");
        return debuggeeProcess;
    }

    @Override
    public CompletableFuture<Messages.Response> launchInternally(Requests.LaunchArguments launchArguments, Messages.Response response, IDebugAdapterContext context) {
        CompletableFuture<Messages.Response> resultFuture = new CompletableFuture<Messages.Response>();
        try {
            Process debuggeeProcess = this.launchInternalDebuggeeProcess(launchArguments, context);
            context.setDebuggeeProcess(debuggeeProcess);
            ProcessConsole debuggeeConsole = new ProcessConsole(debuggeeProcess, "Debuggee", context.getDebuggeeEncoding());
            debuggeeConsole.onStdout((Consumer<String>)((Consumer)output -> context.getProtocolServer().sendEvent(Events.OutputEvent.createStdoutOutput(output))));
            debuggeeConsole.onStderr((Consumer<String>)((Consumer)err -> context.getProtocolServer().sendEvent(Events.OutputEvent.createStderrOutput(err))));
            debuggeeConsole.start();
            resultFuture.complete(response);
        }
        catch (IllegalConnectorArgumentsException | VMStartException | IOException e) {
            resultFuture.completeExceptionally(new DebugException(String.format("Failed to launch debuggee VM. Reason: %s", e.toString()), ErrorCode.LAUNCH_FAILURE.getId()));
        }
        return resultFuture;
    }

    @Override
    public void postLaunch(Requests.LaunchArguments launchArguments, IDebugAdapterContext context) {
    }

    @Override
    public CompletableFuture<Messages.Response> launchInTerminal(Requests.LaunchArguments launchArguments, Messages.Response response, IDebugAdapterContext context) {
        CompletableFuture<Messages.Response> resultFuture = new CompletableFuture<Messages.Response>();
        String launchInTerminalErrorFormat = "Failed to launch debuggee in terminal. Reason: %s";
        String[] cmds = LaunchRequestHandler.constructLaunchCommands(launchArguments, false, null);
        Requests.RunInTerminalRequestArguments requestArgs = null;
        requestArgs = launchArguments.console == Requests.CONSOLE.integratedTerminal ? Requests.RunInTerminalRequestArguments.createIntegratedTerminal(cmds, launchArguments.cwd, launchArguments.env, TERMINAL_TITLE) : Requests.RunInTerminalRequestArguments.createExternalTerminal(cmds, launchArguments.cwd, launchArguments.env, TERMINAL_TITLE);
        Messages.Request request = new Messages.Request(Requests.Command.RUNINTERMINAL.getName(), (JsonObject)JsonUtils.toJsonTree(requestArgs, Requests.RunInTerminalRequestArguments.class));
        context.getProtocolServer().sendRequest(request, 10000L).whenComplete((runResponse, ex) -> {
            if (runResponse != null) {
                if (runResponse.success) {
                    context.getProtocolServer().sendEvent(new Events.TerminatedEvent());
                    resultFuture.complete(response);
                } else {
                    resultFuture.completeExceptionally(new DebugException(String.format("Failed to launch debuggee in terminal. Reason: %s", runResponse.message), ErrorCode.LAUNCH_IN_TERMINAL_FAILURE.getId()));
                }
            } else {
                if (ex instanceof CompletionException && ex.getCause() != null) {
                    ex = ex.getCause();
                }
                String errorMessage = String.format("Failed to launch debuggee in terminal. Reason: %s", ex != null ? ex.toString() : "Null response");
                resultFuture.completeExceptionally(new DebugException(String.format("Failed to launch debuggee in terminal. Reason: %s", errorMessage), ErrorCode.LAUNCH_IN_TERMINAL_FAILURE.getId()));
            }
        });
        return resultFuture;
    }

    @Override
    public void preLaunch(Requests.LaunchArguments launchArguments, IDebugAdapterContext context) {
    }
}

