/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.java.debug.core.adapter.variables;

import com.microsoft.java.debug.core.DebugSettings;
import com.microsoft.java.debug.core.adapter.formatter.NumericFormatEnum;
import com.microsoft.java.debug.core.adapter.variables.Variable;
import com.sun.jdi.AbsentInformationException;
import com.sun.jdi.ArrayReference;
import com.sun.jdi.ArrayType;
import com.sun.jdi.ClassNotLoadedException;
import com.sun.jdi.Field;
import com.sun.jdi.InternalException;
import com.sun.jdi.LocalVariable;
import com.sun.jdi.ObjectReference;
import com.sun.jdi.ReferenceType;
import com.sun.jdi.StackFrame;
import com.sun.jdi.Type;
import com.sun.jdi.TypeComponent;
import com.sun.jdi.Value;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.stream.Collectors;

public abstract class VariableUtils {
    private static final Logger logger = Logger.getLogger("java-debug");

    public static boolean hasChildren(Value value, boolean includeStatic) {
        if (value == null) {
            return false;
        }
        Type type = value.type();
        if (type instanceof ArrayType) {
            return ((ArrayReference)value).length() > 0;
        }
        return value.type() instanceof ReferenceType && ((ReferenceType)type).allFields().stream().filter(t -> includeStatic || !t.isStatic()).toArray().length > 0;
    }

    public static List<Variable> listFieldVariables(ObjectReference obj, boolean includeStatic) throws AbsentInformationException {
        ArrayList<Variable> res = new ArrayList<Variable>();
        Type type = obj.type();
        if (type instanceof ArrayType) {
            int arrayIndex = 0;
            for (Value elementValue : ((ArrayReference)obj).getValues()) {
                Variable ele = new Variable(String.valueOf(arrayIndex++), elementValue);
                res.add(ele);
            }
            return res;
        }
        List<Field> fields = obj.referenceType().allFields().stream().filter(t -> includeStatic || !t.isStatic()).sorted((a, b) -> {
            try {
                boolean v1isStatic = a.isStatic();
                boolean v2isStatic = b.isStatic();
                if (v1isStatic && !v2isStatic) {
                    return -1;
                }
                if (!v1isStatic && v2isStatic) {
                    return 1;
                }
                return a.name().compareToIgnoreCase(b.name());
            }
            catch (Exception e) {
                logger.log(Level.SEVERE, String.format("Cannot sort fields: %s", e), e);
                return -1;
            }
        }).collect(Collectors.toList());
        fields.forEach(f -> {
            Variable var = new Variable(f.name(), obj.getValue((Field)f));
            var.field = f;
            res.add(var);
        });
        return res;
    }

    public static List<Variable> listFieldVariables(ObjectReference obj, int start, int count) throws AbsentInformationException {
        ArrayList<Variable> res = new ArrayList<Variable>();
        Type type = obj.type();
        if (type instanceof ArrayType) {
            int arrayIndex = start;
            for (Value elementValue : ((ArrayReference)obj).getValues(start, count)) {
                res.add(new Variable(String.valueOf(arrayIndex++), elementValue));
            }
            return res;
        }
        throw new UnsupportedOperationException("Only Array type is supported.");
    }

    public static List<Variable> listLocalVariables(StackFrame stackFrame) throws AbsentInformationException {
        ArrayList<Variable> res;
        block11: {
            res = new ArrayList<Variable>();
            if (stackFrame.location().method().isNative()) {
                return res;
            }
            try {
                for (LocalVariable localVariable : stackFrame.visibleVariables()) {
                    Variable var = new Variable(localVariable.name(), stackFrame.getValue(localVariable));
                    var.local = localVariable;
                    res.add(var);
                }
            }
            catch (AbsentInformationException ex) {
                try {
                    if (stackFrame.location().method().argumentTypes().size() == 0) {
                        return res;
                    }
                }
                catch (ClassNotLoadedException localVariable) {
                    // empty catch block
                }
                int argId = 0;
                try {
                    List<Value> arguments = stackFrame.getArgumentValues();
                    if (arguments == null) {
                        return res;
                    }
                    for (Value argValue : arguments) {
                        Variable var = new Variable("arg" + argId, argValue);
                        var.argumentIndex = argId++;
                        res.add(var);
                    }
                }
                catch (InternalException ex2) {
                    if (ex2.errorCode() == 32) break block11;
                    throw ex;
                }
            }
        }
        return res;
    }

    public static Variable getThisVariable(StackFrame stackFrame) {
        ObjectReference thisObject = stackFrame.thisObject();
        if (thisObject == null) {
            return null;
        }
        return new Variable("this", thisObject);
    }

    public static List<Variable> listStaticVariables(StackFrame stackFrame) {
        ArrayList<Variable> res = new ArrayList<Variable>();
        ReferenceType type = stackFrame.location().declaringType();
        type.allFields().stream().filter(TypeComponent::isStatic).forEach(field -> {
            Variable staticVar = new Variable(field.name(), type.getValue((Field)field));
            staticVar.field = field;
            res.add(staticVar);
        });
        return res;
    }

    public static void applyFormatterOptions(Map<String, Object> defaultOptions, boolean hexInArgument) {
        Map<String, Object> options = defaultOptions;
        boolean showFullyQualifiedNames = DebugSettings.getCurrent().showQualifiedNames;
        if (hexInArgument || DebugSettings.getCurrent().showHex) {
            options.put("numeric_format", (Object)NumericFormatEnum.HEX);
        }
        if (showFullyQualifiedNames) {
            options.put("qualified_class_name", true);
        }
        if (DebugSettings.getCurrent().maxStringLength > 0) {
            options.put("max_string_length", DebugSettings.getCurrent().maxStringLength);
        }
    }

    private VariableUtils() {
    }
}

