/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.java.debug.core.adapter.handler;

import com.microsoft.java.debug.core.DebugSettings;
import com.microsoft.java.debug.core.adapter.AdapterUtils;
import com.microsoft.java.debug.core.adapter.ErrorCode;
import com.microsoft.java.debug.core.adapter.IDebugAdapterContext;
import com.microsoft.java.debug.core.adapter.IDebugRequestHandler;
import com.microsoft.java.debug.core.adapter.IEvaluationProvider;
import com.microsoft.java.debug.core.adapter.variables.IVariableFormatter;
import com.microsoft.java.debug.core.adapter.variables.JavaLogicalStructure;
import com.microsoft.java.debug.core.adapter.variables.JavaLogicalStructureManager;
import com.microsoft.java.debug.core.adapter.variables.StackFrameReference;
import com.microsoft.java.debug.core.adapter.variables.Variable;
import com.microsoft.java.debug.core.adapter.variables.VariableProxy;
import com.microsoft.java.debug.core.adapter.variables.VariableUtils;
import com.microsoft.java.debug.core.protocol.Messages;
import com.microsoft.java.debug.core.protocol.Requests;
import com.microsoft.java.debug.core.protocol.Responses;
import com.microsoft.java.debug.core.protocol.Types;
import com.sun.jdi.AbsentInformationException;
import com.sun.jdi.ArrayReference;
import com.sun.jdi.IntegerValue;
import com.sun.jdi.InternalException;
import com.sun.jdi.InvalidStackFrameException;
import com.sun.jdi.ObjectReference;
import com.sun.jdi.Type;
import com.sun.jdi.Value;
import java.lang.invoke.LambdaMetafactory;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.CancellationException;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutionException;
import java.util.function.BiConsumer;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.stream.Collectors;

public class VariablesRequestHandler
implements IDebugRequestHandler {
    protected static final Logger logger = Logger.getLogger("java-debug");

    @Override
    public List<Requests.Command> getTargetCommands() {
        return Arrays.asList(Requests.Command.VARIABLES);
    }

    /*
     * Could not resolve type clashes
     * Unable to fully structure code
     */
    @Override
    public CompletableFuture<Messages.Response> handle(Requests.Command command, Requests.Arguments arguments, Messages.Response response, IDebugAdapterContext context) {
        variableFormatter = context.getVariableFormatter();
        varArgs = (Requests.VariablesArguments)arguments;
        showStaticVariables = DebugSettings.getCurrent().showStaticVariables;
        options = variableFormatter.getDefaultOptions();
        VariableUtils.applyFormatterOptions(options, varArgs.format != null && varArgs.format.hex != false);
        list = new ArrayList<Types.Variable>();
        container = context.getRecyclableIdPool().getObjectById(varArgs.variablesReference);
        if (container == null) {
            response.body = new Responses.VariablesResponseBody(list);
            return CompletableFuture.completedFuture(response);
        }
        if (!(container instanceof VariableProxy)) {
            throw AdapterUtils.createCompletionException(String.format("VariablesRequest: Invalid variablesReference %d.", new Object[]{varArgs.variablesReference}), ErrorCode.GET_VARIABLE_FAILURE);
        }
        containerNode = (VariableProxy)container;
        childrenList = new ArrayList<E>();
        stackFrameManager = context.getStackFrameManager();
        if (containerNode.getProxiedVariable() instanceof StackFrameReference) {
            stackFrameReference = (StackFrameReference)containerNode.getProxiedVariable();
            frame = stackFrameManager.getStackFrame(stackFrameReference);
            if (frame == null) {
                throw AdapterUtils.createCompletionException(String.format("Invalid stackframe id %d to get variables.", new Object[]{varArgs.variablesReference}), ErrorCode.GET_VARIABLE_FAILURE);
            }
            try {
                childrenList = VariableUtils.listLocalVariables(frame);
                thisVariable = VariableUtils.getThisVariable(frame);
                if (thisVariable != null) {
                    childrenList.add(thisVariable);
                }
                if (!showStaticVariables || !frame.location().method().isStatic()) ** GOTO lbl67
                childrenList.addAll(VariableUtils.listStaticVariables(frame));
            }
            catch (AbsentInformationException | InternalException | InvalidStackFrameException e) {
                throw AdapterUtils.createCompletionException(String.format("Failed to get variables. Reason: %s", new Object[]{e.toString()}), ErrorCode.GET_VARIABLE_FAILURE, e);
            }
        } else {
            try {
                containerObj = (ObjectReference)containerNode.getProxiedVariable();
                evaluationEngine = context.getProvider(IEvaluationProvider.class);
                if (DebugSettings.getCurrent().showLogicalStructure && evaluationEngine != null) {
                    logicalStructure = JavaLogicalStructureManager.getLogicalStructure(containerObj);
                    while (logicalStructure != null) {
                        valueExpression = logicalStructure.getValueExpression();
                        logicalVariables = logicalStructure.getVariables();
                        try {
                            if (valueExpression != null) {
                                value = logicalStructure.getValue(containerObj, containerNode.getThread(), evaluationEngine);
                                if (value instanceof ObjectReference) {
                                    containerObj = (ObjectReference)value;
                                    logicalStructure = JavaLogicalStructureManager.getLogicalStructure(containerObj);
                                    continue;
                                }
                                childrenList = Arrays.asList(new Variable[]{new Variable("logical structure", (Value)value)});
                            } else if (logicalVariables != null && logicalVariables.length > 0) {
                                for (JavaLogicalStructure.LogicalVariable logicalVariable : logicalVariables) {
                                    name = logicalVariable.getName();
                                    value = logicalVariable.getValue(containerObj, containerNode.getThread(), evaluationEngine);
                                    childrenList.add(new Variable(name, value));
                                }
                            }
                        }
                        catch (IllegalArgumentException | InterruptedException | CancellationException | ExecutionException e) {
                            VariablesRequestHandler.logger.log(Level.WARNING, String.format("Failed to get the logical structure for the type %s, fall back to the Object view.", new Object[]{containerObj.type().name()}), e);
                        }
                        logicalStructure = null;
                    }
                }
                if (childrenList.isEmpty() && VariableUtils.hasChildren(containerObj, showStaticVariables)) {
                    childrenList = varArgs.count > 0 ? VariableUtils.listFieldVariables(containerObj, varArgs.start, varArgs.count) : VariableUtils.listFieldVariables(containerObj, showStaticVariables);
                }
            }
            catch (AbsentInformationException e) {
                throw AdapterUtils.createCompletionException(String.format("Failed to get variables. Reason: %s", new Object[]{e.toString()}), ErrorCode.GET_VARIABLE_FAILURE, e);
            }
        }
lbl67:
        // 3 sources

        duplicateNames = this.getDuplicateNames((Collection<String>)childrenList.stream().map((Function<Variable, String>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)Ljava/lang/Object;, lambda$handle$0(com.microsoft.java.debug.core.adapter.variables.Variable ), (Lcom/microsoft/java/debug/core/adapter/variables/Variable;)Ljava/lang/String;)()).collect(Collectors.toList()));
        variableNameMap = new HashMap<K, V>();
        if (!duplicateNames.isEmpty()) {
            duplicateVars = childrenList.stream().filter((Predicate<Variable>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)Z, lambda$handle$1(java.util.Set com.microsoft.java.debug.core.adapter.variables.Variable ), (Lcom/microsoft/java/debug/core/adapter/variables/Variable;)Z)(duplicateNames)).collect(Collectors.groupingBy((Function<Variable, String>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)Ljava/lang/Object;, lambda$handle$2(com.microsoft.java.debug.core.adapter.variables.Variable ), (Lcom/microsoft/java/debug/core/adapter/variables/Variable;)Ljava/lang/String;)(), Collectors.toList()));
            duplicateVars.forEach((BiConsumer<String, List>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;Ljava/lang/Object;)V, lambda$handle$3(com.microsoft.java.debug.core.adapter.variables.IVariableFormatter java.util.Map java.util.Map java.lang.String java.util.List ), (Ljava/lang/String;Ljava/util/List;)V)((IVariableFormatter)variableFormatter, options, variableNameMap));
        }
        for (Variable javaVariable : childrenList) {
            value = javaVariable.value;
            name = javaVariable.name;
            if (variableNameMap.containsKey(javaVariable)) {
                name = (String)variableNameMap.get(javaVariable);
            }
            indexedVariables = -1;
            if (value instanceof ArrayReference) {
                indexedVariables = ((ArrayReference)value).length();
            } else if (value instanceof ObjectReference && DebugSettings.getCurrent().showLogicalStructure && context.getProvider(IEvaluationProvider.class) != null && JavaLogicalStructureManager.isIndexedVariable((ObjectReference)value)) {
                evaluationEngine = context.getProvider(IEvaluationProvider.class);
                try {
                    sizeValue = JavaLogicalStructureManager.getLogicalSize((ObjectReference)value, containerNode.getThread(), evaluationEngine);
                    if (sizeValue != null && sizeValue instanceof IntegerValue) {
                        indexedVariables = ((IntegerValue)sizeValue).value();
                    }
                }
                catch (IllegalArgumentException | InterruptedException | UnsupportedOperationException | CancellationException | ExecutionException e) {
                    VariablesRequestHandler.logger.log(Level.INFO, String.format("Failed to get the logical size for the type %s.", new Object[]{value.type().name()}), e);
                }
            }
            referenceId = 0;
            if (indexedVariables > 0 || indexedVariables < 0 && VariableUtils.hasChildren(value, showStaticVariables)) {
                varProxy = new VariableProxy(containerNode.getThread(), containerNode.getScope(), value);
                referenceId = context.getRecyclableIdPool().addObject(containerNode.getThreadId(), varProxy);
            }
            typedVariables = new Types.Variable(name, variableFormatter.valueToString(value, options), variableFormatter.typeToString(value == null ? null : value.type(), options), referenceId, null);
            typedVariables.indexedVariables = Math.max(indexedVariables, 0);
            list.add(typedVariables);
        }
        response.body = new Responses.VariablesResponseBody(list);
        return CompletableFuture.completedFuture(response);
    }

    private Set<String> getDuplicateNames(Collection<String> list) {
        HashSet<String> result = new HashSet<String>();
        HashSet<String> set = new HashSet<String>();
        for (String item : list) {
            if (!set.contains(item)) {
                set.add(item);
                continue;
            }
            result.add(item);
        }
        return result;
    }

    private static /* synthetic */ void lambda$handle$3(IVariableFormatter variableFormatter, Map options, Map variableNameMap, String k, List duplicateVariables) {
        Type declarationType;
        HashSet<String> declarationTypeNames = new HashSet<String>();
        boolean declarationTypeNameConflict = false;
        for (Variable javaVariable : duplicateVariables) {
            declarationType = javaVariable.getDeclaringType();
            if (declarationType == null) continue;
            String declarationTypeName = variableFormatter.typeToString(declarationType, options);
            String compositeName = String.format("%s (%s)", javaVariable.name, declarationTypeName);
            if (!declarationTypeNames.add(compositeName)) {
                declarationTypeNameConflict = true;
                break;
            }
            variableNameMap.put(javaVariable, compositeName);
        }
        if (declarationTypeNameConflict) {
            for (Variable javaVariable : duplicateVariables) {
                declarationType = javaVariable.getDeclaringType();
                if (declarationType == null) continue;
                variableNameMap.put(javaVariable, String.format("%s (%s)", javaVariable.name, declarationType.name()));
            }
        }
    }

    private static /* synthetic */ String lambda$handle$2(Variable var) {
        return var.name;
    }

    private static /* synthetic */ boolean lambda$handle$1(Set duplicateNames, Variable var) {
        return duplicateNames.contains(var.name);
    }

    private static /* synthetic */ String lambda$handle$0(Variable var) {
        return var.name;
    }
}

