/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.java.debug.core.adapter.handler;

import com.microsoft.java.debug.core.DebugUtility;
import com.microsoft.java.debug.core.JdiExceptionReference;
import com.microsoft.java.debug.core.adapter.AdapterUtils;
import com.microsoft.java.debug.core.adapter.ErrorCode;
import com.microsoft.java.debug.core.adapter.IDebugAdapterContext;
import com.microsoft.java.debug.core.adapter.IDebugRequestHandler;
import com.microsoft.java.debug.core.protocol.Messages;
import com.microsoft.java.debug.core.protocol.Requests;
import com.microsoft.java.debug.core.protocol.Responses;
import com.microsoft.java.debug.core.protocol.Types;
import com.sun.jdi.ClassNotLoadedException;
import com.sun.jdi.IncompatibleThreadStateException;
import com.sun.jdi.InvalidTypeException;
import com.sun.jdi.InvocationException;
import com.sun.jdi.Method;
import com.sun.jdi.ThreadReference;
import com.sun.jdi.Value;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.CompletableFuture;
import java.util.logging.Level;
import java.util.logging.Logger;

public class ExceptionInfoRequestHandler
implements IDebugRequestHandler {
    protected static final Logger logger = Logger.getLogger("java-debug");

    @Override
    public List<Requests.Command> getTargetCommands() {
        return Arrays.asList(Requests.Command.EXCEPTIONINFO);
    }

    @Override
    public CompletableFuture<Messages.Response> handle(Requests.Command command, Requests.Arguments arguments, Messages.Response response, IDebugAdapterContext context) {
        String typeName;
        Requests.ExceptionInfoArguments exceptionInfoArgs = (Requests.ExceptionInfoArguments)arguments;
        ThreadReference thread = DebugUtility.getThread(context.getDebugSession(), exceptionInfoArgs.threadId);
        if (thread == null) {
            throw AdapterUtils.createCompletionException("Thread " + exceptionInfoArgs.threadId + " doesn't exist.", ErrorCode.EXCEPTION_INFO_FAILURE);
        }
        JdiExceptionReference jdiException = context.getExceptionManager().getException(exceptionInfoArgs.threadId);
        if (jdiException == null) {
            throw AdapterUtils.createCompletionException("No exception exists in thread " + exceptionInfoArgs.threadId, ErrorCode.EXCEPTION_INFO_FAILURE);
        }
        Method toStringMethod = null;
        for (Method method : jdiException.exception.referenceType().allMethods()) {
            if (!Objects.equals("toString", method.name()) || !Objects.equals("()Ljava/lang/String;", method.signature())) continue;
            toStringMethod = method;
            break;
        }
        String exceptionToString = typeName = jdiException.exception.type().name();
        if (toStringMethod != null) {
            try {
                Value returnValue = jdiException.exception.invokeMethod(thread, toStringMethod, Collections.EMPTY_LIST, 1);
                exceptionToString = returnValue.toString();
            }
            catch (ClassNotLoadedException | IncompatibleThreadStateException | InvalidTypeException | InvocationException e) {
                logger.log(Level.SEVERE, String.format("Failed to get the return value of the method Exception.toString(): %s", e.toString(), e));
            }
        }
        response.body = new Responses.ExceptionInfoResponse(typeName, exceptionToString, jdiException.isUncaught ? Types.ExceptionBreakMode.USERUNHANDLED : Types.ExceptionBreakMode.ALWAYS);
        return CompletableFuture.completedFuture(response);
    }
}

