/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.java.debug.core.adapter.variables;

import com.sun.jdi.ThreadReference;
import java.util.Objects;

public class VariableProxy {
    private final ThreadReference thread;
    private final String scopeName;
    private Object variable;
    private int hashCode;

    public VariableProxy(ThreadReference thread, String scopeName, Object variable) {
        this.thread = thread;
        this.scopeName = scopeName;
        this.variable = variable;
        this.hashCode = Objects.hash(scopeName, thread, variable);
    }

    public String toString() {
        return String.format("%s %s", String.valueOf(this.variable), this.scopeName);
    }

    public ThreadReference getThread() {
        return this.thread;
    }

    public int hashCode() {
        return this.hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        VariableProxy other = (VariableProxy)obj;
        return Objects.equals(this.scopeName, other.scopeName) && Objects.equals(this.getThreadId(), other.getThreadId()) && Objects.equals(this.variable, other.variable);
    }

    public long getThreadId() {
        return this.thread.uniqueID();
    }

    public String getScope() {
        return this.scopeName;
    }

    public Object getProxiedVariable() {
        return this.variable;
    }
}

