/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.java.debug.core;

import com.google.gson.JsonSyntaxException;
import com.microsoft.java.debug.core.protocol.JsonUtils;
import java.util.logging.Logger;

public final class DebugSettings {
    private static final Logger logger = Logger.getLogger("java-debug");
    private static DebugSettings current = new DebugSettings();
    public int maxStringLength = 0;
    public boolean showStaticVariables = false;
    public boolean showQualifiedNames = false;
    public boolean showHex = false;
    public boolean showLogicalStructure = true;
    public boolean showToString = true;
    public String logLevel;
    public String javaHome;
    public HotCodeReplace hotCodeReplace = HotCodeReplace.MANUAL;

    public static DebugSettings getCurrent() {
        return current;
    }

    public void updateSettings(String jsonSettings) {
        try {
            current = JsonUtils.fromJson(jsonSettings, DebugSettings.class);
        }
        catch (JsonSyntaxException ex) {
            logger.severe(String.format("Invalid json for debugSettings: %s, %s", jsonSettings, ex.getMessage()));
        }
    }

    private DebugSettings() {
    }

    public static enum HotCodeReplace {
        MANUAL,
        AUTO,
        NEVER;

    }
}

