/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.java.debug.core.adapter.handler;

import com.google.gson.JsonObject;
import com.microsoft.java.debug.core.DebugException;
import com.microsoft.java.debug.core.DebugSession;
import com.microsoft.java.debug.core.DebugUtility;
import com.microsoft.java.debug.core.IDebugSession;
import com.microsoft.java.debug.core.adapter.ErrorCode;
import com.microsoft.java.debug.core.adapter.ICompletionsProvider;
import com.microsoft.java.debug.core.adapter.IDebugAdapterContext;
import com.microsoft.java.debug.core.adapter.IEvaluationProvider;
import com.microsoft.java.debug.core.adapter.IHotCodeReplaceProvider;
import com.microsoft.java.debug.core.adapter.ISourceLookUpProvider;
import com.microsoft.java.debug.core.adapter.IVirtualMachineManagerProvider;
import com.microsoft.java.debug.core.adapter.handler.ILaunchDelegate;
import com.microsoft.java.debug.core.adapter.handler.LaunchRequestHandler;
import com.microsoft.java.debug.core.protocol.Events;
import com.microsoft.java.debug.core.protocol.JsonUtils;
import com.microsoft.java.debug.core.protocol.Messages;
import com.microsoft.java.debug.core.protocol.Requests;
import com.sun.jdi.VirtualMachine;
import com.sun.jdi.connect.Connector;
import com.sun.jdi.connect.IllegalConnectorArgumentsException;
import com.sun.jdi.connect.ListeningConnector;
import com.sun.jdi.connect.TransportTimeoutException;
import com.sun.jdi.connect.VMStartException;
import java.io.IOException;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionException;
import java.util.logging.Logger;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.SystemUtils;

public class LaunchWithDebuggingDelegate
implements ILaunchDelegate {
    protected static final Logger logger = Logger.getLogger("java-debug");
    private static final int ATTACH_TERMINAL_TIMEOUT = 20000;
    private static final String TERMINAL_TITLE = "Java Debug Console";
    protected static final long RUNINTERMINAL_TIMEOUT = 10000L;

    @Override
    public CompletableFuture<Messages.Response> launchInTerminal(Requests.LaunchArguments launchArguments, Messages.Response response, IDebugAdapterContext context) {
        CompletableFuture<Messages.Response> resultFuture = new CompletableFuture<Messages.Response>();
        IVirtualMachineManagerProvider vmProvider = context.getProvider(IVirtualMachineManagerProvider.class);
        String launchInTerminalErrorFormat = "Failed to launch debuggee in terminal. Reason: %s";
        try {
            List<ListeningConnector> connectors = vmProvider.getVirtualMachineManager().listeningConnectors();
            ListeningConnector listenConnector = connectors.get(0);
            Map<String, Connector.Argument> args = listenConnector.defaultArguments();
            ((Connector.IntegerArgument)args.get("timeout")).setValue(20000);
            String address = listenConnector.startListening(args);
            String[] cmds = LaunchRequestHandler.constructLaunchCommands(launchArguments, false, address);
            Requests.RunInTerminalRequestArguments requestArgs = null;
            requestArgs = launchArguments.console == Requests.CONSOLE.integratedTerminal ? Requests.RunInTerminalRequestArguments.createIntegratedTerminal(cmds, launchArguments.cwd, launchArguments.env, TERMINAL_TITLE) : Requests.RunInTerminalRequestArguments.createExternalTerminal(cmds, launchArguments.cwd, launchArguments.env, TERMINAL_TITLE);
            Messages.Request request = new Messages.Request(Requests.Command.RUNINTERMINAL.getName(), (JsonObject)JsonUtils.toJsonTree(requestArgs, Requests.RunInTerminalRequestArguments.class));
            context.getProtocolServer().sendRequest(request, 10000L).whenComplete((runResponse, ex) -> {
                if (runResponse != null) {
                    if (runResponse.success) {
                        try {
                            VirtualMachine vm = listenConnector.accept(args);
                            context.setDebugSession(new DebugSession(vm));
                            logger.info("Launching debuggee in terminal console succeeded.");
                            resultFuture.complete(response);
                        }
                        catch (TransportTimeoutException e) {
                            int commandLength = StringUtils.length((CharSequence)launchArguments.cwd) + 1;
                            for (String cmd : cmds) {
                                commandLength += StringUtils.length((CharSequence)cmd) + 1;
                            }
                            int threshold = SystemUtils.IS_OS_WINDOWS ? 8092 : 32768;
                            String errorMessage = String.format("Failed to launch debuggee in terminal. Reason: %s", e.toString());
                            if (commandLength >= threshold) {
                                errorMessage = "Failed to launch debuggee in terminal. The possible reason is the command line too long. More details: " + e.toString();
                                logger.severe(errorMessage + "\r\nThe estimated command line length is " + commandLength + ". Try to enable shortenCommandLine option in the debug launch configuration.");
                            }
                            resultFuture.completeExceptionally(new DebugException(errorMessage, ErrorCode.LAUNCH_IN_TERMINAL_FAILURE.getId()));
                        }
                        catch (IllegalConnectorArgumentsException | IOException e) {
                            resultFuture.completeExceptionally(new DebugException(String.format("Failed to launch debuggee in terminal. Reason: %s", e.toString()), ErrorCode.LAUNCH_IN_TERMINAL_FAILURE.getId()));
                        }
                    } else {
                        resultFuture.completeExceptionally(new DebugException(String.format("Failed to launch debuggee in terminal. Reason: %s", runResponse.message), ErrorCode.LAUNCH_IN_TERMINAL_FAILURE.getId()));
                    }
                } else {
                    if (ex instanceof CompletionException && ex.getCause() != null) {
                        ex = ex.getCause();
                    }
                    String errorMessage = String.format("Failed to launch debuggee in terminal. Reason: %s", ex != null ? ex.toString() : "Null response");
                    resultFuture.completeExceptionally(new DebugException(String.format("Failed to launch debuggee in terminal. Reason: %s", errorMessage), ErrorCode.LAUNCH_IN_TERMINAL_FAILURE.getId()));
                }
            });
        }
        catch (IllegalConnectorArgumentsException | IOException e) {
            resultFuture.completeExceptionally(new DebugException(String.format("Failed to launch debuggee in terminal. Reason: %s", e.toString()), ErrorCode.LAUNCH_IN_TERMINAL_FAILURE.getId()));
        }
        return resultFuture;
    }

    @Override
    public Process launch(Requests.LaunchArguments launchArguments, IDebugAdapterContext context) throws IOException, IllegalConnectorArgumentsException, VMStartException {
        IVirtualMachineManagerProvider vmProvider = context.getProvider(IVirtualMachineManagerProvider.class);
        IDebugSession debugSession = DebugUtility.launch(vmProvider.getVirtualMachineManager(), launchArguments.mainClass, launchArguments.args, launchArguments.vmArgs, Arrays.asList(launchArguments.modulePaths), Arrays.asList(launchArguments.classPaths), launchArguments.cwd, LaunchRequestHandler.constructEnvironmentVariables(launchArguments));
        context.setDebugSession(debugSession);
        logger.info("Launching debuggee VM succeeded.");
        return debugSession.process();
    }

    @Override
    public void postLaunch(Requests.LaunchArguments launchArguments, IDebugAdapterContext context) {
        HashMap<String, Object> options = new HashMap<String, Object>();
        options.put("debuggeeEncoding", context.getDebuggeeEncoding());
        if (launchArguments.projectName != null) {
            options.put("projectName", launchArguments.projectName);
        }
        if (launchArguments.mainClass != null) {
            options.put("mainClass", launchArguments.mainClass);
        }
        ISourceLookUpProvider sourceProvider = context.getProvider(ISourceLookUpProvider.class);
        sourceProvider.initialize(context, options);
        IEvaluationProvider evaluationProvider = context.getProvider(IEvaluationProvider.class);
        evaluationProvider.initialize(context, options);
        IHotCodeReplaceProvider hcrProvider = context.getProvider(IHotCodeReplaceProvider.class);
        hcrProvider.initialize(context, options);
        ICompletionsProvider completionsProvider = context.getProvider(ICompletionsProvider.class);
        completionsProvider.initialize(context, options);
        context.getProtocolServer().sendEvent(new Events.InitializedEvent());
    }

    @Override
    public void preLaunch(Requests.LaunchArguments launchArguments, IDebugAdapterContext context) {
        context.setAttached(false);
        context.setSourcePaths(launchArguments.sourcePaths);
        context.setVmStopOnEntry(launchArguments.stopOnEntry);
        context.setMainClass(LaunchRequestHandler.parseMainClassWithoutModuleName(launchArguments.mainClass));
        context.setStepFilters(launchArguments.stepFilters);
    }
}

