/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.java.debug.core.protocol;

import com.google.gson.JsonObject;

public class Messages {

    public static class Event
    extends ProtocolMessage {
        public String event;
        public Object body;

        public Event() {
            super("event");
        }

        public Event(Event m) {
            super("event");
            this.seq = m.seq;
            this.event = m.event;
            this.body = m.body;
        }

        public Event(String type, Object body) {
            super("event");
            this.event = type;
            this.body = body;
        }
    }

    public static class Response
    extends ProtocolMessage {
        public boolean success;
        public String message;
        public int request_seq;
        public String command;
        public Object body;

        public Response() {
            super("response");
        }

        public Response(String message) {
            super("response");
            this.success = false;
            this.message = message;
        }

        public Response(boolean success, String message) {
            super("response");
            this.success = success;
            this.message = message;
        }

        public Response(Response response) {
            super("response");
            this.seq = response.seq;
            this.success = response.success;
            this.message = response.message;
            this.request_seq = response.request_seq;
            this.command = response.command;
            this.body = response.body;
        }

        public Response(int requestSeq, String command) {
            super("response");
            this.request_seq = requestSeq;
            this.command = command;
        }

        public Response(int requestSeq, String command, boolean success) {
            this(requestSeq, command);
            this.success = success;
        }

        public Response(int requestSeq, String command, boolean success, String message) {
            this(requestSeq, command);
            this.success = success;
            this.message = message;
        }
    }

    public static class Request
    extends ProtocolMessage {
        public String command;
        public JsonObject arguments;

        public Request(int id, String cmd, JsonObject arg) {
            super("request");
            this.seq = id;
            this.command = cmd;
            this.arguments = arg;
        }

        public Request(String cmd, JsonObject arg) {
            super("request");
            this.command = cmd;
            this.arguments = arg;
        }
    }

    public static class ProtocolMessage {
        public int seq;
        public String type;

        public ProtocolMessage(String type) {
            this.type = type;
        }
    }
}

