/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.java.debug.core.adapter;

import java.util.HashMap;
import java.util.concurrent.atomic.AtomicInteger;

public class IdCollection<T> {
    private int startId;
    private AtomicInteger nextId;
    private HashMap<Integer, T> idMap;
    private HashMap<T, Integer> reverseMap;

    public IdCollection() {
        this(1);
    }

    public IdCollection(int startId) {
        this.startId = startId;
        this.nextId = new AtomicInteger(startId);
        this.idMap = new HashMap();
        this.reverseMap = new HashMap();
    }

    public void reset() {
        this.nextId.set(this.startId);
        this.idMap.clear();
        this.reverseMap.clear();
    }

    public int create(T value) {
        if (this.reverseMap.containsKey(value)) {
            return this.reverseMap.get(value);
        }
        int id = this.nextId.getAndIncrement();
        this.idMap.put(id, value);
        this.reverseMap.put(value, id);
        return id;
    }

    public T get(int id) {
        return this.idMap.get(id);
    }

    public T remove(int id) {
        T target = this.idMap.remove(id);
        if (target != null) {
            this.reverseMap.remove(target);
        }
        return target;
    }
}

