/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.java.debug.core.adapter.handler;

import com.microsoft.java.debug.core.DebugUtility;
import com.microsoft.java.debug.core.adapter.AdapterUtils;
import com.microsoft.java.debug.core.adapter.ErrorCode;
import com.microsoft.java.debug.core.adapter.IDebugAdapterContext;
import com.microsoft.java.debug.core.adapter.IDebugRequestHandler;
import com.microsoft.java.debug.core.adapter.IEvaluationProvider;
import com.microsoft.java.debug.core.protocol.Events;
import com.microsoft.java.debug.core.protocol.Messages;
import com.microsoft.java.debug.core.protocol.Requests;
import com.microsoft.java.debug.core.protocol.Responses;
import com.microsoft.java.debug.core.protocol.Types;
import com.sun.jdi.ObjectCollectedException;
import com.sun.jdi.ThreadReference;
import com.sun.jdi.VMDisconnectedException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.concurrent.CompletableFuture;

public class ThreadsRequestHandler
implements IDebugRequestHandler {
    @Override
    public List<Requests.Command> getTargetCommands() {
        return Arrays.asList(Requests.Command.THREADS, Requests.Command.PAUSE, Requests.Command.CONTINUE, Requests.Command.CONTINUEALL, Requests.Command.CONTINUEOTHERS, Requests.Command.PAUSEALL, Requests.Command.PAUSEOTHERS);
    }

    @Override
    public CompletableFuture<Messages.Response> handle(Requests.Command command, Requests.Arguments arguments, Messages.Response response, IDebugAdapterContext context) {
        if (context.getDebugSession() == null) {
            return AdapterUtils.createAsyncErrorResponse(response, ErrorCode.EMPTY_DEBUG_SESSION, "Debug Session doesn't exist.");
        }
        switch (command) {
            case THREADS: {
                return this.threads((Requests.ThreadsArguments)arguments, response, context);
            }
            case PAUSE: {
                return this.pause((Requests.PauseArguments)arguments, response, context);
            }
            case CONTINUE: {
                return this.resume((Requests.ContinueArguments)arguments, response, context);
            }
            case CONTINUEALL: {
                return this.resumeAll((Requests.ThreadOperationArguments)arguments, response, context);
            }
            case CONTINUEOTHERS: {
                return this.resumeOthers((Requests.ThreadOperationArguments)arguments, response, context);
            }
            case PAUSEALL: {
                return this.pauseAll((Requests.ThreadOperationArguments)arguments, response, context);
            }
            case PAUSEOTHERS: {
                return this.pauseOthers((Requests.ThreadOperationArguments)arguments, response, context);
            }
        }
        return AdapterUtils.createAsyncErrorResponse(response, ErrorCode.UNRECOGNIZED_REQUEST_FAILURE, String.format("Unrecognized request: { _request: %s }", command.toString()));
    }

    private CompletableFuture<Messages.Response> threads(Requests.ThreadsArguments arguments, Messages.Response response, IDebugAdapterContext context) {
        ArrayList<Types.Thread> threads = new ArrayList<Types.Thread>();
        try {
            for (ThreadReference thread : context.getDebugSession().getAllThreads()) {
                if (thread.isCollected()) continue;
                Types.Thread clientThread = new Types.Thread(thread.uniqueID(), "Thread [" + thread.name() + "]");
                threads.add(clientThread);
            }
        }
        catch (ObjectCollectedException objectCollectedException) {
            // empty catch block
        }
        response.body = new Responses.ThreadsResponseBody(threads);
        return CompletableFuture.completedFuture(response);
    }

    private CompletableFuture<Messages.Response> pause(Requests.PauseArguments arguments, Messages.Response response, IDebugAdapterContext context) {
        ThreadReference thread = DebugUtility.getThread(context.getDebugSession(), arguments.threadId);
        if (thread != null) {
            thread.suspend();
            context.getProtocolServer().sendEvent(new Events.StoppedEvent("pause", arguments.threadId));
        } else {
            context.getDebugSession().suspend();
            context.getProtocolServer().sendEvent(new Events.StoppedEvent("pause", arguments.threadId, true));
        }
        return CompletableFuture.completedFuture(response);
    }

    private CompletableFuture<Messages.Response> resume(Requests.ContinueArguments arguments, Messages.Response response, IDebugAdapterContext context) {
        boolean allThreadsContinued = true;
        ThreadReference thread = DebugUtility.getThread(context.getDebugSession(), arguments.threadId);
        if (thread != null) {
            context.getExceptionManager().removeException(arguments.threadId);
            allThreadsContinued = false;
            DebugUtility.resumeThread(thread);
            ThreadsRequestHandler.checkThreadRunningAndRecycleIds(thread, context);
        } else {
            context.getExceptionManager().removeAllExceptions();
            context.getDebugSession().resume();
            context.getRecyclableIdPool().removeAllObjects();
        }
        response.body = new Responses.ContinueResponseBody(allThreadsContinued);
        return CompletableFuture.completedFuture(response);
    }

    private CompletableFuture<Messages.Response> resumeAll(Requests.ThreadOperationArguments arguments, Messages.Response response, IDebugAdapterContext context) {
        context.getExceptionManager().removeAllExceptions();
        context.getDebugSession().resume();
        context.getProtocolServer().sendEvent(new Events.ContinuedEvent(arguments.threadId, true));
        context.getRecyclableIdPool().removeAllObjects();
        return CompletableFuture.completedFuture(response);
    }

    private CompletableFuture<Messages.Response> resumeOthers(Requests.ThreadOperationArguments arguments, Messages.Response response, IDebugAdapterContext context) {
        List<ThreadReference> threads = DebugUtility.getAllThreadsSafely(context.getDebugSession());
        for (ThreadReference thread : threads) {
            long threadId = thread.uniqueID();
            if (threadId == arguments.threadId || !thread.isSuspended()) continue;
            context.getExceptionManager().removeException(threadId);
            DebugUtility.resumeThread(thread);
            context.getProtocolServer().sendEvent(new Events.ContinuedEvent(threadId));
            ThreadsRequestHandler.checkThreadRunningAndRecycleIds(thread, context);
        }
        return CompletableFuture.completedFuture(response);
    }

    private CompletableFuture<Messages.Response> pauseAll(Requests.ThreadOperationArguments arguments, Messages.Response response, IDebugAdapterContext context) {
        context.getDebugSession().suspend();
        context.getProtocolServer().sendEvent(new Events.StoppedEvent("pause", arguments.threadId, true));
        return CompletableFuture.completedFuture(response);
    }

    private CompletableFuture<Messages.Response> pauseOthers(Requests.ThreadOperationArguments arguments, Messages.Response response, IDebugAdapterContext context) {
        List<ThreadReference> threads = DebugUtility.getAllThreadsSafely(context.getDebugSession());
        for (ThreadReference thread : threads) {
            long threadId = thread.uniqueID();
            if (threadId == arguments.threadId || thread.isCollected() || thread.isSuspended()) continue;
            thread.suspend();
            context.getProtocolServer().sendEvent(new Events.StoppedEvent("pause", threadId));
        }
        return CompletableFuture.completedFuture(response);
    }

    public static void checkThreadRunningAndRecycleIds(ThreadReference thread, IDebugAdapterContext context) {
        try {
            boolean allThreadsRunning;
            IEvaluationProvider engine = context.getProvider(IEvaluationProvider.class);
            engine.clearState(thread);
            boolean bl = allThreadsRunning = !DebugUtility.getAllThreadsSafely(context.getDebugSession()).stream().anyMatch(ThreadReference::isSuspended);
            if (allThreadsRunning) {
                context.getRecyclableIdPool().removeAllObjects();
            } else {
                context.getRecyclableIdPool().removeObjectsByOwner(thread.uniqueID());
            }
        }
        catch (VMDisconnectedException ex) {
            context.getRecyclableIdPool().removeAllObjects();
        }
        catch (ObjectCollectedException collectedEx) {
            context.getRecyclableIdPool().removeObjectsByOwner(thread.uniqueID());
        }
    }
}

