/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.java.debug.core.adapter.variables;

import com.microsoft.java.debug.core.adapter.IEvaluationProvider;
import com.sun.jdi.ClassType;
import com.sun.jdi.Field;
import com.sun.jdi.InterfaceType;
import com.sun.jdi.ObjectReference;
import com.sun.jdi.ThreadReference;
import com.sun.jdi.Type;
import com.sun.jdi.Value;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.CancellationException;
import java.util.concurrent.ExecutionException;

public class JavaLogicalStructure {
    private final String type;
    private final String fullyQualifiedName;
    private final LogicalStructureExpression valueExpression;
    private final LogicalStructureExpression sizeExpression;
    private final LogicalVariable[] variables;

    public JavaLogicalStructure(String type, LogicalStructureExpression valueExpression, LogicalStructureExpression sizeExpression, LogicalVariable[] variables) {
        this(type, type, valueExpression, sizeExpression, variables);
    }

    public JavaLogicalStructure(String type, String fullyQualifiedName, LogicalStructureExpression valueExpression, LogicalStructureExpression sizeExpression, LogicalVariable[] variables) {
        this.valueExpression = valueExpression;
        this.type = type;
        this.fullyQualifiedName = fullyQualifiedName;
        this.sizeExpression = sizeExpression;
        this.variables = variables;
    }

    public String getType() {
        return this.type;
    }

    public String getFullyQualifiedName() {
        return this.fullyQualifiedName;
    }

    public LogicalStructureExpression getValueExpression() {
        return this.valueExpression;
    }

    public LogicalStructureExpression getSizeExpression() {
        return this.sizeExpression;
    }

    public LogicalVariable[] getVariables() {
        return this.variables;
    }

    public boolean providesLogicalStructure(ObjectReference obj) {
        Type variableType = obj.type();
        if (!(variableType instanceof ClassType)) {
            return false;
        }
        for (ClassType classType = (ClassType)variableType; classType != null; classType = classType.superclass()) {
            if (!Objects.equals(this.type, classType.name())) continue;
            return true;
        }
        List<InterfaceType> interfaceTypes = ((ClassType)variableType).allInterfaces();
        for (InterfaceType interfaceType : interfaceTypes) {
            if (!Objects.equals(this.type, interfaceType.name())) continue;
            return true;
        }
        return false;
    }

    public Value getSize(ObjectReference thisObject, ThreadReference thread, IEvaluationProvider evaluationEngine) throws CancellationException, InterruptedException, IllegalArgumentException, ExecutionException, UnsupportedOperationException {
        if (this.sizeExpression == null) {
            throw new UnsupportedOperationException("The object hasn't defined the logical size operation.");
        }
        return JavaLogicalStructure.getValue(thisObject, this.sizeExpression, thread, evaluationEngine);
    }

    public Value getValue(ObjectReference thisObject, ThreadReference thread, IEvaluationProvider evaluationEngine) throws CancellationException, IllegalArgumentException, InterruptedException, ExecutionException {
        return JavaLogicalStructure.getValue(thisObject, this.valueExpression, thread, evaluationEngine);
    }

    private static Value getValue(ObjectReference thisObject, LogicalStructureExpression expression, ThreadReference thread, IEvaluationProvider evaluationEngine) throws CancellationException, IllegalArgumentException, InterruptedException, ExecutionException {
        if (expression.type == LogicalStructureExpressionType.METHOD) {
            if (expression.value == null || expression.value.length < 2) {
                throw new IllegalArgumentException("The method expression should contain at least methodName and methodSignature!");
            }
            return evaluationEngine.invokeMethod(thisObject, expression.value[0], expression.value[1], null, thread, false).get();
        }
        if (expression.type == LogicalStructureExpressionType.FIELD) {
            if (expression.value == null || expression.value.length < 1) {
                throw new IllegalArgumentException("The field expression should contain the field name!");
            }
            return JavaLogicalStructure.getValueByField(thisObject, expression.value[0], thread);
        }
        if (expression.value == null || expression.value.length < 1) {
            throw new IllegalArgumentException("The evaluation expression should contain a valid expression statement!");
        }
        return evaluationEngine.evaluate(expression.value[0], thisObject, thread).get();
    }

    private static Value getValueByField(ObjectReference thisObject, String fieldName, ThreadReference thread) {
        Field targetField = thisObject.referenceType().fieldByName(fieldName);
        if (targetField == null) {
            return null;
        }
        return thisObject.getValue(targetField);
    }

    public static enum LogicalStructureExpressionType {
        FIELD,
        METHOD,
        EVALUATION_SNIPPET;

    }

    public static class LogicalStructureExpression {
        public LogicalStructureExpressionType type;
        public String[] value;
        public String evaluateName;
        public boolean returnUnboundedType = false;

        public LogicalStructureExpression(LogicalStructureExpressionType type, String[] value) {
            this(type, value, null);
        }

        public LogicalStructureExpression(LogicalStructureExpressionType type, String[] value, String evaluateName) {
            this.type = type;
            this.value = value;
            this.evaluateName = evaluateName;
        }

        public LogicalStructureExpression(LogicalStructureExpressionType type, String[] value, String evaluateName, boolean returnUnboundedType) {
            this.type = type;
            this.value = value;
            this.evaluateName = evaluateName;
            this.returnUnboundedType = returnUnboundedType;
        }
    }

    public static class LogicalVariable {
        private final String name;
        private final LogicalStructureExpression valueExpression;

        public LogicalVariable(String name, LogicalStructureExpression valueExpression) {
            this.name = name;
            this.valueExpression = valueExpression;
        }

        public String getName() {
            return this.name;
        }

        public Value getValue(ObjectReference thisObject, ThreadReference thread, IEvaluationProvider evaluationEngine) throws CancellationException, IllegalArgumentException, InterruptedException, ExecutionException {
            return JavaLogicalStructure.getValue(thisObject, this.valueExpression, thread, evaluationEngine);
        }

        public String getEvaluateName() {
            if (this.valueExpression == null || this.valueExpression.evaluateName == null) {
                return this.name;
            }
            return this.valueExpression.evaluateName;
        }

        public boolean returnUnboundedType() {
            return this.valueExpression != null && this.valueExpression.returnUnboundedType;
        }
    }
}

