/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.java.debug.core.protocol;

import com.microsoft.java.debug.core.protocol.Types;
import java.util.Arrays;
import java.util.Map;

public class Requests {

    public static enum Command {
        INITIALIZE("initialize", InitializeArguments.class),
        LAUNCH("launch", LaunchArguments.class),
        ATTACH("attach", AttachArguments.class),
        DISCONNECT("disconnect", DisconnectArguments.class),
        CONFIGURATIONDONE("configurationDone", ConfigurationDoneArguments.class),
        NEXT("next", NextArguments.class),
        CONTINUE("continue", ContinueArguments.class),
        STEPIN("stepIn", StepInArguments.class),
        STEPOUT("stepOut", StepOutArguments.class),
        PAUSE("pause", PauseArguments.class),
        STACKTRACE("stackTrace", StackTraceArguments.class),
        RESTARTFRAME("restartFrame", RestartFrameArguments.class),
        SCOPES("scopes", ScopesArguments.class),
        VARIABLES("variables", VariablesArguments.class),
        SETVARIABLE("setVariable", SetVariableArguments.class),
        SOURCE("source", SourceArguments.class),
        THREADS("threads", ThreadsArguments.class),
        SETBREAKPOINTS("setBreakpoints", SetBreakpointArguments.class),
        SETEXCEPTIONBREAKPOINTS("setExceptionBreakpoints", SetExceptionBreakpointsArguments.class),
        SETFUNCTIONBREAKPOINTS("setFunctionBreakpoints", SetFunctionBreakpointsArguments.class),
        EVALUATE("evaluate", EvaluateArguments.class),
        COMPLETIONS("completions", CompletionsArguments.class),
        RUNINTERMINAL("runInTerminal", RunInTerminalRequestArguments.class),
        REDEFINECLASSES("redefineClasses", RedefineClassesArguments.class),
        EXCEPTIONINFO("exceptionInfo", ExceptionInfoArguments.class),
        DATABREAKPOINTINFO("dataBreakpointInfo", DataBreakpointInfoArguments.class),
        SETDATABREAKPOINTS("setDataBreakpoints", SetDataBreakpointsArguments.class),
        CONTINUEALL("continueAll", ThreadOperationArguments.class),
        CONTINUEOTHERS("continueOthers", ThreadOperationArguments.class),
        PAUSEALL("pauseAll", ThreadOperationArguments.class),
        PAUSEOTHERS("pauseOthers", ThreadOperationArguments.class),
        UNSUPPORTED("", Arguments.class);

        private String command;
        private Class<? extends Arguments> argumentType;

        private Command(String command, Class<? extends Arguments> argumentType) {
            this.command = command;
            this.argumentType = argumentType;
        }

        public String getName() {
            return this.command;
        }

        public String toString() {
            return this.command;
        }

        public Class<? extends Arguments> getArgumentType() {
            return this.argumentType;
        }

        public static Command parse(String command) {
            Command[] found = (Command[])Arrays.stream(Command.values()).filter(cmd -> cmd.toString().equals(command)).toArray(Command[]::new);
            if (found.length > 0) {
                return found[0];
            }
            return UNSUPPORTED;
        }
    }

    public static class SetDataBreakpointsArguments
    extends Arguments {
        public Types.DataBreakpoint[] breakpoints;
    }

    public static class DataBreakpointInfoArguments
    extends Arguments {
        public int variablesReference;
        public String name;
    }

    public static class CompletionsArguments
    extends Arguments {
        public int frameId;
        public String text;
        public int line;
        public int column;
    }

    public static class RestartFrameArguments
    extends Arguments {
        public int frameId;
    }

    public static class RedefineClassesArguments
    extends Arguments {
    }

    public static class EvaluateArguments
    extends Arguments {
        public String expression;
        public int frameId;
        public String context;
        public ValueFormat format;
    }

    public static class SourceArguments
    extends Arguments {
        public int sourceReference;
    }

    public static class SetVariableArguments
    extends Arguments {
        public int variablesReference;
        public String name;
        public String value;
        public ValueFormat format;
    }

    public static class VariablesArguments
    extends Arguments {
        public int variablesReference = -1;
        public String filter;
        public int start;
        public int count;
        public ValueFormat format;
    }

    public static class ScopesArguments
    extends Arguments {
        public int frameId;
    }

    public static class ThreadOperationArguments
    extends Arguments {
        public long threadId;
    }

    public static class PauseArguments
    extends Arguments {
        public long threadId;
    }

    public static class StepOutArguments
    extends StepArguments {
    }

    public static class StepInArguments
    extends StepArguments {
        public int targetId;
    }

    public static class NextArguments
    extends StepArguments {
    }

    public static class StepArguments
    extends Arguments {
        public long threadId;
    }

    public static class ContinueArguments
    extends Arguments {
        public long threadId;
    }

    public static class ThreadsArguments
    extends Arguments {
    }

    public static class ExceptionInfoArguments
    extends Arguments {
        public long threadId;
    }

    public static class SetExceptionBreakpointsArguments
    extends Arguments {
        public String[] filters = new String[0];
    }

    public static class SetFunctionBreakpointsArguments
    extends Arguments {
        public Types.FunctionBreakpoint[] breakpoints;
    }

    public static class StackTraceArguments
    extends Arguments {
        public long threadId;
        public int startFrame;
        public int levels;
    }

    public static class SetBreakpointArguments
    extends Arguments {
        public Types.Source source;
        public int[] lines = new int[0];
        public Types.SourceBreakpoint[] breakpoints = new Types.SourceBreakpoint[0];
        public boolean sourceModified = false;
    }

    public static class ConfigurationDoneArguments
    extends Arguments {
    }

    public static class DisconnectArguments
    extends Arguments {
        public boolean terminateDebuggee = true;
        public boolean restart;
    }

    public static class RestartArguments
    extends Arguments {
    }

    public static class RunInTerminalRequestArguments
    extends Arguments {
        public String kind;
        public String title;
        public String cwd;
        public String[] args;
        public Map<String, String> env;

        private RunInTerminalRequestArguments() {
        }

        public static RunInTerminalRequestArguments createIntegratedTerminal(String[] cmds, String cwd) {
            RunInTerminalRequestArguments requestArgs = new RunInTerminalRequestArguments();
            requestArgs.args = cmds;
            requestArgs.cwd = cwd;
            requestArgs.kind = "integrated";
            return requestArgs;
        }

        public static RunInTerminalRequestArguments createIntegratedTerminal(String[] cmds, String cwd, Map<String, String> env, String title) {
            RunInTerminalRequestArguments requestArgs = RunInTerminalRequestArguments.createIntegratedTerminal(cmds, cwd);
            requestArgs.env = env;
            requestArgs.title = title;
            return requestArgs;
        }

        public static RunInTerminalRequestArguments createExternalTerminal(String[] cmds, String cwd) {
            RunInTerminalRequestArguments requestArgs = new RunInTerminalRequestArguments();
            requestArgs.args = cmds;
            requestArgs.cwd = cwd;
            requestArgs.kind = "external";
            return requestArgs;
        }

        public static RunInTerminalRequestArguments createExternalTerminal(String[] cmds, String cwd, Map<String, String> env, String title) {
            RunInTerminalRequestArguments requestArgs = RunInTerminalRequestArguments.createExternalTerminal(cmds, cwd);
            requestArgs.env = env;
            requestArgs.title = title;
            return requestArgs;
        }
    }

    public static class AttachArguments
    extends LaunchBaseArguments {
        public String hostName;
        public int port;
        public int timeout = 30000;
    }

    public static class LaunchArguments
    extends LaunchBaseArguments {
        public String mainClass;
        public String args = "";
        public String vmArgs = "";
        public String encoding = "";
        public String[] classPaths = new String[0];
        public String[] modulePaths = new String[0];
        public String cwd;
        public Map<String, String> env;
        public boolean stopOnEntry;
        public boolean noDebug = false;
        public CONSOLE console = CONSOLE.integratedTerminal;
        public ShortenApproach shortenCommandLine = ShortenApproach.NONE;
        public String launcherScript;
        public String javaExec;
    }

    public static enum ShortenApproach {
        NONE,
        JARMANIFEST,
        ARGFILE;

    }

    public static enum CONSOLE {
        internalConsole,
        integratedTerminal,
        externalTerminal;

    }

    public static class LaunchBaseArguments
    extends Arguments {
        public String type;
        public String name;
        public String request;
        public String projectName;
        public String[] sourcePaths = new String[0];
        public StepFilters stepFilters;
    }

    public static class StepFilters
    extends ClassFilters {
        @Deprecated
        public String[] classNameFilters;
        public boolean skipSynthetics;
        public boolean skipStaticInitializers;
        public boolean skipConstructors;
    }

    public static class ClassFilters {
        public String[] allowClasses = new String[0];
        public String[] skipClasses = new String[0];
    }

    public static class InitializeArguments
    extends Arguments {
        public String clientID;
        public String adapterID;
        public String pathFormat;
        public boolean linesStartAt1;
        public boolean columnsStartAt1;
        public boolean supportsVariableType;
        public boolean supportsVariablePaging;
        public boolean supportsRunInTerminalRequest;
    }

    public static class Arguments {
    }

    public static class ValueFormat {
        public boolean hex;
    }
}

