/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.java.debug.core;

import com.microsoft.java.debug.core.UsageDataSession;
import com.microsoft.java.debug.core.protocol.JsonUtils;
import java.time.Instant;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.ConcurrentLinkedQueue;

public class UsageDataStore {
    private ConcurrentLinkedQueue<Object> queue = new ConcurrentLinkedQueue();
    private static final int QUEUE_MAX_SIZE = 10000;
    private static final String DEBUG_SESSION_ID_NAME = "debugSessionId";
    private static final String DESCRIPTION_NAME = "description";
    private static final String ERROR_MESSAGE_NAME = "message";
    private static final String STACKTRACE_NAME = "stackTrace";
    private static final String SCOPE_NAME = "scope";
    private static final String TIMESTAMP_NAME = "timestamp";

    private UsageDataStore() {
    }

    public synchronized Object[] fetchAll() {
        Object[] ret = this.queue.toArray();
        this.queue.clear();
        return ret;
    }

    public static UsageDataStore getInstance() {
        return SingletonHolder.INSTANCE;
    }

    public void logSessionData(String desc, Map<String, String> props) {
        if (this.queue == null) {
            return;
        }
        HashMap<String, String> sessionEntry = new HashMap<String, String>();
        sessionEntry.put(SCOPE_NAME, "session");
        sessionEntry.put(DEBUG_SESSION_ID_NAME, UsageDataSession.getSessionGuid());
        if (desc != null) {
            sessionEntry.put(DESCRIPTION_NAME, desc);
        }
        if (props != null) {
            sessionEntry.putAll(props);
        }
        this.enqueue(sessionEntry);
    }

    public void logErrorData(String desc, Throwable th) {
        if (this.queue == null) {
            return;
        }
        HashMap<String, String> errorEntry = new HashMap<String, String>();
        errorEntry.put(SCOPE_NAME, "exception");
        errorEntry.put(DEBUG_SESSION_ID_NAME, UsageDataSession.getSessionGuid());
        if (desc != null) {
            errorEntry.put(DESCRIPTION_NAME, desc);
        }
        if (th != null) {
            errorEntry.put(ERROR_MESSAGE_NAME, th.getMessage());
            errorEntry.put(STACKTRACE_NAME, JsonUtils.toJson(th.getStackTrace()));
        }
        this.enqueue(errorEntry);
    }

    private synchronized void enqueue(Map<String, String> entry) {
        if (this.queue.size() > 10000) {
            this.queue.poll();
        }
        if (entry != null) {
            entry.put(TIMESTAMP_NAME, Instant.now().toString());
            this.queue.add(entry);
        }
    }

    private static final class SingletonHolder {
        private static final UsageDataStore INSTANCE = new UsageDataStore();

        private SingletonHolder() {
        }
    }
}

