/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.java.debug.core.adapter.handler;

import com.microsoft.java.debug.core.DebugException;
import com.microsoft.java.debug.core.IBreakpoint;
import com.microsoft.java.debug.core.IDebugSession;
import com.microsoft.java.debug.core.IEvaluatableBreakpoint;
import com.microsoft.java.debug.core.adapter.AdapterUtils;
import com.microsoft.java.debug.core.adapter.ErrorCode;
import com.microsoft.java.debug.core.adapter.HotCodeReplaceEvent;
import com.microsoft.java.debug.core.adapter.IDebugAdapterContext;
import com.microsoft.java.debug.core.adapter.IDebugRequestHandler;
import com.microsoft.java.debug.core.adapter.IEvaluationProvider;
import com.microsoft.java.debug.core.adapter.IHotCodeReplaceProvider;
import com.microsoft.java.debug.core.adapter.ISourceLookUpProvider;
import com.microsoft.java.debug.core.protocol.Events;
import com.microsoft.java.debug.core.protocol.Messages;
import com.microsoft.java.debug.core.protocol.Requests;
import com.microsoft.java.debug.core.protocol.Responses;
import com.microsoft.java.debug.core.protocol.Types;
import com.sun.jdi.BooleanValue;
import com.sun.jdi.Field;
import com.sun.jdi.ObjectReference;
import com.sun.jdi.ReferenceType;
import com.sun.jdi.StringReference;
import com.sun.jdi.ThreadReference;
import com.sun.jdi.VMDisconnectedException;
import com.sun.jdi.Value;
import com.sun.jdi.event.BreakpointEvent;
import com.sun.jdi.event.Event;
import com.sun.jdi.event.StepEvent;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.commons.io.FilenameUtils;
import org.apache.commons.lang3.StringUtils;

public class SetBreakpointsRequestHandler
implements IDebugRequestHandler {
    private static final Logger logger = Logger.getLogger("java-debug");
    private boolean registered = false;

    @Override
    public List<Requests.Command> getTargetCommands() {
        return Arrays.asList(Requests.Command.SETBREAKPOINTS);
    }

    @Override
    public void initialize(IDebugAdapterContext context) {
        IDebugRequestHandler.super.initialize(context);
        IHotCodeReplaceProvider provider = context.getProvider(IHotCodeReplaceProvider.class);
        provider.getEventHub().filter(event -> event.getEventType() == HotCodeReplaceEvent.EventType.END).subscribe(event -> {
            try {
                List classNames = (List)event.getData();
                this.reinstallBreakpoints(context, classNames);
            }
            catch (Exception e) {
                logger.severe(e.toString());
            }
        });
    }

    @Override
    public CompletableFuture<Messages.Response> handle(Requests.Command command, Requests.Arguments arguments, Messages.Response response, IDebugAdapterContext context) {
        String drivePrefix;
        if (context.getDebugSession() == null) {
            return AdapterUtils.createAsyncErrorResponse(response, ErrorCode.EMPTY_DEBUG_SESSION, "Empty debug session.");
        }
        if (!this.registered) {
            this.registered = true;
            this.registerBreakpointHandler(context);
        }
        Requests.SetBreakpointArguments bpArguments = (Requests.SetBreakpointArguments)arguments;
        String clientPath = bpArguments.source.path;
        if (AdapterUtils.isWindows() && (drivePrefix = FilenameUtils.getPrefix((String)clientPath)) != null && drivePrefix.length() >= 2 && Character.isLowerCase(drivePrefix.charAt(0)) && drivePrefix.charAt(1) == ':') {
            drivePrefix = drivePrefix.substring(0, 2);
            clientPath = clientPath.replaceFirst(drivePrefix, drivePrefix.toUpperCase());
        }
        String sourcePath = clientPath;
        if (bpArguments.source.sourceReference != 0 && context.getSourceUri(bpArguments.source.sourceReference) != null) {
            sourcePath = context.getSourceUri(bpArguments.source.sourceReference);
        } else if (StringUtils.isNotBlank((CharSequence)clientPath)) {
            sourcePath = AdapterUtils.convertPath(clientPath, AdapterUtils.isUri(clientPath), context.isDebuggerPathsAreUri());
        }
        if (StringUtils.isBlank((CharSequence)sourcePath)) {
            throw AdapterUtils.createCompletionException(String.format("Failed to setBreakpoint. Reason: '%s' is an invalid path.", bpArguments.source.path), ErrorCode.SET_BREAKPOINT_FAILURE);
        }
        try {
            ArrayList<Types.Breakpoint> res = new ArrayList<Types.Breakpoint>();
            IBreakpoint[] toAdds = this.convertClientBreakpointsToDebugger(sourcePath, bpArguments.breakpoints, context);
            IBreakpoint[] added = context.getBreakpointManager().setBreakpoints(AdapterUtils.decodeURIComponent(sourcePath), toAdds, bpArguments.sourceModified);
            for (int i = 0; i < bpArguments.breakpoints.length; ++i) {
                if (toAdds[i] == added[i] && added[i].className() != null) {
                    added[i].install().thenAccept(bp -> {
                        Events.BreakpointEvent bpEvent = new Events.BreakpointEvent("new", this.convertDebuggerBreakpointToClient((IBreakpoint)bp, context));
                        context.getProtocolServer().sendEvent(bpEvent);
                    });
                } else if (added[i].className() != null) {
                    if (toAdds[i].getHitCount() != added[i].getHitCount()) {
                        added[i].setHitCount(toAdds[i].getHitCount());
                    }
                    if (!StringUtils.equals((CharSequence)toAdds[i].getLogMessage(), (CharSequence)added[i].getLogMessage())) {
                        added[i].setLogMessage(toAdds[i].getLogMessage());
                    }
                    if (!StringUtils.equals((CharSequence)toAdds[i].getCondition(), (CharSequence)added[i].getCondition())) {
                        added[i].setCondition(toAdds[i].getCondition());
                    }
                }
                res.add(this.convertDebuggerBreakpointToClient(added[i], context));
            }
            response.body = new Responses.SetBreakpointsResponseBody(res);
            return CompletableFuture.completedFuture(response);
        }
        catch (DebugException e) {
            throw AdapterUtils.createCompletionException(String.format("Failed to setBreakpoint. Reason: '%s'", e.toString()), ErrorCode.SET_BREAKPOINT_FAILURE);
        }
    }

    private IBreakpoint getAssociatedEvaluatableBreakpoint(IDebugAdapterContext context, BreakpointEvent event) {
        return Arrays.asList(context.getBreakpointManager().getBreakpoints()).stream().filter(bp -> bp instanceof IEvaluatableBreakpoint && ((IEvaluatableBreakpoint)((Object)bp)).containsEvaluatableExpression() && bp.requests().contains(event.request())).findFirst().orElse(null);
    }

    private void registerBreakpointHandler(IDebugAdapterContext context) {
        IDebugSession debugSession = context.getDebugSession();
        if (debugSession != null) {
            debugSession.getEventHub().events().filter(debugEvent -> debugEvent.event instanceof BreakpointEvent).subscribe(debugEvent -> {
                Event event = debugEvent.event;
                if (debugEvent.eventSet.size() <= 1 || !debugEvent.eventSet.stream().anyMatch(t -> t instanceof StepEvent)) {
                    ThreadReference bpThread = ((BreakpointEvent)event).thread();
                    IEvaluationProvider engine = context.getProvider(IEvaluationProvider.class);
                    if (engine.isInEvaluation(bpThread)) {
                        return;
                    }
                    IBreakpoint expressionBP = this.getAssociatedEvaluatableBreakpoint(context, (BreakpointEvent)event);
                    if (expressionBP != null) {
                        CompletableFuture.runAsync(() -> engine.evaluateForBreakpoint((IEvaluatableBreakpoint)((Object)expressionBP), bpThread).whenComplete((value, ex) -> {
                            boolean resume = SetBreakpointsRequestHandler.handleEvaluationResult(context, bpThread, (IEvaluatableBreakpoint)((Object)expressionBP), value, ex);
                            engine.clearState(bpThread);
                            if (resume) {
                                debugEvent.eventSet.resume();
                            } else {
                                context.getProtocolServer().sendEvent(new Events.StoppedEvent("breakpoint", bpThread.uniqueID()));
                            }
                        }));
                    } else {
                        context.getProtocolServer().sendEvent(new Events.StoppedEvent("breakpoint", bpThread.uniqueID()));
                    }
                    debugEvent.shouldResume = false;
                }
            });
        }
    }

    public static boolean handleEvaluationResult(IDebugAdapterContext context, ThreadReference bpThread, IEvaluatableBreakpoint breakpoint, Value value, Throwable ex) {
        if (StringUtils.isNotBlank((CharSequence)breakpoint.getLogMessage())) {
            if (ex != null) {
                logger.log(Level.SEVERE, String.format("[Logpoint]: %s", ex.getMessage() != null ? ex.getMessage() : ex.toString()), ex);
                context.getProtocolServer().sendEvent(new Events.UserNotificationEvent(Events.UserNotificationEvent.NotificationType.ERROR, String.format("[Logpoint] Log message '%s' error: %s", breakpoint.getLogMessage(), ex.getMessage())));
            } else if (value != null && value instanceof StringReference) {
                String message = ((StringReference)value).value();
                context.getProtocolServer().sendEvent(Events.OutputEvent.createConsoleOutput(message + System.lineSeparator()));
            }
            return true;
        }
        boolean resume = false;
        boolean resultNotBoolean = false;
        if (value != null && ex == null) {
            if (value instanceof BooleanValue) {
                resume = !((BooleanValue)value).booleanValue();
            } else if (value instanceof ObjectReference && ((ObjectReference)value).type().name().equals("java.lang.Boolean")) {
                Field field = ((ReferenceType)((ObjectReference)value).type()).fieldByName("value");
                resume = !((BooleanValue)((ObjectReference)value).getValue(field)).booleanValue();
            } else {
                resultNotBoolean = true;
            }
        }
        if (resume) {
            return true;
        }
        if (!context.isVmTerminated()) {
            if (ex != null) {
                if (!(ex instanceof VMDisconnectedException) && !(ex.getCause() instanceof VMDisconnectedException)) {
                    logger.log(Level.SEVERE, String.format("[ConditionalBreakpoint]: %s", ex.getMessage() != null ? ex.getMessage() : ex.toString()), ex);
                    context.getProtocolServer().sendEvent(new Events.UserNotificationEvent(Events.UserNotificationEvent.NotificationType.ERROR, String.format("Breakpoint condition '%s' error: %s", breakpoint.getCondition(), ex.getMessage())));
                }
            } else if (value == null || resultNotBoolean) {
                context.getProtocolServer().sendEvent(new Events.UserNotificationEvent(Events.UserNotificationEvent.NotificationType.WARNING, String.format("Result of breakpoint condition '%s' is not a boolean, please correct your expression.", breakpoint.getCondition())));
            }
        }
        return false;
    }

    private Types.Breakpoint convertDebuggerBreakpointToClient(IBreakpoint breakpoint, IDebugAdapterContext context) {
        int id = (Integer)breakpoint.getProperty("id");
        boolean verified = breakpoint.getProperty("verified") != null && (Boolean)breakpoint.getProperty("verified") != false;
        int lineNumber = AdapterUtils.convertLineNumber(breakpoint.getLineNumber(), context.isDebuggerLinesStartAt1(), context.isClientLinesStartAt1());
        return new Types.Breakpoint(id, verified, lineNumber, "");
    }

    private IBreakpoint[] convertClientBreakpointsToDebugger(String sourceFile, Types.SourceBreakpoint[] sourceBreakpoints, IDebugAdapterContext context) throws DebugException {
        int[] lines = Arrays.asList(sourceBreakpoints).stream().map(sourceBreakpoint -> AdapterUtils.convertLineNumber(sourceBreakpoint.line, context.isClientLinesStartAt1(), context.isDebuggerLinesStartAt1())).mapToInt(line -> line).toArray();
        ISourceLookUpProvider sourceProvider = context.getProvider(ISourceLookUpProvider.class);
        String[] fqns = sourceProvider.getFullyQualifiedName(sourceFile, lines, null);
        IBreakpoint[] breakpoints = new IBreakpoint[lines.length];
        for (int i = 0; i < lines.length; ++i) {
            int hitCount = 0;
            try {
                hitCount = Integer.parseInt(sourceBreakpoints[i].hitCondition);
            }
            catch (NumberFormatException e) {
                hitCount = 0;
            }
            breakpoints[i] = context.getDebugSession().createBreakpoint(fqns[i], lines[i], hitCount, sourceBreakpoints[i].condition, sourceBreakpoints[i].logMessage);
            if (!sourceProvider.supportsRealtimeBreakpointVerification() || !StringUtils.isNotBlank((CharSequence)fqns[i])) continue;
            breakpoints[i].putProperty("verified", true);
        }
        return breakpoints;
    }

    private void reinstallBreakpoints(IDebugAdapterContext context, List<String> typenames) {
        IBreakpoint[] breakpoints;
        if (typenames == null || typenames.isEmpty()) {
            return;
        }
        for (IBreakpoint breakpoint : breakpoints = context.getBreakpointManager().getBreakpoints()) {
            if (!typenames.contains(breakpoint.className())) continue;
            try {
                breakpoint.close();
                breakpoint.install().thenAccept(bp -> {
                    Events.BreakpointEvent bpEvent = new Events.BreakpointEvent("new", this.convertDebuggerBreakpointToClient((IBreakpoint)bp, context));
                    context.getProtocolServer().sendEvent(bpEvent);
                });
            }
            catch (Exception e) {
                logger.log(Level.SEVERE, String.format("Remove breakpoint exception: %s", e.toString()), e);
            }
        }
    }
}

