/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.java.debug.core.adapter.handler;

import com.microsoft.java.debug.core.DebugSettings;
import com.microsoft.java.debug.core.adapter.AdapterUtils;
import com.microsoft.java.debug.core.adapter.ErrorCode;
import com.microsoft.java.debug.core.adapter.IDebugAdapterContext;
import com.microsoft.java.debug.core.adapter.IDebugRequestHandler;
import com.microsoft.java.debug.core.adapter.variables.IVariableFormatter;
import com.microsoft.java.debug.core.adapter.variables.StackFrameReference;
import com.microsoft.java.debug.core.adapter.variables.VariableProxy;
import com.microsoft.java.debug.core.adapter.variables.VariableUtils;
import com.microsoft.java.debug.core.protocol.Messages;
import com.microsoft.java.debug.core.protocol.Requests;
import com.microsoft.java.debug.core.protocol.Responses;
import com.sun.jdi.AbsentInformationException;
import com.sun.jdi.ArrayReference;
import com.sun.jdi.ArrayType;
import com.sun.jdi.ClassNotLoadedException;
import com.sun.jdi.ClassType;
import com.sun.jdi.Field;
import com.sun.jdi.InvalidTypeException;
import com.sun.jdi.LocalVariable;
import com.sun.jdi.ObjectReference;
import com.sun.jdi.ReferenceType;
import com.sun.jdi.StackFrame;
import com.sun.jdi.Type;
import com.sun.jdi.TypeComponent;
import com.sun.jdi.Value;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;

public class SetVariableRequestHandler
implements IDebugRequestHandler {
    private static final String PATTERN = "([a-zA-Z_0-9$]+)\\s*\\(([^)]+)\\)";
    private IDebugAdapterContext context = null;

    @Override
    public List<Requests.Command> getTargetCommands() {
        return Arrays.asList(Requests.Command.SETVARIABLE);
    }

    @Override
    public CompletableFuture<Messages.Response> handle(Requests.Command command, Requests.Arguments arguments, Messages.Response response, IDebugAdapterContext context) {
        Value newValue;
        String name;
        Object container;
        Map<String, Object> options;
        boolean showStaticVariables;
        block11: {
            Requests.SetVariableArguments setVarArguments = (Requests.SetVariableArguments)arguments;
            if (setVarArguments.value == null) {
                return CompletableFuture.completedFuture(response);
            }
            if (setVarArguments.variablesReference == -1) {
                throw AdapterUtils.createCompletionException("SetVariablesRequest: property 'variablesReference' is missing, null, or empty", ErrorCode.ARGUMENT_MISSING);
            }
            if (StringUtils.isBlank((CharSequence)setVarArguments.name)) {
                throw AdapterUtils.createCompletionException("SetVariablesRequest: property 'name' is missing, null, or empty", ErrorCode.ARGUMENT_MISSING);
            }
            this.context = context;
            showStaticVariables = DebugSettings.getCurrent().showStaticVariables;
            IVariableFormatter variableFormatter = context.getVariableFormatter();
            options = variableFormatter.getDefaultOptions();
            VariableUtils.applyFormatterOptions(options, setVarArguments.format != null && setVarArguments.format.hex);
            container = context.getRecyclableIdPool().getObjectById(setVarArguments.variablesReference);
            if (container == null) {
                throw AdapterUtils.createCompletionException("Failed to set variable. Reason: Cannot set value because the thread is resumed.", ErrorCode.SET_VARIABLE_FAILURE);
            }
            name = setVarArguments.name;
            newValue = null;
            String belongToClass = null;
            if (setVarArguments.name.contains("(")) {
                name = setVarArguments.name.replaceFirst(PATTERN, "$1");
                belongToClass = setVarArguments.name.replaceFirst(PATTERN, "$2");
            }
            try {
                Object containerObj = ((VariableProxy)container).getProxiedVariable();
                if (containerObj instanceof StackFrameReference) {
                    StackFrameReference stackFrameReference = (StackFrameReference)containerObj;
                    StackFrame sf = context.getStackFrameManager().getStackFrame(stackFrameReference);
                    newValue = this.handleSetValueForStackFrame(name, belongToClass, setVarArguments.value, showStaticVariables, sf, options);
                    break block11;
                }
                if (containerObj instanceof ObjectReference) {
                    newValue = this.handleSetValueForObject(name, belongToClass, setVarArguments.value, (ObjectReference)containerObj, options);
                    break block11;
                }
                throw AdapterUtils.createCompletionException(String.format("SetVariableRequest: Variable %s cannot be found.", setVarArguments.variablesReference), ErrorCode.SET_VARIABLE_FAILURE);
            }
            catch (AbsentInformationException | ClassNotLoadedException | InvalidTypeException | IllegalArgumentException | UnsupportedOperationException e) {
                throw AdapterUtils.createCompletionException(String.format("Failed to set variable. Reason: %s", e.toString()), ErrorCode.SET_VARIABLE_FAILURE, e);
            }
        }
        int referenceId = 0;
        if (newValue instanceof ObjectReference && VariableUtils.hasChildren(newValue, showStaticVariables)) {
            long threadId = ((VariableProxy)container).getThreadId();
            String scopeName = ((VariableProxy)container).getScope();
            VariableProxy varProxy = new VariableProxy(((VariableProxy)container).getThread(), scopeName, newValue, (VariableProxy)container, name);
            referenceId = context.getRecyclableIdPool().addObject(threadId, varProxy);
        }
        int indexedVariables = 0;
        if (newValue instanceof ArrayReference) {
            indexedVariables = ((ArrayReference)newValue).length();
        }
        response.body = new Responses.SetVariablesResponseBody(context.getVariableFormatter().typeToString(newValue == null ? null : newValue.type(), options), context.getVariableFormatter().valueToString(newValue, options), referenceId, indexedVariables);
        return CompletableFuture.completedFuture(response);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private Value handleSetValueForObject(String name, String belongToClass, String valueString, ObjectReference container, Map<String, Object> options) throws InvalidTypeException, ClassNotLoadedException {
        if (container instanceof ArrayReference) {
            ArrayReference array = (ArrayReference)container;
            Type eleType = ((ArrayType)array.referenceType()).componentType();
            return this.setArrayValue(array, eleType, Integer.parseInt(name), valueString, options);
        }
        if (!StringUtils.isBlank((CharSequence)belongToClass)) return this.setFieldValueWithConflict(container, container.referenceType().allFields(), name, belongToClass, valueString, options);
        Field field = container.referenceType().fieldByName(name);
        if (field == null) throw new IllegalArgumentException(String.format("SetVariableRequest: Variable %s cannot be found.", name));
        if (!field.isStatic()) return this.setObjectFieldValue(container, field, name, valueString, options);
        return this.setStaticFieldValue(container.referenceType(), field, name, valueString, options);
    }

    private Value handleSetValueForStackFrame(String name, String belongToClass, String valueString, boolean showStaticVariables, StackFrame container, Map<String, Object> options) throws AbsentInformationException, InvalidTypeException, ClassNotLoadedException {
        Value newValue;
        if (name.equals("this")) {
            throw new UnsupportedOperationException("SetVariableRequest: 'This' variable cannot be changed.");
        }
        LocalVariable variable = container.visibleVariableByName(name);
        if (StringUtils.isBlank((CharSequence)belongToClass) && variable != null) {
            newValue = this.setFrameValue(container, variable, valueString, options);
        } else if (showStaticVariables && container.location().method().isStatic()) {
            ReferenceType type = container.location().declaringType();
            if (StringUtils.isBlank((CharSequence)belongToClass)) {
                Field field = type.fieldByName(name);
                newValue = this.setStaticFieldValue(type, field, name, valueString, options);
            } else {
                newValue = this.setFieldValueWithConflict(null, type.allFields(), name, belongToClass, valueString, options);
            }
        } else {
            throw new UnsupportedOperationException(String.format("SetVariableRequest: Variable %s cannot be found.", name));
        }
        return newValue;
    }

    private Value setValueProxy(Type type, String value, SetValueFunction setValueFunc, Map<String, Object> options) throws ClassNotLoadedException, InvalidTypeException {
        Value newValue = this.context.getVariableFormatter().stringToValue(value, type, options);
        setValueFunc.apply(newValue);
        return newValue;
    }

    private Value setStaticFieldValue(Type declaringType, Field field, String name, String value, Map<String, Object> options) throws ClassNotLoadedException, InvalidTypeException {
        if (field.isFinal()) {
            throw new UnsupportedOperationException(String.format("SetVariableRequest: Final field %s cannot be changed.", name));
        }
        if (!(declaringType instanceof ClassType)) {
            throw new UnsupportedOperationException(String.format("SetVariableRequest: Field %s in interface cannot be changed.", name));
        }
        return this.setValueProxy(field.type(), value, newValue -> ((ClassType)declaringType).setValue(field, newValue), options);
    }

    private Value setFrameValue(StackFrame frame, LocalVariable localVariable, String value, Map<String, Object> options) throws ClassNotLoadedException, InvalidTypeException {
        return this.setValueProxy(localVariable.type(), value, newValue -> frame.setValue(localVariable, newValue), options);
    }

    private Value setObjectFieldValue(ObjectReference obj, Field field, String name, String value, Map<String, Object> options) throws ClassNotLoadedException, InvalidTypeException {
        if (field.isFinal()) {
            throw new UnsupportedOperationException(String.format("SetVariableRequest: Final field %s cannot be changed.", name));
        }
        return this.setValueProxy(field.type(), value, newValue -> obj.setValue(field, newValue), options);
    }

    private Value setArrayValue(ArrayReference array, Type eleType, int index, String value, Map<String, Object> options) throws ClassNotLoadedException, InvalidTypeException {
        return this.setValueProxy(eleType, value, newValue -> array.setValue(index, newValue), options);
    }

    private Value setFieldValueWithConflict(ObjectReference obj, List<Field> fields, String name, String belongToClass, String value, Map<String, Object> options) throws ClassNotLoadedException, InvalidTypeException {
        List narrowedFields = fields.stream().filter(TypeComponent::isStatic).filter(t -> t.name().equals(name) && t.declaringType().name().equals(belongToClass)).collect(Collectors.toList());
        if (narrowedFields.isEmpty()) {
            narrowedFields = fields.stream().filter(TypeComponent::isStatic).filter(t -> t.name().equals(name) && this.context.getVariableFormatter().typeToString(t.declaringType(), options).equals(belongToClass)).collect(Collectors.toList());
        }
        if (narrowedFields.size() != 1) {
            throw new UnsupportedOperationException(String.format("SetVariableRequest: Name conflicted for %s.", name));
        }
        Field field = (Field)narrowedFields.get(0);
        return field.isStatic() ? this.setStaticFieldValue(field.declaringType(), field, name, value, options) : this.setObjectFieldValue(obj, field, name, value, options);
    }

    @FunctionalInterface
    static interface SetValueFunction {
        public void apply(Value var1) throws InvalidTypeException, ClassNotLoadedException;
    }
}

