/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.java.debug.core.adapter.handler;

import com.microsoft.java.debug.core.DebugSettings;
import com.microsoft.java.debug.core.adapter.IDebugAdapterContext;
import com.microsoft.java.debug.core.adapter.IDebugRequestHandler;
import com.microsoft.java.debug.core.protocol.Events;
import com.microsoft.java.debug.core.protocol.Messages;
import com.microsoft.java.debug.core.protocol.Requests;
import java.util.Arrays;
import java.util.List;
import java.util.concurrent.CompletableFuture;

public class RefreshVariablesHandler
implements IDebugRequestHandler {
    @Override
    public List<Requests.Command> getTargetCommands() {
        return Arrays.asList(Requests.Command.REFRESHVARIABLES);
    }

    @Override
    public CompletableFuture<Messages.Response> handle(Requests.Command command, Requests.Arguments arguments, Messages.Response response, IDebugAdapterContext context) {
        Requests.RefreshVariablesArguments refreshArgs = (Requests.RefreshVariablesArguments)arguments;
        if (refreshArgs != null) {
            DebugSettings.getCurrent().showHex = refreshArgs.showHex;
            DebugSettings.getCurrent().showQualifiedNames = refreshArgs.showQualifiedNames;
            DebugSettings.getCurrent().showStaticVariables = refreshArgs.showStaticVariables;
            DebugSettings.getCurrent().showLogicalStructure = refreshArgs.showLogicalStructure;
            DebugSettings.getCurrent().showToString = refreshArgs.showToString;
        }
        context.getProtocolServer().sendEvent(new Events.InvalidatedEvent(Events.InvalidatedAreas.VARIABLES));
        return CompletableFuture.completedFuture(response);
    }
}

