/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.java.debug.core;

import com.microsoft.java.debug.core.AsyncJdwpUtils;
import com.microsoft.java.debug.core.IBreakpoint;
import com.microsoft.java.debug.core.IEventHub;
import com.sun.jdi.AbsentInformationException;
import com.sun.jdi.Location;
import com.sun.jdi.Method;
import com.sun.jdi.ReferenceType;
import com.sun.jdi.VMDisconnectedException;
import com.sun.jdi.VirtualMachine;
import com.sun.jdi.event.ClassPrepareEvent;
import com.sun.jdi.request.BreakpointRequest;
import com.sun.jdi.request.ClassPrepareRequest;
import com.sun.jdi.request.EventRequest;
import io.reactivex.Observable;
import io.reactivex.disposables.Disposable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.CompletableFuture;

public class Breakpoint
implements IBreakpoint {
    private VirtualMachine vm = null;
    private IEventHub eventHub = null;
    private String className = null;
    private int lineNumber = 0;
    private int hitCount = 0;
    private String condition = null;
    private String logMessage = null;
    private HashMap<Object, Object> propertyMap = new HashMap();
    private String methodSignature = null;
    private boolean async = false;
    private List<EventRequest> requests = Collections.synchronizedList(new ArrayList());
    private List<Disposable> subscriptions = new ArrayList<Disposable>();

    Breakpoint(VirtualMachine vm, IEventHub eventHub, String className, int lineNumber) {
        this(vm, eventHub, className, lineNumber, 0, null);
    }

    Breakpoint(VirtualMachine vm, IEventHub eventHub, String className, int lineNumber, int hitCount) {
        this(vm, eventHub, className, lineNumber, hitCount, null);
    }

    Breakpoint(VirtualMachine vm, IEventHub eventHub, String className, int lineNumber, int hitCount, String condition) {
        this.vm = vm;
        this.eventHub = eventHub;
        if (className != null && className.contains("#")) {
            this.className = className.substring(0, className.indexOf("#"));
            this.methodSignature = className.substring(className.indexOf("#") + 1);
        } else {
            this.className = className;
        }
        this.lineNumber = lineNumber;
        this.hitCount = hitCount;
        this.condition = condition;
    }

    Breakpoint(VirtualMachine vm, IEventHub eventHub, String className, int lineNumber, int hitCount, String condition, String logMessage) {
        this(vm, eventHub, className, lineNumber, hitCount, condition);
        this.logMessage = logMessage;
    }

    @Override
    public List<EventRequest> requests() {
        return this.requests;
    }

    @Override
    public List<Disposable> subscriptions() {
        return this.subscriptions;
    }

    @Override
    public void close() throws Exception {
        try {
            this.vm.eventRequestManager().deleteEventRequests(this.requests());
        }
        catch (VMDisconnectedException vMDisconnectedException) {
            // empty catch block
        }
        this.subscriptions().forEach(subscription -> subscription.dispose());
        this.requests.clear();
        this.subscriptions.clear();
    }

    @Override
    public String className() {
        return this.className;
    }

    @Override
    public int getLineNumber() {
        return this.lineNumber;
    }

    @Override
    public String getCondition() {
        return this.condition;
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof Breakpoint)) {
            return super.equals(obj);
        }
        Breakpoint breakpoint = (Breakpoint)obj;
        return Objects.equals(this.className(), breakpoint.className()) && this.getLineNumber() == breakpoint.getLineNumber() && Objects.equals(this.methodSignature, breakpoint.methodSignature);
    }

    public int hashCode() {
        return Objects.hash(this.className, this.lineNumber, this.methodSignature);
    }

    @Override
    public int getHitCount() {
        return this.hitCount;
    }

    @Override
    public void setHitCount(int hitCount) {
        this.hitCount = hitCount;
        Observable.fromIterable(this.requests()).filter(request -> request instanceof BreakpointRequest).subscribe(request -> {
            request.addCountFilter(hitCount);
            request.enable();
        });
    }

    @Override
    public void setCondition(String condition) {
        this.condition = condition;
    }

    @Override
    public void setLogMessage(String logMessage) {
        this.logMessage = logMessage;
    }

    @Override
    public String getLogMessage() {
        return this.logMessage;
    }

    @Override
    public boolean async() {
        return this.async;
    }

    @Override
    public void setAsync(boolean async) {
        this.async = async;
    }

    @Override
    public CompletableFuture<IBreakpoint> install() {
        ClassPrepareRequest classPrepareRequest = this.vm.eventRequestManager().createClassPrepareRequest();
        classPrepareRequest.addClassFilter(this.className);
        classPrepareRequest.enable();
        this.requests.add(classPrepareRequest);
        ClassPrepareRequest localClassPrepareRequest = this.vm.eventRequestManager().createClassPrepareRequest();
        localClassPrepareRequest.addClassFilter(this.className + "$*");
        localClassPrepareRequest.enable();
        this.requests.add(localClassPrepareRequest);
        CompletableFuture<IBreakpoint> future = new CompletableFuture<IBreakpoint>();
        Disposable subscription = this.eventHub.events().filter(debugEvent -> debugEvent.event instanceof ClassPrepareEvent && (classPrepareRequest.equals(debugEvent.event.request()) || localClassPrepareRequest.equals(debugEvent.event.request()))).subscribe(debugEvent -> {
            ClassPrepareEvent event = (ClassPrepareEvent)debugEvent.event;
            List<BreakpointRequest> newRequests = AsyncJdwpUtils.await(this.createBreakpointRequests(event.referenceType(), this.lineNumber, this.hitCount, false));
            this.requests.addAll(newRequests);
            if (!newRequests.isEmpty() && !future.isDone()) {
                this.putProperty("verified", true);
                future.complete(this);
            }
        });
        this.subscriptions.add(subscription);
        Runnable resolveRequestsFromExistingClasses = () -> {
            List<ReferenceType> refTypes = this.vm.classesByName(this.className);
            this.createBreakpointRequests(refTypes, this.lineNumber, this.hitCount, true).whenComplete((newRequests, ex) -> {
                if (ex != null) {
                    return;
                }
                this.requests.addAll((Collection<EventRequest>)newRequests);
                if (!newRequests.isEmpty() && !future.isDone()) {
                    this.putProperty("verified", true);
                    future.complete(this);
                }
            });
        };
        if (this.async()) {
            AsyncJdwpUtils.runAsync(resolveRequestsFromExistingClasses);
        } else {
            resolveRequestsFromExistingClasses.run();
        }
        return future;
    }

    private CompletableFuture<List<Location>> collectLocations(ReferenceType refType, int lineNumber) {
        ArrayList futures = new ArrayList();
        for (Method method : refType.methods()) {
            if (this.async()) {
                futures.add(AsyncJdwpUtils.supplyAsync(() -> this.findLocaitonsOfLine(method, lineNumber)));
                continue;
            }
            futures.add(CompletableFuture.completedFuture(this.findLocaitonsOfLine(method, lineNumber)));
        }
        return AsyncJdwpUtils.flatAll(futures);
    }

    private CompletableFuture<List<Location>> collectLocations(List<ReferenceType> refTypes, int lineNumber, boolean includeNestedTypes) {
        ArrayList futures = new ArrayList();
        refTypes.forEach(refType -> futures.add(this.collectLocations((ReferenceType)refType, lineNumber, includeNestedTypes)));
        return AsyncJdwpUtils.flatAll(futures);
    }

    private CompletableFuture<List<Location>> collectLocations(ReferenceType refType, int lineNumber, boolean includeNestedTypes) {
        return this.collectLocations(refType, lineNumber).thenCompose(newLocations -> {
            if (!newLocations.isEmpty()) {
                return CompletableFuture.completedFuture(newLocations);
            }
            if (includeNestedTypes) {
                for (ReferenceType nestedType : refType.nestedTypes()) {
                    CompletableFuture<List<Location>> nestedLocationsFuture = this.collectLocations(nestedType, lineNumber);
                    List<Location> nestedLocations = nestedLocationsFuture.join();
                    if (nestedLocations.isEmpty()) continue;
                    return CompletableFuture.completedFuture(nestedLocations);
                }
            }
            return CompletableFuture.completedFuture(Collections.emptyList());
        });
    }

    private CompletableFuture<List<Location>> collectLocations(List<ReferenceType> refTypes, String nameAndSignature) {
        String[] segments = nameAndSignature.split("#");
        ArrayList futures = new ArrayList();
        for (ReferenceType refType : refTypes) {
            if (this.async()) {
                futures.add(AsyncJdwpUtils.supplyAsync(() -> this.findMethodLocaiton(refType, segments[0], segments[1])));
                continue;
            }
            futures.add(CompletableFuture.completedFuture(this.findMethodLocaiton(refType, segments[0], segments[1])));
        }
        return AsyncJdwpUtils.all(futures);
    }

    private Location findMethodLocaiton(ReferenceType refType, String methodName, String methodSiguature) {
        List<Method> methods = refType.methods();
        Location location = null;
        for (Method method : methods) {
            if (method.isAbstract() || method.isNative() || !methodName.equals(method.name()) || !methodSiguature.equals(method.genericSignature()) && !methodSiguature.equals(method.signature())) continue;
            location = method.location();
            break;
        }
        return location;
    }

    private List<Location> findLocaitonsOfLine(Method method, int lineNumber) {
        try {
            return method.locationsOfLine(lineNumber);
        }
        catch (AbsentInformationException absentInformationException) {
            return Collections.emptyList();
        }
    }

    private CompletableFuture<List<BreakpointRequest>> createBreakpointRequests(ReferenceType refType, int lineNumber, int hitCount, boolean includeNestedTypes) {
        return this.createBreakpointRequests(Arrays.asList(refType), lineNumber, hitCount, includeNestedTypes);
    }

    private CompletableFuture<List<BreakpointRequest>> createBreakpointRequests(List<ReferenceType> refTypes, int lineNumber, int hitCount, boolean includeNestedTypes) {
        CompletableFuture<List<Location>> locationsFuture = this.methodSignature != null ? this.collectLocations(refTypes, this.methodSignature) : this.collectLocations(refTypes, lineNumber, includeNestedTypes);
        return locationsFuture.thenCompose(locations -> {
            ArrayList existingLocations = new ArrayList(this.requests.size());
            Observable.fromIterable(this.requests).filter(request -> request instanceof BreakpointRequest).map(request -> ((BreakpointRequest)request).location()).toList().subscribe(list -> existingLocations.addAll(list));
            ArrayList newLocations = new ArrayList(locations.size());
            Observable.fromIterable((Iterable)locations).filter(location -> !existingLocations.contains(location)).toList().subscribe(list -> newLocations.addAll(list));
            ArrayList newRequests = new ArrayList(newLocations.size());
            newLocations.forEach(location -> {
                BreakpointRequest request = this.vm.eventRequestManager().createBreakpointRequest((Location)location);
                request.setSuspendPolicy(1);
                if (hitCount > 0) {
                    request.addCountFilter(hitCount);
                }
                request.putProperty("request_type", this.computeRequestType());
                newRequests.add(request);
            });
            ArrayList futures = new ArrayList();
            for (BreakpointRequest request2 : newRequests) {
                if (this.async()) {
                    futures.add(AsyncJdwpUtils.runAsync(() -> {
                        try {
                            request2.enable();
                        }
                        catch (VMDisconnectedException vMDisconnectedException) {
                            // empty catch block
                        }
                    }));
                    continue;
                }
                try {
                    request2.enable();
                }
                catch (VMDisconnectedException vMDisconnectedException) {}
            }
            return AsyncJdwpUtils.all(futures).thenApply(res -> newRequests);
        });
    }

    private Object computeRequestType() {
        if (this.methodSignature == null) {
            return 0;
        }
        if (this.methodSignature.startsWith("lambda$")) {
            return 2;
        }
        return 1;
    }

    @Override
    public void putProperty(Object key, Object value) {
        this.propertyMap.put(key, value);
    }

    @Override
    public Object getProperty(Object key) {
        return this.propertyMap.get(key);
    }
}

