/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.java.debug.core.adapter.handler;

import com.microsoft.java.debug.core.AsyncJdwpUtils;
import com.microsoft.java.debug.core.DebugUtility;
import com.microsoft.java.debug.core.adapter.AdapterUtils;
import com.microsoft.java.debug.core.adapter.IDebugAdapterContext;
import com.microsoft.java.debug.core.adapter.IDebugRequestHandler;
import com.microsoft.java.debug.core.adapter.ISourceLookUpProvider;
import com.microsoft.java.debug.core.adapter.formatter.SimpleTypeFormatter;
import com.microsoft.java.debug.core.adapter.variables.StackFrameReference;
import com.microsoft.java.debug.core.protocol.Messages;
import com.microsoft.java.debug.core.protocol.Requests;
import com.microsoft.java.debug.core.protocol.Responses;
import com.microsoft.java.debug.core.protocol.Types;
import com.sun.jdi.AbsentInformationException;
import com.sun.jdi.IncompatibleThreadStateException;
import com.sun.jdi.LocalVariable;
import com.sun.jdi.Location;
import com.sun.jdi.Method;
import com.sun.jdi.ObjectCollectedException;
import com.sun.jdi.ObjectReference;
import com.sun.jdi.ReferenceType;
import com.sun.jdi.StackFrame;
import com.sun.jdi.ThreadReference;
import java.io.File;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.concurrent.CancellationException;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionException;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;

public class StackTraceRequestHandler
implements IDebugRequestHandler {
    @Override
    public List<Requests.Command> getTargetCommands() {
        return Arrays.asList(Requests.Command.STACKTRACE);
    }

    @Override
    public CompletableFuture<Messages.Response> handle(Requests.Command command, Requests.Arguments arguments, Messages.Response response, IDebugAdapterContext context) {
        Requests.StackTraceArguments stacktraceArgs = (Requests.StackTraceArguments)arguments;
        ArrayList<Types.StackFrame> result = new ArrayList<Types.StackFrame>();
        if (stacktraceArgs.startFrame < 0 || stacktraceArgs.levels < 0) {
            response.body = new Responses.StackTraceResponseBody(result, 0);
            return CompletableFuture.completedFuture(response);
        }
        ThreadReference thread = context.getThreadCache().getThread(stacktraceArgs.threadId);
        if (thread == null) {
            thread = DebugUtility.getThread(context.getDebugSession(), stacktraceArgs.threadId);
        }
        int totalFrames = 0;
        if (thread != null) {
            try {
                int count;
                if (stacktraceArgs.startFrame == 0) {
                    context.getStackFrameManager().clearStackFrames(thread);
                }
                totalFrames = thread.frameCount();
                int n = count = stacktraceArgs.levels == 0 ? totalFrames - stacktraceArgs.startFrame : Math.min(totalFrames - stacktraceArgs.startFrame, stacktraceArgs.levels);
                if (totalFrames <= stacktraceArgs.startFrame) {
                    response.body = new Responses.StackTraceResponseBody(result, totalFrames);
                    return CompletableFuture.completedFuture(response);
                }
                StackFrame[] frames = context.getStackFrameManager().reloadStackFrames(thread, stacktraceArgs.startFrame, count);
                List<StackFrameInfo> jdiFrames = StackTraceRequestHandler.resolveStackFrameInfos(frames, context.asyncJDWP());
                for (int i = 0; i < count; ++i) {
                    StackFrameReference stackframe = new StackFrameReference(thread, stacktraceArgs.startFrame + i);
                    int frameId = context.getRecyclableIdPool().addObject(stacktraceArgs.threadId, stackframe);
                    StackFrameInfo jdiFrame = jdiFrames.get(i);
                    result.add(this.convertDebuggerStackFrameToClient(jdiFrame, frameId, context));
                }
            }
            catch (AbsentInformationException | IncompatibleThreadStateException | ObjectCollectedException | IndexOutOfBoundsException | URISyntaxException | CancellationException | CompletionException exception) {
                // empty catch block
            }
        }
        response.body = new Responses.StackTraceResponseBody(result, totalFrames);
        return CompletableFuture.completedFuture(response);
    }

    private static List<StackFrameInfo> resolveStackFrameInfos(StackFrame[] frames, boolean async) throws AbsentInformationException, IncompatibleThreadStateException {
        ArrayList<StackFrameInfo> jdiFrames = new ArrayList<StackFrameInfo>();
        ArrayList futures = new ArrayList();
        for (StackFrame frame : frames) {
            StackFrameInfo jdiFrame = new StackFrameInfo(frame);
            jdiFrame.location = jdiFrame.frame.location();
            jdiFrame.method = jdiFrame.location.method();
            jdiFrame.methodName = jdiFrame.method.name();
            jdiFrame.isNative = jdiFrame.method.isNative();
            jdiFrame.declaringType = jdiFrame.location.declaringType();
            if (async) {
                futures.add(AsyncJdwpUtils.runAsync(() -> {
                    jdiFrame.lineNumber = jdiFrame.location.lineNumber();
                }));
                futures.add(AsyncJdwpUtils.runAsync(() -> {
                    try {
                        jdiFrame.sourceName = jdiFrame.declaringType.sourceName();
                    }
                    catch (AbsentInformationException e) {
                        jdiFrame.sourceName = null;
                    }
                }));
                futures.add(AsyncJdwpUtils.runAsync(() -> {
                    jdiFrame.typeSignature = jdiFrame.declaringType.signature();
                }));
            } else {
                jdiFrame.lineNumber = jdiFrame.location.lineNumber();
                jdiFrame.typeSignature = jdiFrame.declaringType.signature();
                try {
                    jdiFrame.sourceName = jdiFrame.declaringType.sourceName();
                }
                catch (AbsentInformationException e) {
                    jdiFrame.sourceName = null;
                }
            }
            jdiFrames.add(jdiFrame);
        }
        AsyncJdwpUtils.await(futures);
        for (StackFrameInfo jdiFrame : jdiFrames) {
            jdiFrame.typeName = jdiFrame.declaringType.name();
            jdiFrame.argumentTypeNames = jdiFrame.method.argumentTypeNames();
            if (jdiFrame.sourceName == null) {
                String enclosingType = AdapterUtils.parseEnclosingType(jdiFrame.typeName);
                jdiFrame.sourceName = enclosingType.substring(enclosingType.lastIndexOf(46) + 1) + ".java";
                jdiFrame.sourcePath = enclosingType.replace('.', File.separatorChar) + ".java";
                continue;
            }
            jdiFrame.sourcePath = jdiFrame.declaringType.sourcePaths(null).get(0);
        }
        return jdiFrames;
    }

    private Types.StackFrame convertDebuggerStackFrameToClient(StackFrameInfo jdiFrame, int frameId, IDebugAdapterContext context) throws URISyntaxException, AbsentInformationException {
        Types.Source clientSource = StackTraceRequestHandler.convertDebuggerSourceToClient(jdiFrame.typeName, jdiFrame.sourceName, jdiFrame.sourcePath, context);
        Object methodName = this.formatMethodName(jdiFrame.methodName, jdiFrame.argumentTypeNames, jdiFrame.typeName, true, true);
        int clientLineNumber = AdapterUtils.convertLineNumber(jdiFrame.lineNumber, context.isDebuggerLinesStartAt1(), context.isClientLinesStartAt1());
        String presentationHint = null;
        if (clientLineNumber < 0) {
            presentationHint = "subtle";
            if (jdiFrame.isNative) {
                methodName = (String)methodName + "[native method]";
            } else {
                clientSource = null;
            }
        }
        return new Types.StackFrame(frameId, (String)methodName, clientSource, clientLineNumber, context.isClientColumnsStartAt1() ? 1 : 0, presentationHint);
    }

    public static Types.Source convertDebuggerSourceToClient(String fullyQualifiedName, String sourceName, String relativeSourcePath, IDebugAdapterContext context) throws URISyntaxException {
        String uri = context.getSourceLookupCache().computeIfAbsent(fullyQualifiedName, key -> {
            String fromProvider = context.getProvider(ISourceLookUpProvider.class).getSourceFileURI((String)key, relativeSourcePath);
            return StringUtils.isBlank((CharSequence)fromProvider) ? "" : fromProvider;
        });
        if (!StringUtils.isBlank((CharSequence)uri)) {
            if (uri.startsWith("file:")) {
                String clientPath = AdapterUtils.convertPath(uri, context.isDebuggerPathsAreUri(), context.isClientPathsAreUri());
                return new Types.Source(sourceName, clientPath, 0);
            }
            return new Types.Source(sourceName, uri, 0);
        }
        String absoluteSourcepath = AdapterUtils.sourceLookup(context.getSourcePaths(), relativeSourcePath);
        if (absoluteSourcepath != null) {
            return new Types.Source(sourceName, absoluteSourcepath, 0);
        }
        return null;
    }

    private String formatMethodName(String methodName, List<String> argumentTypeNames, String fqn, boolean showContextClass, boolean showParameter) {
        StringBuilder formattedName = new StringBuilder();
        if (showContextClass) {
            formattedName.append(SimpleTypeFormatter.trimTypeName(fqn));
            formattedName.append(".");
        }
        formattedName.append(methodName);
        if (showParameter) {
            argumentTypeNames = argumentTypeNames.stream().map(SimpleTypeFormatter::trimTypeName).collect(Collectors.toList());
            formattedName.append("(");
            formattedName.append(String.join((CharSequence)",", argumentTypeNames));
            formattedName.append(")");
        }
        return formattedName.toString();
    }

    static class StackFrameInfo {
        public StackFrame frame;
        public Location location;
        public Method method;
        public String methodName;
        public List<String> argumentTypeNames = new ArrayList<String>();
        public boolean isNative = false;
        public int lineNumber;
        public ReferenceType declaringType = null;
        public String typeName;
        public String typeSignature;
        public String sourceName = "";
        public String sourcePath = "";
        public List<LocalVariable> visibleVariables = null;
        public ObjectReference thisObject;

        public StackFrameInfo(StackFrame frame) {
            this.frame = frame;
        }
    }
}

