/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.java.debug.core.adapter.handler;

import com.microsoft.java.debug.core.AsyncJdwpUtils;
import com.microsoft.java.debug.core.DebugEvent;
import com.microsoft.java.debug.core.DebugUtility;
import com.microsoft.java.debug.core.IDebugSession;
import com.microsoft.java.debug.core.JdiExceptionReference;
import com.microsoft.java.debug.core.JdiMethodResult;
import com.microsoft.java.debug.core.adapter.AdapterUtils;
import com.microsoft.java.debug.core.adapter.ErrorCode;
import com.microsoft.java.debug.core.adapter.IDebugAdapterContext;
import com.microsoft.java.debug.core.adapter.IDebugRequestHandler;
import com.microsoft.java.debug.core.adapter.handler.ThreadsRequestHandler;
import com.microsoft.java.debug.core.protocol.Events;
import com.microsoft.java.debug.core.protocol.Messages;
import com.microsoft.java.debug.core.protocol.Requests;
import com.sun.jdi.IncompatibleThreadStateException;
import com.sun.jdi.Location;
import com.sun.jdi.Method;
import com.sun.jdi.ObjectReference;
import com.sun.jdi.StackFrame;
import com.sun.jdi.ThreadReference;
import com.sun.jdi.Value;
import com.sun.jdi.VoidValue;
import com.sun.jdi.event.BreakpointEvent;
import com.sun.jdi.event.Event;
import com.sun.jdi.event.ExceptionEvent;
import com.sun.jdi.event.LocatableEvent;
import com.sun.jdi.event.MethodExitEvent;
import com.sun.jdi.event.StepEvent;
import com.sun.jdi.request.EventRequestManager;
import com.sun.jdi.request.MethodExitRequest;
import com.sun.jdi.request.StepRequest;
import io.reactivex.disposables.Disposable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionException;
import org.apache.commons.lang3.ArrayUtils;

public class StepRequestHandler
implements IDebugRequestHandler {
    @Override
    public List<Requests.Command> getTargetCommands() {
        return Arrays.asList(Requests.Command.STEPIN, Requests.Command.STEPOUT, Requests.Command.NEXT);
    }

    @Override
    public CompletableFuture<Messages.Response> handle(Requests.Command command, Requests.Arguments arguments, Messages.Response response, IDebugAdapterContext context) {
        if (context.getDebugSession() == null) {
            return AdapterUtils.createAsyncErrorResponse(response, ErrorCode.EMPTY_DEBUG_SESSION, "Debug Session doesn't exist.");
        }
        long threadId = ((Requests.StepArguments)arguments).threadId;
        ThreadReference thread = context.getThreadCache().getThread(threadId);
        if (thread == null) {
            thread = DebugUtility.getThread(context.getDebugSession(), threadId);
        }
        if (thread != null) {
            JdiExceptionReference exception = context.getExceptionManager().removeException(threadId);
            context.getStepResultManager().removeMethodResult(threadId);
            try {
                ThreadReference targetThread = thread;
                ThreadState threadState = new ThreadState();
                threadState.threadId = threadId;
                threadState.pendingStepType = command;
                threadState.eventSubscription = context.getDebugSession().getEventHub().events().filter(debugEvent -> debugEvent.event instanceof StepEvent && debugEvent.event.request().equals(threadState.pendingStepRequest) || debugEvent.event instanceof MethodExitEvent && debugEvent.event.request().equals(threadState.pendingMethodExitRequest) || debugEvent.event instanceof BreakpointEvent || debugEvent.event instanceof ExceptionEvent).subscribe(debugEvent -> this.handleDebugEvent((DebugEvent)debugEvent, context.getDebugSession(), context, threadState));
                threadState.pendingStepRequest = command == Requests.Command.STEPIN ? DebugUtility.createStepIntoRequest(thread, context.getStepFilters().allowClasses, context.getStepFilters().skipClasses) : (command == Requests.Command.STEPOUT ? DebugUtility.createStepOutRequest(thread, context.getStepFilters().allowClasses, context.getStepFilters().skipClasses) : DebugUtility.createStepOverRequest(thread, null));
                threadState.pendingMethodExitRequest = thread.virtualMachine().eventRequestManager().createMethodExitRequest();
                threadState.pendingMethodExitRequest.setSuspendPolicy(1);
                if (context.asyncJDWP()) {
                    ArrayList futures = new ArrayList();
                    futures.add(AsyncJdwpUtils.runAsync(() -> {
                        block5: {
                            try {
                                threadState.topFrame = this.getTopFrame(targetThread);
                                threadState.stepLocation = threadState.topFrame.location();
                                threadState.pendingMethodExitRequest.addClassFilter(threadState.stepLocation.declaringType());
                                if (!targetThread.virtualMachine().canUseInstanceFilters()) break block5;
                                try {
                                    ObjectReference thisObject = threadState.topFrame.thisObject();
                                    if (thisObject != null) {
                                        threadState.pendingMethodExitRequest.addInstanceFilter(thisObject);
                                    }
                                }
                                catch (Exception thisObject) {}
                            }
                            catch (IncompatibleThreadStateException e) {
                                throw new CompletionException(e);
                            }
                        }
                    }));
                    futures.add(AsyncJdwpUtils.runAsync(() -> threadState.pendingMethodExitRequest.addThreadFilter(targetThread)));
                    futures.add(AsyncJdwpUtils.runAsync(() -> {
                        try {
                            threadState.stackDepth = targetThread.frameCount();
                        }
                        catch (IncompatibleThreadStateException e) {
                            throw new CompletionException(e);
                        }
                    }));
                    futures.add(AsyncJdwpUtils.runAsync(() -> threadState.pendingStepRequest.enable()));
                    try {
                        AsyncJdwpUtils.await(futures);
                    }
                    catch (CompletionException ex) {
                        if (ex.getCause() instanceof IncompatibleThreadStateException) {
                            throw (IncompatibleThreadStateException)ex.getCause();
                        }
                        throw ex;
                    }
                    threadState.pendingMethodExitRequest.enable();
                } else {
                    threadState.stackDepth = targetThread.frameCount();
                    threadState.topFrame = this.getTopFrame(targetThread);
                    threadState.stepLocation = threadState.topFrame.location();
                    threadState.pendingMethodExitRequest.addThreadFilter(thread);
                    threadState.pendingMethodExitRequest.addClassFilter(threadState.stepLocation.declaringType());
                    if (targetThread.virtualMachine().canUseInstanceFilters()) {
                        try {
                            ObjectReference thisObject = threadState.topFrame.thisObject();
                            if (thisObject != null) {
                                threadState.pendingMethodExitRequest.addInstanceFilter(thisObject);
                            }
                        }
                        catch (Exception exception2) {
                            // empty catch block
                        }
                    }
                    threadState.pendingStepRequest.enable();
                    threadState.pendingMethodExitRequest.enable();
                }
                DebugUtility.resumeThread(thread);
                ThreadsRequestHandler.checkThreadRunningAndRecycleIds(thread, context);
            }
            catch (IncompatibleThreadStateException ex) {
                context.getExceptionManager().setException(threadId, exception);
                String failureMessage = String.format("Failed to step because the thread '%s' is not suspended in the target VM.", thread.name());
                throw AdapterUtils.createCompletionException(failureMessage, ErrorCode.STEP_FAILURE, ex);
            }
            catch (IndexOutOfBoundsException ex) {
                context.getExceptionManager().setException(threadId, exception);
                String failureMessage = String.format("Failed to step because the thread '%s' doesn't contain any stack frame", thread.name());
                throw AdapterUtils.createCompletionException(failureMessage, ErrorCode.STEP_FAILURE, ex);
            }
            catch (Exception ex) {
                context.getExceptionManager().setException(threadId, exception);
                String failureMessage = String.format("Failed to step because of the error '%s'", ex.getMessage());
                throw AdapterUtils.createCompletionException(failureMessage, ErrorCode.STEP_FAILURE, ex.getCause() != null ? ex.getCause() : ex);
            }
        }
        return CompletableFuture.completedFuture(response);
    }

    private void handleDebugEvent(DebugEvent debugEvent, IDebugSession debugSession, IDebugAdapterContext context, ThreadState threadState) {
        Event event = debugEvent.event;
        EventRequestManager eventRequestManager = debugSession.getVM().eventRequestManager();
        if (event instanceof BreakpointEvent || event instanceof ExceptionEvent) {
            long threadId = ((LocatableEvent)event).thread().uniqueID();
            if (threadId == threadState.threadId && threadState.pendingStepRequest != null) {
                threadState.deleteStepRequest(eventRequestManager);
                threadState.deleteMethodExitRequest(eventRequestManager);
                context.getStepResultManager().removeMethodResult(threadId);
                if (threadState.eventSubscription != null) {
                    threadState.eventSubscription.dispose();
                }
            }
        } else if (event instanceof StepEvent) {
            ThreadReference thread = ((StepEvent)event).thread();
            threadState.deleteStepRequest(eventRequestManager);
            if (this.isStepFiltersConfigured(context.getStepFilters())) {
                try {
                    if (threadState.pendingStepType == Requests.Command.STEPIN) {
                        int currentStackDepth = thread.frameCount();
                        Location currentStepLocation = this.getTopFrame(thread).location();
                        if (this.shouldFilterLocation(threadState.stepLocation, currentStepLocation, context) || this.shouldDoExtraStepInto(threadState.stackDepth, threadState.stepLocation, currentStackDepth, currentStepLocation)) {
                            threadState.pendingStepRequest = DebugUtility.createStepIntoRequest(thread, context.getStepFilters().allowClasses, context.getStepFilters().skipClasses);
                            threadState.pendingStepRequest.enable();
                            debugEvent.shouldResume = true;
                            return;
                        }
                    }
                }
                catch (IncompatibleThreadStateException | IndexOutOfBoundsException currentStackDepth) {
                    // empty catch block
                }
            }
            threadState.deleteMethodExitRequest(eventRequestManager);
            if (threadState.eventSubscription != null) {
                threadState.eventSubscription.dispose();
            }
            context.getProtocolServer().sendEvent(new Events.StoppedEvent("step", thread.uniqueID()));
            debugEvent.shouldResume = false;
        } else if (event instanceof MethodExitEvent) {
            MethodExitEvent methodExitEvent = (MethodExitEvent)event;
            long threadId = methodExitEvent.thread().uniqueID();
            if (threadId == threadState.threadId && methodExitEvent.method().equals(threadState.stepLocation.method())) {
                Value returnValue = methodExitEvent.returnValue();
                if (returnValue instanceof VoidValue) {
                    context.getStepResultManager().removeMethodResult(threadId);
                } else {
                    JdiMethodResult methodResult = new JdiMethodResult(methodExitEvent.method(), returnValue);
                    context.getStepResultManager().setMethodResult(threadId, methodResult);
                }
            }
            debugEvent.shouldResume = true;
        }
    }

    private boolean isStepFiltersConfigured(Requests.StepFilters filters) {
        if (filters == null) {
            return false;
        }
        return ArrayUtils.isNotEmpty((Object[])filters.allowClasses) || ArrayUtils.isNotEmpty((Object[])filters.skipClasses) || ArrayUtils.isNotEmpty((Object[])filters.classNameFilters) || filters.skipConstructors || filters.skipStaticInitializers || filters.skipSynthetics;
    }

    private boolean shouldFilterLocation(Location originalLocation, Location currentLocation, IDebugAdapterContext context) throws IncompatibleThreadStateException {
        if (originalLocation == null || currentLocation == null) {
            return false;
        }
        return !this.shouldFilterMethod(originalLocation.method(), context) && this.shouldFilterMethod(currentLocation.method(), context);
    }

    private boolean shouldFilterMethod(Method method, IDebugAdapterContext context) {
        return context.getStepFilters().skipStaticInitializers && method.isStaticInitializer() || context.getStepFilters().skipSynthetics && method.isSynthetic() || context.getStepFilters().skipConstructors && method.isConstructor();
    }

    private boolean shouldDoExtraStepInto(int originalStackDepth, Location originalLocation, int currentStackDepth, Location currentLocation) throws IncompatibleThreadStateException {
        Method currentMethod;
        if (originalStackDepth != currentStackDepth) {
            return false;
        }
        if (originalLocation == null) {
            return false;
        }
        Method originalMethod = originalLocation.method();
        if (!originalMethod.equals(currentMethod = currentLocation.method())) {
            return false;
        }
        return originalLocation.lineNumber() == currentLocation.lineNumber();
    }

    private StackFrame getTopFrame(ThreadReference thread) throws IncompatibleThreadStateException {
        return thread.frame(0);
    }

    class ThreadState {
        long threadId = -1L;
        Requests.Command pendingStepType;
        StepRequest pendingStepRequest = null;
        MethodExitRequest pendingMethodExitRequest = null;
        int stackDepth = -1;
        StackFrame topFrame = null;
        Location stepLocation = null;
        Disposable eventSubscription = null;

        ThreadState() {
        }

        public void deleteMethodExitRequest(EventRequestManager manager) {
            DebugUtility.deleteEventRequestSafely(manager, this.pendingMethodExitRequest);
            this.pendingMethodExitRequest = null;
        }

        public void deleteStepRequest(EventRequestManager manager) {
            DebugUtility.deleteEventRequestSafely(manager, this.pendingStepRequest);
            this.pendingStepRequest = null;
        }
    }
}

