/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.java.debug.core.adapter.handler;

import com.microsoft.java.debug.core.IBreakpoint;
import com.microsoft.java.debug.core.adapter.AdapterUtils;
import com.microsoft.java.debug.core.adapter.ErrorCode;
import com.microsoft.java.debug.core.adapter.IDebugAdapterContext;
import com.microsoft.java.debug.core.adapter.IDebugRequestHandler;
import com.microsoft.java.debug.core.adapter.handler.SetBreakpointsRequestHandler;
import com.microsoft.java.debug.core.protocol.Messages;
import com.microsoft.java.debug.core.protocol.Requests;
import com.microsoft.java.debug.core.protocol.Responses;
import com.microsoft.java.debug.core.protocol.Types;
import java.util.Arrays;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import java.util.stream.Stream;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.commons.lang3.StringUtils;

public class BreakpointLocationsRequestHander
implements IDebugRequestHandler {
    @Override
    public List<Requests.Command> getTargetCommands() {
        return Arrays.asList(Requests.Command.BREAKPOINTLOCATIONS);
    }

    @Override
    public CompletableFuture<Messages.Response> handle(Requests.Command command, Requests.Arguments arguments, Messages.Response response, IDebugAdapterContext context) {
        Requests.BreakpointLocationsArguments bpArgs = (Requests.BreakpointLocationsArguments)arguments;
        String sourceUri = SetBreakpointsRequestHandler.normalizeSourcePath(bpArgs.source, context);
        if (StringUtils.isBlank((CharSequence)sourceUri)) {
            throw AdapterUtils.createCompletionException(String.format("Failed to get BreakpointLocations. Reason: '%s' is an invalid path.", bpArgs.source.path), ErrorCode.SET_BREAKPOINT_FAILURE);
        }
        int debuggerLine = AdapterUtils.convertLineNumber(bpArgs.line, context.isClientLinesStartAt1(), context.isDebuggerLinesStartAt1());
        IBreakpoint[] breakpoints = context.getBreakpointManager().getBreakpoints(sourceUri);
        Types.BreakpointLocation[] locations = new Types.BreakpointLocation[]{};
        for (int i = 0; i < breakpoints.length; ++i) {
            if (breakpoints[i].getLineNumber() != debuggerLine || !ArrayUtils.isNotEmpty((Object[])breakpoints[i].sourceLocation().availableBreakpointLocations())) continue;
            locations = (Types.BreakpointLocation[])Stream.of(breakpoints[i].sourceLocation().availableBreakpointLocations()).map(location -> {
                Types.BreakpointLocation newLocaiton = new Types.BreakpointLocation();
                newLocaiton.line = AdapterUtils.convertLineNumber(location.line, context.isDebuggerLinesStartAt1(), context.isClientLinesStartAt1());
                newLocaiton.column = AdapterUtils.convertColumnNumber(location.column, context.isDebuggerColumnsStartAt1(), context.isClientColumnsStartAt1());
                newLocaiton.endLine = AdapterUtils.convertLineNumber(location.endLine, context.isDebuggerLinesStartAt1(), context.isClientLinesStartAt1());
                newLocaiton.endColumn = AdapterUtils.convertColumnNumber(location.endColumn, context.isDebuggerColumnsStartAt1(), context.isClientColumnsStartAt1());
                return newLocaiton;
            }).toArray(Types.BreakpointLocation[]::new);
            break;
        }
        response.body = new Responses.BreakpointLocationsResponseBody(locations);
        return CompletableFuture.completedFuture(response);
    }
}

