/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.java.debug.core.adapter.handler;

import com.microsoft.java.debug.core.adapter.AdapterUtils;
import com.microsoft.java.debug.core.adapter.IDebugAdapterContext;
import com.microsoft.java.debug.core.adapter.IDebugRequestHandler;
import com.microsoft.java.debug.core.adapter.ISourceLookUpProvider;
import com.microsoft.java.debug.core.adapter.handler.StackTraceRequestHandler;
import com.microsoft.java.debug.core.adapter.variables.StackFrameReference;
import com.microsoft.java.debug.core.protocol.Messages;
import com.microsoft.java.debug.core.protocol.Requests;
import com.microsoft.java.debug.core.protocol.Responses;
import com.microsoft.java.debug.core.protocol.Types;
import com.sun.jdi.AbsentInformationException;
import com.sun.jdi.ReferenceType;
import com.sun.jdi.StackFrame;
import java.io.File;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import java.util.logging.Level;
import java.util.logging.Logger;

public class StepInTargetsRequestHandler
implements IDebugRequestHandler {
    private static final Logger logger = Logger.getLogger("java-debug");

    @Override
    public List<Requests.Command> getTargetCommands() {
        return Arrays.asList(Requests.Command.STEPIN_TARGETS);
    }

    @Override
    public CompletableFuture<Messages.Response> handle(Requests.Command command, Requests.Arguments arguments, Messages.Response response, IDebugAdapterContext context) {
        Requests.StepInTargetsArguments stepInTargetsArguments = (Requests.StepInTargetsArguments)arguments;
        int frameId = stepInTargetsArguments.frameId;
        return CompletableFuture.supplyAsync(() -> {
            response.body = new Responses.StepInTargetsResponse((Types.StepInTarget[])this.findFrame(frameId, context).map(f -> this.findTargets((StackFrameReference)f, context)).orElse(Collections.emptyList()).toArray(Types.StepInTarget[]::new));
            return response;
        });
    }

    private Optional<StackFrameReference> findFrame(int frameId, IDebugAdapterContext context) {
        Object object = context.getRecyclableIdPool().getObjectById(frameId);
        if (object instanceof StackFrameReference) {
            return Optional.of((StackFrameReference)object);
        }
        return Optional.empty();
    }

    private List<Types.StepInTarget> findTargets(StackFrameReference frameReference, IDebugAdapterContext context) {
        Types.Source source;
        StackFrame stackframe = context.getStackFrameManager().getStackFrame(frameReference);
        if (stackframe == null) {
            return Collections.emptyList();
        }
        Types.Source source2 = source = frameReference.getSource() == null ? this.findSource(stackframe, context) : frameReference.getSource();
        if (source == null) {
            return Collections.emptyList();
        }
        String sourceUri = AdapterUtils.convertPath(source.path, AdapterUtils.isUri(source.path), true);
        if (sourceUri == null) {
            return Collections.emptyList();
        }
        ISourceLookUpProvider sourceLookUpProvider = context.getProvider(ISourceLookUpProvider.class);
        List<ISourceLookUpProvider.MethodInvocation> invocations = sourceLookUpProvider.findMethodInvocations(sourceUri, stackframe.location().lineNumber());
        if (invocations.isEmpty()) {
            return Collections.emptyList();
        }
        long threadId = stackframe.thread().uniqueID();
        ArrayList<Types.StepInTarget> targets = new ArrayList<Types.StepInTarget>(invocations.size());
        for (ISourceLookUpProvider.MethodInvocation methodInvocation : invocations) {
            int id = context.getRecyclableIdPool().addObject(threadId, methodInvocation);
            Types.StepInTarget target = new Types.StepInTarget(id, methodInvocation.expression);
            target.column = AdapterUtils.convertColumnNumber(methodInvocation.columnStart, context.isDebuggerColumnsStartAt1(), context.isClientColumnsStartAt1());
            target.endColumn = AdapterUtils.convertColumnNumber(methodInvocation.columnEnd, context.isDebuggerColumnsStartAt1(), context.isClientColumnsStartAt1());
            target.line = AdapterUtils.convertLineNumber(methodInvocation.lineStart, context.isDebuggerLinesStartAt1(), context.isClientLinesStartAt1());
            target.endLine = AdapterUtils.convertLineNumber(methodInvocation.lineEnd, context.isDebuggerLinesStartAt1(), context.isClientLinesStartAt1());
            targets.add(target);
        }
        return targets;
    }

    private Types.Source findSource(StackFrame frame, IDebugAdapterContext context) {
        ReferenceType declaringType = frame.location().declaringType();
        String typeName = declaringType.name();
        Object sourceName = null;
        Object sourcePath = null;
        try {
            sourceName = declaringType.sourceName();
            sourcePath = declaringType.sourcePaths(null).get(0);
        }
        catch (AbsentInformationException e) {
            String enclosingType = AdapterUtils.parseEnclosingType(typeName);
            sourceName = enclosingType.substring(enclosingType.lastIndexOf(46) + 1) + ".java";
            sourcePath = enclosingType.replace('.', File.separatorChar) + ".java";
        }
        try {
            return StackTraceRequestHandler.convertDebuggerSourceToClient(typeName, (String)sourceName, (String)sourcePath, context);
        }
        catch (URISyntaxException e) {
            logger.log(Level.SEVERE, "Failed to resolve the source info of the stack frame.", e);
            return null;
        }
    }
}

