/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.java.debug.core.adapter.variables;

import com.microsoft.java.debug.core.adapter.IEvaluationProvider;
import com.microsoft.java.debug.core.adapter.variables.JavaLogicalStructure;
import com.sun.jdi.ObjectReference;
import com.sun.jdi.ThreadReference;
import com.sun.jdi.Value;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.CancellationException;
import java.util.concurrent.ExecutionException;

public class JavaLogicalStructureManager {
    private static final List<JavaLogicalStructure> supportedLogicalStructures = Collections.synchronizedList(new ArrayList());

    public static JavaLogicalStructure getLogicalStructure(ObjectReference obj) {
        for (JavaLogicalStructure structure : supportedLogicalStructures) {
            if (!structure.providesLogicalStructure(obj)) continue;
            return structure;
        }
        return null;
    }

    public static boolean isIndexedVariable(ObjectReference obj) {
        JavaLogicalStructure structure = JavaLogicalStructureManager.getLogicalStructure(obj);
        return structure != null && structure.getSizeExpression() != null;
    }

    public static Value getLogicalSize(ObjectReference thisObject, ThreadReference thread, IEvaluationProvider evaluationEngine) throws CancellationException, InterruptedException, IllegalArgumentException, ExecutionException, UnsupportedOperationException {
        JavaLogicalStructure structure = JavaLogicalStructureManager.getLogicalStructure(thisObject);
        if (structure == null) {
            return null;
        }
        return structure.getSize(thisObject, thread, evaluationEngine);
    }

    static {
        supportedLogicalStructures.add(new JavaLogicalStructure("java.util.Map", new JavaLogicalStructure.LogicalStructureExpression(JavaLogicalStructure.LogicalStructureExpressionType.METHOD, new String[]{"entrySet", "()Ljava/util/Set;"}, "entrySet()"), new JavaLogicalStructure.LogicalStructureExpression(JavaLogicalStructure.LogicalStructureExpressionType.METHOD, new String[]{"size", "()I"}), new JavaLogicalStructure.LogicalVariable[0]));
        supportedLogicalStructures.add(new JavaLogicalStructure("java.util.Map$Entry", "java.util.Map.Entry", null, null, new JavaLogicalStructure.LogicalVariable[]{new JavaLogicalStructure.LogicalVariable("key", new JavaLogicalStructure.LogicalStructureExpression(JavaLogicalStructure.LogicalStructureExpressionType.METHOD, new String[]{"getKey", "()Ljava/lang/Object;"}, "getKey()", true)), new JavaLogicalStructure.LogicalVariable("value", new JavaLogicalStructure.LogicalStructureExpression(JavaLogicalStructure.LogicalStructureExpressionType.METHOD, new String[]{"getValue", "()Ljava/lang/Object;"}, "getValue()", true))}));
        supportedLogicalStructures.add(new JavaLogicalStructure("java.util.List", new JavaLogicalStructure.LogicalStructureExpression(JavaLogicalStructure.LogicalStructureExpressionType.METHOD, new String[]{"toArray", "()[Ljava/lang/Object;"}, "get(%s)", true), new JavaLogicalStructure.LogicalStructureExpression(JavaLogicalStructure.LogicalStructureExpressionType.METHOD, new String[]{"size", "()I"}), new JavaLogicalStructure.LogicalVariable[0]));
        supportedLogicalStructures.add(new JavaLogicalStructure("java.util.Collection", new JavaLogicalStructure.LogicalStructureExpression(JavaLogicalStructure.LogicalStructureExpressionType.METHOD, new String[]{"toArray", "()[Ljava/lang/Object;"}, "toArray()", true), new JavaLogicalStructure.LogicalStructureExpression(JavaLogicalStructure.LogicalStructureExpressionType.METHOD, new String[]{"size", "()I"}), new JavaLogicalStructure.LogicalVariable[0]));
    }
}

