/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.java.debug.core.adapter.handler;

import com.microsoft.java.debug.core.adapter.IDebugAdapterContext;
import com.microsoft.java.debug.core.adapter.IDebugRequestHandler;
import com.microsoft.java.debug.core.protocol.Messages;
import com.microsoft.java.debug.core.protocol.Requests;
import com.microsoft.java.debug.core.protocol.Responses;
import java.util.Arrays;
import java.util.List;
import java.util.concurrent.CompletableFuture;

public class ProcessIdHandler
implements IDebugRequestHandler {
    @Override
    public List<Requests.Command> getTargetCommands() {
        return Arrays.asList(Requests.Command.PROCESSID);
    }

    @Override
    public CompletableFuture<Messages.Response> handle(Requests.Command command, Requests.Arguments arguments, Messages.Response response, IDebugAdapterContext context) {
        long processId = context.getProcessId();
        long shellProcessId = context.getShellProcessId();
        if (context.getDebuggeeProcess() != null) {
            processId = context.getDebuggeeProcess().pid();
        }
        response.body = new Responses.ProcessIdResponseBody(processId, shellProcessId);
        return CompletableFuture.completedFuture(response);
    }
}

