/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.java.debug.core;

import com.microsoft.java.debug.core.AsyncJdwpUtils;
import com.microsoft.java.debug.core.DebugUtility;
import com.microsoft.java.debug.core.EvaluatableBreakpoint;
import com.microsoft.java.debug.core.EventHub;
import com.microsoft.java.debug.core.IBreakpoint;
import com.microsoft.java.debug.core.IDebugSession;
import com.microsoft.java.debug.core.IEventHub;
import com.microsoft.java.debug.core.IMethodBreakpoint;
import com.microsoft.java.debug.core.IWatchpoint;
import com.microsoft.java.debug.core.JavaBreakpointLocation;
import com.microsoft.java.debug.core.MethodBreakpoint;
import com.microsoft.java.debug.core.Watchpoint;
import com.sun.jdi.ObjectCollectedException;
import com.sun.jdi.ReferenceType;
import com.sun.jdi.ThreadReference;
import com.sun.jdi.VMDisconnectedException;
import com.sun.jdi.VirtualMachine;
import com.sun.jdi.event.ClassPrepareEvent;
import com.sun.jdi.request.ClassPrepareRequest;
import com.sun.jdi.request.EventRequest;
import com.sun.jdi.request.EventRequestManager;
import com.sun.jdi.request.ExceptionRequest;
import com.sun.jdi.request.ThreadDeathRequest;
import com.sun.jdi.request.ThreadStartRequest;
import io.reactivex.disposables.Disposable;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang3.StringUtils;

public class DebugSession
implements IDebugSession {
    private VirtualMachine vm;
    private EventHub eventHub = new EventHub();
    private List<EventRequest> eventRequests = new ArrayList<EventRequest>();
    private List<Disposable> subscriptions = new ArrayList<Disposable>();

    public DebugSession(VirtualMachine virtualMachine) {
        this.vm = virtualMachine;
    }

    @Override
    public void start() {
        boolean supportsVirtualThreads = this.mayCreateVirtualThreads();
        ThreadStartRequest threadStartRequest = this.vm.eventRequestManager().createThreadStartRequest();
        threadStartRequest.setSuspendPolicy(0);
        if (supportsVirtualThreads) {
            this.addPlatformThreadsOnlyFilter(threadStartRequest);
        }
        threadStartRequest.enable();
        ThreadDeathRequest threadDeathRequest = this.vm.eventRequestManager().createThreadDeathRequest();
        threadDeathRequest.setSuspendPolicy(0);
        if (supportsVirtualThreads) {
            this.addPlatformThreadsOnlyFilter(threadDeathRequest);
        }
        threadDeathRequest.enable();
        this.eventHub.start(this.vm);
    }

    private boolean mayCreateVirtualThreads() {
        try {
            Method method = this.vm.getClass().getMethod("mayCreateVirtualThreads", new Class[0]);
            return (Boolean)method.invoke((Object)this.vm, new Object[0]);
        }
        catch (IllegalAccessException | IllegalArgumentException | NoSuchMethodException | SecurityException | InvocationTargetException exception) {
            return false;
        }
    }

    private void addPlatformThreadsOnlyFilter(EventRequest threadLifecycleRequest) {
        try {
            Method method = threadLifecycleRequest.getClass().getMethod("addPlatformThreadsOnlyFilter", new Class[0]);
            method.invoke((Object)threadLifecycleRequest, new Object[0]);
        }
        catch (IllegalAccessException | IllegalArgumentException | NoSuchMethodException | SecurityException | InvocationTargetException exception) {
            // empty catch block
        }
    }

    @Override
    public void suspend() {
        this.vm.suspend();
    }

    @Override
    public void resume() {
        for (ThreadReference tr : DebugUtility.getAllThreadsSafely(this)) {
            try {
                while (tr.suspendCount() > 1) {
                    tr.resume();
                }
            }
            catch (ObjectCollectedException objectCollectedException) {
            }
        }
        this.vm.resume();
    }

    @Override
    public void detach() {
        this.vm.dispose();
    }

    @Override
    public void terminate() {
        if (this.vm.process() == null || this.vm.process().isAlive()) {
            this.vm.exit(0);
        }
    }

    @Override
    public IBreakpoint createBreakpoint(JavaBreakpointLocation sourceLocation, int hitCount, String condition, String logMessage) {
        return new EvaluatableBreakpoint(this.vm, this.getEventHub(), sourceLocation, hitCount, condition, logMessage);
    }

    @Override
    public IBreakpoint createBreakpoint(String className, int lineNumber, int hitCount, String condition, String logMessage) {
        return new EvaluatableBreakpoint(this.vm, this.getEventHub(), className, lineNumber, hitCount, condition, logMessage);
    }

    @Override
    public IWatchpoint createWatchPoint(String className, String fieldName, String accessType, String condition, int hitCount) {
        return new Watchpoint(this.vm, this.getEventHub(), className, fieldName, accessType, condition, hitCount);
    }

    @Override
    public void setExceptionBreakpoints(boolean notifyCaught, boolean notifyUncaught) {
        this.setExceptionBreakpoints(notifyCaught, notifyUncaught, null, null);
    }

    @Override
    public void setExceptionBreakpoints(boolean notifyCaught, boolean notifyUncaught, String[] classFilters, String[] classExclusionFilters) {
        this.setExceptionBreakpoints(notifyCaught, notifyUncaught, null, classFilters, classExclusionFilters);
    }

    @Override
    public void setExceptionBreakpoints(boolean notifyCaught, boolean notifyUncaught, String[] exceptionTypes, String[] classFilters, String[] classExclusionFilters) {
        EventRequestManager manager = this.vm.eventRequestManager();
        try {
            ArrayList<ExceptionRequest> legacy = new ArrayList<ExceptionRequest>(manager.exceptionRequests());
            manager.deleteEventRequests(legacy);
            manager.deleteEventRequests(this.eventRequests);
        }
        catch (VMDisconnectedException legacy) {
            // empty catch block
        }
        this.subscriptions.forEach(subscription -> subscription.dispose());
        this.subscriptions.clear();
        this.eventRequests.clear();
        if (notifyCaught || notifyUncaught) {
            this.vm.allThreads();
            if (exceptionTypes == null || exceptionTypes.length == 0) {
                ExceptionRequest request = manager.createExceptionRequest(null, notifyCaught, notifyUncaught);
                request.setSuspendPolicy(1);
                if (classFilters != null) {
                    for (String classFilter : classFilters) {
                        request.addClassFilter(classFilter);
                    }
                }
                if (classExclusionFilters != null) {
                    for (String exclusionFilter : classExclusionFilters) {
                        request.addClassExclusionFilter(exclusionFilter);
                    }
                }
                request.enable();
                return;
            }
            for (String exceptionType : exceptionTypes) {
                if (StringUtils.isBlank((CharSequence)exceptionType)) continue;
                ClassPrepareRequest classPrepareRequest = manager.createClassPrepareRequest();
                classPrepareRequest.addClassFilter(exceptionType);
                classPrepareRequest.enable();
                this.eventRequests.add(classPrepareRequest);
                Disposable subscription2 = this.eventHub.events().filter(debugEvent -> debugEvent.event instanceof ClassPrepareEvent && this.eventRequests.contains(debugEvent.event.request())).subscribe(debugEvent -> {
                    ClassPrepareEvent event = (ClassPrepareEvent)debugEvent.event;
                    this.createExceptionBreakpoint(event.referenceType(), notifyCaught, notifyUncaught, classFilters, classExclusionFilters);
                });
                this.subscriptions.add(subscription2);
                for (ReferenceType refType : this.vm.classesByName(exceptionType)) {
                    this.createExceptionBreakpoint(refType, notifyCaught, notifyUncaught, classFilters, classExclusionFilters);
                }
            }
        }
    }

    @Override
    public void setExceptionBreakpoints(boolean notifyCaught, boolean notifyUncaught, String[] exceptionTypes, String[] classFilters, String[] classExclusionFilters, boolean async) {
        if (async) {
            AsyncJdwpUtils.runAsync(() -> this.setExceptionBreakpoints(notifyCaught, notifyUncaught, exceptionTypes, classFilters, classExclusionFilters));
        } else {
            this.setExceptionBreakpoints(notifyCaught, notifyUncaught, exceptionTypes, classFilters, classExclusionFilters);
        }
    }

    @Override
    public Process process() {
        return this.vm.process();
    }

    @Override
    public List<ThreadReference> getAllThreads() {
        return this.vm.allThreads();
    }

    @Override
    public IEventHub getEventHub() {
        return this.eventHub;
    }

    @Override
    public VirtualMachine getVM() {
        return this.vm;
    }

    @Override
    public IMethodBreakpoint createFunctionBreakpoint(String className, String functionName, String condition, int hitCount) {
        return new MethodBreakpoint(this.vm, this.getEventHub(), className, functionName, condition, hitCount);
    }

    private void createExceptionBreakpoint(ReferenceType refType, boolean notifyCaught, boolean notifyUncaught, String[] classFilters, String[] classExclusionFilters) {
        EventRequestManager manager = this.vm.eventRequestManager();
        ExceptionRequest request = manager.createExceptionRequest(refType, notifyCaught, notifyUncaught);
        request.setSuspendPolicy(1);
        if (classFilters != null) {
            for (String classFilter : classFilters) {
                request.addClassFilter(classFilter);
            }
        }
        if (classExclusionFilters != null) {
            for (String exclusionFilter : classExclusionFilters) {
                request.addClassExclusionFilter(exclusionFilter);
            }
        }
        request.enable();
    }
}

