/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.java.debug.core;

import com.microsoft.java.debug.core.AsyncJdwpUtils;
import com.microsoft.java.debug.core.IEvaluatableBreakpoint;
import com.microsoft.java.debug.core.IEventHub;
import com.microsoft.java.debug.core.IMethodBreakpoint;
import com.sun.jdi.ReferenceType;
import com.sun.jdi.ThreadReference;
import com.sun.jdi.VMDisconnectedException;
import com.sun.jdi.VirtualMachine;
import com.sun.jdi.event.ClassPrepareEvent;
import com.sun.jdi.event.ThreadDeathEvent;
import com.sun.jdi.request.ClassPrepareRequest;
import com.sun.jdi.request.EventRequest;
import com.sun.jdi.request.MethodEntryRequest;
import io.reactivex.Observable;
import io.reactivex.disposables.Disposable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.commons.lang3.StringUtils;

public class MethodBreakpoint
implements IMethodBreakpoint,
IEvaluatableBreakpoint {
    private VirtualMachine vm;
    private IEventHub eventHub;
    private String className;
    private String functionName;
    private String condition;
    private int hitCount;
    private boolean async = false;
    private HashMap<Object, Object> propertyMap = new HashMap();
    private Object compiledConditionalExpression = null;
    private Map<Long, Object> compiledExpressions = new ConcurrentHashMap<Long, Object>();
    private List<EventRequest> requests = Collections.synchronizedList(new ArrayList());
    private List<Disposable> subscriptions = new ArrayList<Disposable>();

    public MethodBreakpoint(VirtualMachine vm, IEventHub eventHub, String className, String functionName, String condition, int hitCount) {
        Objects.requireNonNull(vm);
        Objects.requireNonNull(eventHub);
        Objects.requireNonNull(className);
        Objects.requireNonNull(functionName);
        this.vm = vm;
        this.eventHub = eventHub;
        this.className = className;
        this.functionName = functionName;
        this.condition = condition;
        this.hitCount = hitCount;
    }

    @Override
    public List<EventRequest> requests() {
        return this.requests;
    }

    @Override
    public List<Disposable> subscriptions() {
        return this.subscriptions;
    }

    @Override
    public void close() throws Exception {
        try {
            this.vm.eventRequestManager().deleteEventRequests(this.requests());
        }
        catch (VMDisconnectedException vMDisconnectedException) {
            // empty catch block
        }
        this.subscriptions().forEach(Disposable::dispose);
        this.requests.clear();
        this.subscriptions.clear();
    }

    @Override
    public boolean containsEvaluatableExpression() {
        return this.containsConditionalExpression() || this.containsLogpointExpression();
    }

    @Override
    public boolean containsConditionalExpression() {
        return StringUtils.isNotBlank((CharSequence)this.getCondition());
    }

    @Override
    public boolean containsLogpointExpression() {
        return false;
    }

    @Override
    public String getCondition() {
        return this.condition;
    }

    @Override
    public void setCondition(String condition) {
        this.condition = condition;
        this.setCompiledConditionalExpression(null);
        this.compiledExpressions.clear();
    }

    @Override
    public String getLogMessage() {
        return null;
    }

    @Override
    public void setLogMessage(String logMessage) {
    }

    @Override
    public void setCompiledConditionalExpression(Object compiledExpression) {
        this.compiledConditionalExpression = compiledExpression;
    }

    @Override
    public Object getCompiledConditionalExpression() {
        return this.compiledConditionalExpression;
    }

    @Override
    public void setCompiledLogpointExpression(Object compiledExpression) {
    }

    @Override
    public Object getCompiledLogpointExpression() {
        return null;
    }

    @Override
    public void setCompiledExpression(long threadId, Object compiledExpression) {
        this.compiledExpressions.put(threadId, compiledExpression);
    }

    @Override
    public Object getCompiledExpression(long threadId) {
        return this.compiledExpressions.get(threadId);
    }

    @Override
    public int getHitCount() {
        return this.hitCount;
    }

    @Override
    public void setHitCount(int hitCount) {
        this.hitCount = hitCount;
        Observable.fromIterable(this.requests()).filter(request -> request instanceof MethodEntryRequest).subscribe(request -> {
            request.addCountFilter(hitCount);
            request.enable();
        });
    }

    @Override
    public boolean async() {
        return this.async;
    }

    @Override
    public void setAsync(boolean async) {
        this.async = async;
    }

    @Override
    public CompletableFuture<IMethodBreakpoint> install() {
        Disposable subscription = this.eventHub.events().filter(debugEvent -> debugEvent.event instanceof ThreadDeathEvent).subscribe(debugEvent -> {
            ThreadReference deathThread = ((ThreadDeathEvent)debugEvent.event).thread();
            this.compiledExpressions.remove(deathThread.uniqueID());
        });
        this.subscriptions.add(subscription);
        ClassPrepareRequest classPrepareRequest = this.vm.eventRequestManager().createClassPrepareRequest();
        classPrepareRequest.addClassFilter(this.className);
        classPrepareRequest.enable();
        this.requests.add(classPrepareRequest);
        CompletableFuture<IMethodBreakpoint> future = new CompletableFuture<IMethodBreakpoint>();
        subscription = this.eventHub.events().filter(debugEvent -> debugEvent.event instanceof ClassPrepareEvent && classPrepareRequest.equals(debugEvent.event.request())).subscribe(debugEvent -> {
            ClassPrepareEvent event = (ClassPrepareEvent)debugEvent.event;
            Optional<MethodEntryRequest> createdRequest = AsyncJdwpUtils.await(this.createMethodEntryRequest(event.referenceType()));
            if (createdRequest.isPresent()) {
                MethodEntryRequest methodEntryRequest = createdRequest.get();
                this.requests.add(methodEntryRequest);
                if (!future.isDone()) {
                    this.putProperty("verified", true);
                    future.complete(this);
                }
            }
        });
        this.subscriptions.add(subscription);
        Runnable createRequestsFromLoadedClasses = () -> {
            List<ReferenceType> types = this.vm.classesByName(this.className);
            for (ReferenceType type : types) {
                this.createMethodEntryRequest(type).whenComplete((createdRequest, ex) -> {
                    if (ex != null) {
                        return;
                    }
                    if (createdRequest.isPresent()) {
                        MethodEntryRequest methodEntryRequest = (MethodEntryRequest)createdRequest.get();
                        this.requests.add(methodEntryRequest);
                        if (!future.isDone()) {
                            this.putProperty("verified", true);
                            future.complete(this);
                        }
                    }
                });
            }
        };
        if (this.async()) {
            AsyncJdwpUtils.runAsync(createRequestsFromLoadedClasses);
        } else {
            createRequestsFromLoadedClasses.run();
        }
        return future;
    }

    private CompletableFuture<Optional<MethodEntryRequest>> createMethodEntryRequest(ReferenceType type) {
        if (this.async()) {
            return CompletableFuture.supplyAsync(() -> this.createMethodEntryRequest0(type));
        }
        return CompletableFuture.completedFuture(this.createMethodEntryRequest0(type));
    }

    private Optional<MethodEntryRequest> createMethodEntryRequest0(ReferenceType type) {
        return type.methodsByName(this.functionName).stream().findFirst().map(method -> {
            MethodEntryRequest request = this.vm.eventRequestManager().createMethodEntryRequest();
            request.addClassFilter(type);
            request.setSuspendPolicy(1);
            if (this.hitCount > 0) {
                request.addCountFilter(this.hitCount);
            }
            request.enable();
            return request;
        });
    }

    @Override
    public Object getProperty(Object key) {
        return this.propertyMap.get(key);
    }

    @Override
    public void putProperty(Object key, Object value) {
        this.propertyMap.put(key, value);
    }

    @Override
    public String methodName() {
        return this.functionName;
    }

    @Override
    public String className() {
        return this.className;
    }
}

