/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.java.debug.core.adapter;

import com.microsoft.java.debug.core.protocol.Events;
import io.reactivex.Observable;
import io.reactivex.ObservableSource;
import io.reactivex.schedulers.Schedulers;
import io.reactivex.subjects.PublishSubject;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.stream.Stream;

public class ProcessConsole {
    private InputStreamObservable stdoutStream;
    private InputStreamObservable stderrStream;
    private Observable<ConsoleMessage> observable = null;

    public ProcessConsole(Process process) {
        this(process, "Process", StandardCharsets.UTF_8);
    }

    public ProcessConsole(Process process, String name, Charset encoding) {
        this.stdoutStream = new InputStreamObservable(name + " Stdout Handler", process.getInputStream(), encoding);
        this.stderrStream = new InputStreamObservable(name + " Stderr Handler", process.getErrorStream(), encoding);
        Observable stdout = this.stdoutStream.messages().map(message -> new ConsoleMessage((String)message, Events.OutputEvent.Category.stdout));
        Observable stderr = this.stderrStream.messages().map(message -> new ConsoleMessage((String)message, Events.OutputEvent.Category.stderr));
        this.observable = Observable.mergeArrayDelayError((ObservableSource[])new ObservableSource[]{stdout, stderr}).observeOn(Schedulers.newThread());
    }

    public void start() {
        this.stdoutStream.start();
        this.stderrStream.start();
    }

    public void stop() {
        this.stdoutStream.stop();
        this.stderrStream.stop();
    }

    public Observable<ConsoleMessage> messages() {
        return this.observable;
    }

    public Observable<ConsoleMessage> stdoutMessages() {
        return this.messages().filter(message -> message.category == Events.OutputEvent.Category.stdout);
    }

    public Observable<ConsoleMessage> stderrMessages() {
        return this.messages().filter(message -> message.category == Events.OutputEvent.Category.stderr);
    }

    public Observable<ConsoleMessage> lineMessages() {
        return this.messages().map(message -> {
            String[] lines = message.output.split("(?<=\n)");
            return (ConsoleMessage[])Stream.of(lines).map(line -> new ConsoleMessage((String)line, message.category)).toArray(ConsoleMessage[]::new);
        }).concatMap(lines -> Observable.fromArray((Object[])lines));
    }

    public static class InputStreamObservable {
        private PublishSubject<String> rxSubject = PublishSubject.create();
        private String name;
        private InputStream inputStream;
        private Charset encoding;
        private Thread loopingThread;

        public InputStreamObservable(String name, InputStream inputStream, Charset encoding) {
            this.name = name;
            this.inputStream = inputStream;
            this.encoding = encoding;
        }

        public void start() {
            this.loopingThread = new Thread(this.name){

                @Override
                public void run() {
                    this.monitor(inputStream, rxSubject);
                }
            };
            this.loopingThread.setDaemon(true);
            this.loopingThread.start();
        }

        public void stop() {
            if (this.loopingThread != null) {
                this.loopingThread.interrupt();
                this.loopingThread = null;
            }
        }

        private void monitor(InputStream input, PublishSubject<String> subject) {
            BufferedReader reader = new BufferedReader(this.encoding == null ? new InputStreamReader(input) : new InputStreamReader(input, this.encoding));
            int BUFFERSIZE = 4096;
            char[] buffer = new char[4096];
            try {
                while (true) {
                    if (Thread.interrupted()) {
                        subject.onComplete();
                        return;
                    }
                    int read = reader.read(buffer, 0, 4096);
                    if (read == -1) {
                        subject.onComplete();
                        return;
                    }
                    subject.onNext((Object)new String(buffer, 0, read));
                }
            }
            catch (IOException e) {
                subject.onError((Throwable)e);
                return;
            }
        }

        public Observable<String> messages() {
            return this.rxSubject;
        }
    }

    public static class ConsoleMessage {
        public String output;
        public Events.OutputEvent.Category category;

        public ConsoleMessage(String message, Events.OutputEvent.Category category) {
            this.output = message;
            this.category = category;
        }
    }
}

