/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.java.debug.core.adapter;

import com.microsoft.java.debug.core.adapter.IStackFrameManager;
import com.microsoft.java.debug.core.adapter.variables.StackFrameReference;
import com.sun.jdi.IncompatibleThreadStateException;
import com.sun.jdi.StackFrame;
import com.sun.jdi.ThreadReference;
import java.util.HashMap;
import java.util.Map;

public class StackFrameManager
implements IStackFrameManager {
    private Map<Long, StackFrame[]> threadStackFrameMap = new HashMap<Long, StackFrame[]>();

    @Override
    public synchronized StackFrame getStackFrame(StackFrameReference ref) {
        ThreadReference thread = ref.getThread();
        int depth = ref.getDepth();
        StackFrame[] frames = this.threadStackFrameMap.get(thread.uniqueID());
        return frames == null || frames.length < depth ? null : frames[depth];
    }

    @Override
    public synchronized StackFrame[] reloadStackFrames(ThreadReference thread) {
        return this.reloadStackFrames(thread, true);
    }

    @Override
    public synchronized StackFrame[] reloadStackFrames(ThreadReference thread, boolean force) {
        return this.threadStackFrameMap.compute(thread.uniqueID(), (key, old) -> {
            try {
                if (old == null || ((StackFrame[])old).length == 0) {
                    if (force) {
                        return thread.frames().toArray(new StackFrame[0]);
                    }
                    return new StackFrame[0];
                }
                return thread.frames(0, ((StackFrame[])old).length).toArray(new StackFrame[0]);
            }
            catch (IncompatibleThreadStateException e) {
                return new StackFrame[0];
            }
        });
    }

    @Override
    public synchronized StackFrame[] reloadStackFrames(ThreadReference thread, int start, int length) {
        long threadId = thread.uniqueID();
        StackFrame[] old = this.threadStackFrameMap.get(threadId);
        try {
            StackFrame[] newFrames = thread.frames(start, length).toArray(new StackFrame[0]);
            if (old == null || start == 0 && length == old.length) {
                this.threadStackFrameMap.put(threadId, newFrames);
            } else {
                int maxLength = Math.max(old.length, start + length);
                StackFrame[] totalFrames = new StackFrame[maxLength];
                System.arraycopy(old, 0, totalFrames, 0, old.length);
                System.arraycopy(newFrames, 0, totalFrames, start, length);
                this.threadStackFrameMap.put(threadId, totalFrames);
            }
            return newFrames;
        }
        catch (IncompatibleThreadStateException | IndexOutOfBoundsException e) {
            return new StackFrame[0];
        }
    }

    @Override
    public synchronized void clearStackFrames(ThreadReference thread) {
        this.threadStackFrameMap.remove(thread.uniqueID());
    }

    @Override
    public synchronized void clearStackFrames() {
        this.threadStackFrameMap.clear();
    }
}

