/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.java.debug.core;

import com.microsoft.java.debug.core.AsyncJdwpUtils;
import com.microsoft.java.debug.core.IBreakpoint;
import com.microsoft.java.debug.core.IEventHub;
import com.microsoft.java.debug.core.JavaBreakpointLocation;
import com.sun.jdi.AbsentInformationException;
import com.sun.jdi.Location;
import com.sun.jdi.Method;
import com.sun.jdi.ReferenceType;
import com.sun.jdi.VMDisconnectedException;
import com.sun.jdi.VirtualMachine;
import com.sun.jdi.event.ClassPrepareEvent;
import com.sun.jdi.request.BreakpointRequest;
import com.sun.jdi.request.ClassPrepareRequest;
import com.sun.jdi.request.EventRequest;
import io.reactivex.Observable;
import io.reactivex.disposables.Disposable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.CompletableFuture;

public class Breakpoint
implements IBreakpoint {
    private VirtualMachine vm = null;
    private IEventHub eventHub = null;
    private JavaBreakpointLocation sourceLocation = null;
    private int hitCount = 0;
    private String condition = null;
    private String logMessage = null;
    private HashMap<Object, Object> propertyMap = new HashMap();
    private boolean async = false;
    private List<EventRequest> requests = Collections.synchronizedList(new ArrayList());
    private List<Disposable> subscriptions = new ArrayList<Disposable>();

    Breakpoint(VirtualMachine vm, IEventHub eventHub, String className, int lineNumber) {
        this(vm, eventHub, className, lineNumber, 0, null);
    }

    Breakpoint(VirtualMachine vm, IEventHub eventHub, String className, int lineNumber, int hitCount) {
        this(vm, eventHub, className, lineNumber, hitCount, null);
    }

    Breakpoint(VirtualMachine vm, IEventHub eventHub, String className, int lineNumber, int hitCount, String condition) {
        this(vm, eventHub, className, lineNumber, hitCount, condition, null);
    }

    Breakpoint(VirtualMachine vm, IEventHub eventHub, String className, int lineNumber, int hitCount, String condition, String logMessage) {
        this.vm = vm;
        this.eventHub = eventHub;
        String contextClass = className;
        String methodName = null;
        String methodSignature = null;
        if (className != null && className.contains("#")) {
            contextClass = className.substring(0, className.indexOf("#"));
            String[] methodInfo = className.substring(className.indexOf("#") + 1).split("#");
            methodName = methodInfo[0];
            methodSignature = methodInfo[1];
        }
        this.sourceLocation = new JavaBreakpointLocation(lineNumber, -1);
        this.sourceLocation.setClassName(contextClass);
        this.sourceLocation.setMethodName(methodName);
        this.sourceLocation.setMethodSignature(methodSignature);
        this.hitCount = hitCount;
        this.condition = condition;
        this.logMessage = logMessage;
    }

    Breakpoint(VirtualMachine vm, IEventHub eventHub, JavaBreakpointLocation sourceLocation, int hitCount, String condition, String logMessage) {
        this.vm = vm;
        this.eventHub = eventHub;
        this.sourceLocation = sourceLocation;
        this.hitCount = hitCount;
        this.condition = condition;
        this.logMessage = logMessage;
    }

    @Override
    public List<EventRequest> requests() {
        return this.requests;
    }

    @Override
    public List<Disposable> subscriptions() {
        return this.subscriptions;
    }

    @Override
    public void close() throws Exception {
        try {
            this.vm.eventRequestManager().deleteEventRequests(this.requests());
        }
        catch (VMDisconnectedException vMDisconnectedException) {
            // empty catch block
        }
        this.subscriptions().forEach(subscription -> subscription.dispose());
        this.requests.clear();
        this.subscriptions.clear();
    }

    @Override
    public JavaBreakpointLocation sourceLocation() {
        return this.sourceLocation;
    }

    @Override
    public String className() {
        return this.sourceLocation.className();
    }

    @Override
    public int getLineNumber() {
        return this.sourceLocation.lineNumber();
    }

    @Override
    public int getColumnNumber() {
        return this.sourceLocation.columnNumber();
    }

    @Override
    public String getCondition() {
        return this.condition;
    }

    public int hashCode() {
        return Objects.hash(this.sourceLocation);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof Breakpoint)) {
            return false;
        }
        Breakpoint other = (Breakpoint)obj;
        return Objects.equals(this.sourceLocation, other.sourceLocation);
    }

    @Override
    public int getHitCount() {
        return this.hitCount;
    }

    @Override
    public void setHitCount(int hitCount) {
        this.hitCount = hitCount;
        Observable.fromIterable(this.requests()).filter(request -> request instanceof BreakpointRequest).subscribe(request -> {
            request.addCountFilter(hitCount);
            request.disable();
            request.enable();
        });
    }

    @Override
    public void setCondition(String condition) {
        this.condition = condition;
    }

    @Override
    public void setLogMessage(String logMessage) {
        this.logMessage = logMessage;
    }

    @Override
    public String getLogMessage() {
        return this.logMessage;
    }

    @Override
    public boolean async() {
        return this.async;
    }

    @Override
    public void setAsync(boolean async) {
        this.async = async;
    }

    @Override
    public CompletableFuture<IBreakpoint> install() {
        ClassPrepareRequest classPrepareRequest = this.vm.eventRequestManager().createClassPrepareRequest();
        classPrepareRequest.addClassFilter(this.className());
        classPrepareRequest.enable();
        this.requests.add(classPrepareRequest);
        ClassPrepareRequest localClassPrepareRequest = this.vm.eventRequestManager().createClassPrepareRequest();
        localClassPrepareRequest.addClassFilter(this.className() + "$*");
        localClassPrepareRequest.enable();
        this.requests.add(localClassPrepareRequest);
        CompletableFuture<IBreakpoint> future = new CompletableFuture<IBreakpoint>();
        Disposable subscription = this.eventHub.events().filter(debugEvent -> debugEvent.event instanceof ClassPrepareEvent && (classPrepareRequest.equals(debugEvent.event.request()) || localClassPrepareRequest.equals(debugEvent.event.request()))).subscribe(debugEvent -> {
            ClassPrepareEvent event = (ClassPrepareEvent)debugEvent.event;
            List<BreakpointRequest> newRequests = AsyncJdwpUtils.await(this.createBreakpointRequests(event.referenceType(), this.getLineNumber(), this.hitCount, false));
            this.requests.addAll(newRequests);
            if (!newRequests.isEmpty() && !future.isDone()) {
                this.putProperty("verified", true);
                future.complete(this);
            }
        });
        this.subscriptions.add(subscription);
        Runnable resolveRequestsFromExistingClasses = () -> {
            List<ReferenceType> refTypes = this.vm.classesByName(this.className());
            this.createBreakpointRequests(refTypes, this.getLineNumber(), this.hitCount, true).whenComplete((newRequests, ex) -> {
                if (ex != null) {
                    return;
                }
                this.requests.addAll((Collection<EventRequest>)newRequests);
                if (!newRequests.isEmpty() && !future.isDone()) {
                    this.putProperty("verified", true);
                    future.complete(this);
                }
            });
        };
        if (this.async()) {
            AsyncJdwpUtils.runAsync(resolveRequestsFromExistingClasses);
        } else {
            resolveRequestsFromExistingClasses.run();
        }
        return future;
    }

    private CompletableFuture<List<Location>> collectLocations(ReferenceType refType, int lineNumber) {
        ArrayList futures = new ArrayList();
        for (Method method : refType.methods()) {
            if (this.async()) {
                futures.add(AsyncJdwpUtils.supplyAsync(() -> this.findLocaitonsOfLine(method, lineNumber)));
                continue;
            }
            futures.add(CompletableFuture.completedFuture(this.findLocaitonsOfLine(method, lineNumber)));
        }
        return AsyncJdwpUtils.flatAll(futures);
    }

    private CompletableFuture<List<Location>> collectLocations(List<ReferenceType> refTypes, int lineNumber, boolean includeNestedTypes) {
        ArrayList futures = new ArrayList();
        refTypes.forEach(refType -> futures.add(this.collectLocations((ReferenceType)refType, lineNumber, includeNestedTypes)));
        return AsyncJdwpUtils.flatAll(futures);
    }

    private CompletableFuture<List<Location>> collectLocations(ReferenceType refType, int lineNumber, boolean includeNestedTypes) {
        return this.collectLocations(refType, lineNumber).thenCompose(newLocations -> {
            if (!newLocations.isEmpty()) {
                return CompletableFuture.completedFuture(newLocations);
            }
            if (includeNestedTypes) {
                for (ReferenceType nestedType : refType.nestedTypes()) {
                    CompletableFuture<List<Location>> nestedLocationsFuture = this.collectLocations(nestedType, lineNumber);
                    List<Location> nestedLocations = nestedLocationsFuture.join();
                    if (nestedLocations.isEmpty()) continue;
                    return CompletableFuture.completedFuture(nestedLocations);
                }
            }
            return CompletableFuture.completedFuture(Collections.emptyList());
        });
    }

    private CompletableFuture<List<Location>> collectLocations(List<ReferenceType> refTypes, String methodName, String methodSiguature) {
        ArrayList futures = new ArrayList();
        for (ReferenceType refType : refTypes) {
            if (this.async()) {
                futures.add(AsyncJdwpUtils.supplyAsync(() -> this.findMethodLocaiton(refType, methodName, methodSiguature)));
                continue;
            }
            futures.add(CompletableFuture.completedFuture(this.findMethodLocaiton(refType, methodName, methodSiguature)));
        }
        return AsyncJdwpUtils.all(futures);
    }

    private Location findMethodLocaiton(ReferenceType refType, String methodName, String methodSiguature) {
        List<Method> methods = refType.methods();
        Location location = null;
        for (Method method : methods) {
            if (method.isAbstract() || method.isNative() || !methodName.equals(method.name()) || !methodSiguature.equals(method.genericSignature()) && !methodSiguature.equals(method.signature()) && !Breakpoint.toNoneGeneric(methodSiguature).equals(method.signature())) continue;
            location = method.location();
            break;
        }
        return location;
    }

    static String toNoneGeneric(String genericSig) {
        StringBuilder builder = new StringBuilder();
        boolean append = true;
        int depth = 0;
        char[] chars = genericSig.toCharArray();
        for (int i = 0; i < chars.length; ++i) {
            char c = chars[i];
            if (c == '<') {
                boolean bl = append = ++depth == 0;
            }
            if (append) {
                builder.append(c);
            }
            if (c != '>') continue;
            append = --depth == 0;
        }
        return builder.toString();
    }

    private List<Location> findLocaitonsOfLine(Method method, int lineNumber) {
        try {
            return method.locationsOfLine(lineNumber);
        }
        catch (AbsentInformationException absentInformationException) {
            return Collections.emptyList();
        }
    }

    private CompletableFuture<List<BreakpointRequest>> createBreakpointRequests(ReferenceType refType, int lineNumber, int hitCount, boolean includeNestedTypes) {
        return this.createBreakpointRequests(Arrays.asList(refType), lineNumber, hitCount, includeNestedTypes);
    }

    private CompletableFuture<List<BreakpointRequest>> createBreakpointRequests(List<ReferenceType> refTypes, int lineNumber, int hitCount, boolean includeNestedTypes) {
        CompletableFuture<List<Location>> locationsFuture = this.sourceLocation.methodName() != null ? this.collectLocations(refTypes, this.sourceLocation.methodName(), this.sourceLocation.methodSignature()) : this.collectLocations(refTypes, lineNumber, includeNestedTypes).thenApply(locations -> {
            if (locations.isEmpty()) {
                return locations;
            }
            return Arrays.asList((Location)locations.get(0));
        });
        return locationsFuture.thenCompose(locations -> {
            ArrayList existingLocations = new ArrayList(this.requests.size());
            Observable.fromIterable(this.requests).filter(request -> request instanceof BreakpointRequest).map(request -> ((BreakpointRequest)request).location()).toList().subscribe(list -> existingLocations.addAll(list));
            ArrayList newLocations = new ArrayList(locations.size());
            Observable.fromIterable((Iterable)locations).filter(location -> !existingLocations.contains(location)).toList().subscribe(list -> newLocations.addAll(list));
            ArrayList newRequests = new ArrayList(newLocations.size());
            newLocations.forEach(location -> {
                BreakpointRequest request = this.vm.eventRequestManager().createBreakpointRequest((Location)location);
                request.setSuspendPolicy(1);
                if (hitCount > 0) {
                    request.addCountFilter(hitCount);
                }
                request.putProperty("request_type", this.computeRequestType());
                newRequests.add(request);
            });
            ArrayList futures = new ArrayList();
            for (BreakpointRequest request2 : newRequests) {
                if (this.async()) {
                    futures.add(AsyncJdwpUtils.runAsync(() -> {
                        try {
                            request2.enable();
                        }
                        catch (VMDisconnectedException vMDisconnectedException) {
                            // empty catch block
                        }
                    }));
                    continue;
                }
                try {
                    request2.enable();
                }
                catch (VMDisconnectedException vMDisconnectedException) {}
            }
            return AsyncJdwpUtils.all(futures).thenApply(res -> newRequests);
        });
    }

    private Object computeRequestType() {
        if (this.sourceLocation.methodName() == null) {
            return 0;
        }
        if (this.sourceLocation.methodName().startsWith("lambda$")) {
            return 2;
        }
        return 1;
    }

    @Override
    public void putProperty(Object key, Object value) {
        this.propertyMap.put(key, value);
    }

    @Override
    public Object getProperty(Object key) {
        return this.propertyMap.get(key);
    }
}

