/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.java.debug.core.adapter;

import com.microsoft.java.debug.core.DebugSettings;
import com.microsoft.java.debug.core.IDebugSession;
import com.microsoft.java.debug.core.adapter.BreakpointManager;
import com.microsoft.java.debug.core.adapter.ExceptionManager;
import com.microsoft.java.debug.core.adapter.IBreakpointManager;
import com.microsoft.java.debug.core.adapter.IDebugAdapterContext;
import com.microsoft.java.debug.core.adapter.IExceptionManager;
import com.microsoft.java.debug.core.adapter.IProvider;
import com.microsoft.java.debug.core.adapter.IProviderContext;
import com.microsoft.java.debug.core.adapter.IStackFrameManager;
import com.microsoft.java.debug.core.adapter.IStepResultManager;
import com.microsoft.java.debug.core.adapter.IdCollection;
import com.microsoft.java.debug.core.adapter.LRUCache;
import com.microsoft.java.debug.core.adapter.LaunchMode;
import com.microsoft.java.debug.core.adapter.RecyclableObjectPool;
import com.microsoft.java.debug.core.adapter.Source;
import com.microsoft.java.debug.core.adapter.StackFrameManager;
import com.microsoft.java.debug.core.adapter.StepResultManager;
import com.microsoft.java.debug.core.adapter.ThreadCache;
import com.microsoft.java.debug.core.adapter.variables.IVariableFormatter;
import com.microsoft.java.debug.core.adapter.variables.VariableFormatterFactory;
import com.microsoft.java.debug.core.protocol.IProtocolServer;
import com.microsoft.java.debug.core.protocol.Requests;
import java.nio.charset.Charset;
import java.nio.file.Path;
import java.util.Arrays;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.Map;
import org.apache.commons.lang3.ArrayUtils;

public class DebugAdapterContext
implements IDebugAdapterContext {
    private static final int MAX_CACHE_ITEMS = 10000;
    private final Requests.StepFilters defaultFilters = new Requests.StepFilters();
    private Map<String, Source> sourceMappingCache = Collections.synchronizedMap(new LRUCache(10000));
    private IProviderContext providerContext;
    private IProtocolServer server;
    private IDebugSession debugSession;
    private boolean debuggerLinesStartAt1 = true;
    private boolean debuggerColumnStartAt1 = false;
    private boolean debuggerPathsAreUri = true;
    private boolean clientLinesStartAt1 = true;
    private boolean clientColumnsStartAt1 = true;
    private boolean clientPathsAreUri = false;
    private boolean supportsRunInTerminalRequest;
    private boolean isAttached = false;
    private String[] sourcePaths;
    private Charset debuggeeEncoding;
    private transient boolean vmTerminated;
    private boolean isVmStopOnEntry = false;
    private LaunchMode launchMode = LaunchMode.DEBUG;
    private Process debuggeeProcess;
    private String mainClass;
    private Requests.StepFilters stepFilters;
    private Path classpathJar = null;
    private Path argsfile = null;
    private boolean isInitialized = false;
    private long shellProcessId = -1L;
    private long processId = -1L;
    private boolean localDebugging = true;
    private long jdwpLatency = 0L;
    private IdCollection<String> sourceReferences = new IdCollection();
    private RecyclableObjectPool<Long, Object> recyclableIdPool = new RecyclableObjectPool();
    private IVariableFormatter variableFormatter = VariableFormatterFactory.createVariableFormatter();
    private IStackFrameManager stackFrameManager = new StackFrameManager();
    private IExceptionManager exceptionManager = new ExceptionManager();
    private IBreakpointManager breakpointManager = new BreakpointManager();
    private IStepResultManager stepResultManager = new StepResultManager();
    private ThreadCache threadCache = new ThreadCache();

    public DebugAdapterContext(IProtocolServer server, IProviderContext providerContext) {
        this.providerContext = providerContext;
        this.server = server;
    }

    @Override
    public IProtocolServer getProtocolServer() {
        return this.server;
    }

    @Override
    public <T extends IProvider> T getProvider(Class<T> clazz) {
        return this.providerContext.getProvider(clazz);
    }

    @Override
    public void setDebugSession(IDebugSession session) {
        this.debugSession = session;
    }

    @Override
    public IDebugSession getDebugSession() {
        return this.debugSession;
    }

    @Override
    public boolean isDebuggerLinesStartAt1() {
        return this.debuggerLinesStartAt1;
    }

    @Override
    public void setDebuggerLinesStartAt1(boolean debuggerLinesStartAt1) {
        this.debuggerLinesStartAt1 = debuggerLinesStartAt1;
    }

    @Override
    public boolean isDebuggerColumnsStartAt1() {
        return this.debuggerColumnStartAt1;
    }

    @Override
    public boolean isDebuggerPathsAreUri() {
        return this.debuggerPathsAreUri;
    }

    @Override
    public void setDebuggerPathsAreUri(boolean debuggerPathsAreUri) {
        this.debuggerPathsAreUri = debuggerPathsAreUri;
    }

    @Override
    public boolean isClientLinesStartAt1() {
        return this.clientLinesStartAt1;
    }

    @Override
    public void setClientLinesStartAt1(boolean clientLinesStartAt1) {
        this.clientLinesStartAt1 = clientLinesStartAt1;
    }

    @Override
    public boolean isClientColumnsStartAt1() {
        return this.clientColumnsStartAt1;
    }

    @Override
    public void setClientColumnsStartAt1(boolean clientColumnsStartAt1) {
        this.clientColumnsStartAt1 = clientColumnsStartAt1;
    }

    @Override
    public boolean isClientPathsAreUri() {
        return this.clientPathsAreUri;
    }

    @Override
    public void setClientPathsAreUri(boolean clientPathsAreUri) {
        this.clientPathsAreUri = clientPathsAreUri;
    }

    @Override
    public void setSupportsRunInTerminalRequest(boolean supportsRunInTerminalRequest) {
        this.supportsRunInTerminalRequest = supportsRunInTerminalRequest;
    }

    @Override
    public boolean supportsRunInTerminalRequest() {
        return this.supportsRunInTerminalRequest;
    }

    @Override
    public boolean isAttached() {
        return this.isAttached;
    }

    @Override
    public void setAttached(boolean attached) {
        this.isAttached = attached;
    }

    @Override
    public String[] getSourcePaths() {
        return this.sourcePaths;
    }

    @Override
    public void setSourcePaths(String[] sourcePaths) {
        this.sourcePaths = sourcePaths;
    }

    @Override
    public String getSourceUri(int sourceReference) {
        return this.sourceReferences.get(sourceReference);
    }

    @Override
    public int createSourceReference(String uri) {
        return this.sourceReferences.create(uri);
    }

    @Override
    public RecyclableObjectPool<Long, Object> getRecyclableIdPool() {
        return this.recyclableIdPool;
    }

    @Override
    public void setRecyclableIdPool(RecyclableObjectPool<Long, Object> idPool) {
        this.recyclableIdPool = idPool;
    }

    @Override
    public IVariableFormatter getVariableFormatter() {
        return this.variableFormatter;
    }

    @Override
    public void setVariableFormatter(IVariableFormatter variableFormatter) {
        this.variableFormatter = variableFormatter;
    }

    @Override
    public Map<String, Source> getSourceLookupCache() {
        return this.sourceMappingCache;
    }

    @Override
    public void setDebuggeeEncoding(Charset encoding) {
        this.debuggeeEncoding = encoding;
    }

    @Override
    public Charset getDebuggeeEncoding() {
        return this.debuggeeEncoding;
    }

    @Override
    public void setVmTerminated() {
        this.vmTerminated = true;
    }

    @Override
    public boolean isVmTerminated() {
        return this.vmTerminated;
    }

    @Override
    public void setVmStopOnEntry(boolean stopOnEntry) {
        this.isVmStopOnEntry = stopOnEntry;
    }

    @Override
    public boolean isVmStopOnEntry() {
        return this.isVmStopOnEntry;
    }

    @Override
    public void setMainClass(String mainClass) {
        this.mainClass = mainClass;
    }

    @Override
    public String getMainClass() {
        return this.mainClass;
    }

    @Override
    public void setStepFilters(Requests.StepFilters stepFilters) {
        if (stepFilters != null && ArrayUtils.isNotEmpty((Object[])stepFilters.classNameFilters)) {
            LinkedHashSet<String> patterns = new LinkedHashSet<String>();
            if (ArrayUtils.isNotEmpty((Object[])stepFilters.skipClasses)) {
                patterns.addAll(Arrays.asList(stepFilters.skipClasses));
            }
            patterns.addAll(Arrays.asList(stepFilters.classNameFilters));
            stepFilters.skipClasses = patterns.toArray(new String[0]);
        }
        this.stepFilters = stepFilters;
    }

    @Override
    public Requests.StepFilters getStepFilters() {
        if (this.stepFilters != null) {
            return this.stepFilters;
        }
        if (DebugSettings.getCurrent().stepFilters != null) {
            return DebugSettings.getCurrent().stepFilters;
        }
        return this.defaultFilters;
    }

    @Override
    public IStackFrameManager getStackFrameManager() {
        return this.stackFrameManager;
    }

    @Override
    public LaunchMode getLaunchMode() {
        return this.launchMode;
    }

    @Override
    public void setLaunchMode(LaunchMode launchMode) {
        this.launchMode = launchMode;
    }

    @Override
    public Process getDebuggeeProcess() {
        return this.debuggeeProcess;
    }

    @Override
    public void setDebuggeeProcess(Process debuggeeProcess) {
        this.debuggeeProcess = debuggeeProcess;
    }

    @Override
    public void setClasspathJar(Path classpathJar) {
        this.classpathJar = classpathJar;
    }

    @Override
    public Path getClasspathJar() {
        return this.classpathJar;
    }

    @Override
    public void setArgsfile(Path argsfile) {
        this.argsfile = argsfile;
    }

    @Override
    public Path getArgsfile() {
        return this.argsfile;
    }

    @Override
    public IExceptionManager getExceptionManager() {
        return this.exceptionManager;
    }

    @Override
    public IBreakpointManager getBreakpointManager() {
        return this.breakpointManager;
    }

    @Override
    public IStepResultManager getStepResultManager() {
        return this.stepResultManager;
    }

    @Override
    public long getProcessId() {
        return this.processId;
    }

    @Override
    public long getShellProcessId() {
        return this.shellProcessId;
    }

    @Override
    public void setProcessId(long processId) {
        this.processId = processId;
    }

    @Override
    public void setShellProcessId(long shellProcessId) {
        this.shellProcessId = shellProcessId;
    }

    @Override
    public void setThreadCache(ThreadCache cache) {
        this.threadCache = cache;
    }

    @Override
    public ThreadCache getThreadCache() {
        return this.threadCache;
    }

    @Override
    public boolean asyncJDWP() {
        return this.asyncJDWP(15L);
    }

    @Override
    public boolean asyncJDWP(long usableLatency) {
        return DebugSettings.getCurrent().asyncJDWP == DebugSettings.AsyncMode.ON || DebugSettings.getCurrent().asyncJDWP == DebugSettings.AsyncMode.AUTO && this.jdwpLatency > usableLatency;
    }

    @Override
    public boolean isLocalDebugging() {
        return this.localDebugging;
    }

    @Override
    public void setLocalDebugging(boolean local) {
        this.localDebugging = local;
    }

    @Override
    public long getJDWPLatency() {
        return this.jdwpLatency;
    }

    @Override
    public void setJDWPLatency(long baseLatency) {
        this.jdwpLatency = baseLatency;
    }

    @Override
    public boolean isInitialized() {
        return this.isInitialized;
    }

    @Override
    public void setInitialized(boolean isInitialized) {
        this.isInitialized = isInitialized;
    }
}

