/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.java.debug.core.adapter.formatter;

import com.microsoft.java.debug.core.adapter.formatter.IValueFormatter;
import com.microsoft.java.debug.core.adapter.formatter.NumericFormatEnum;
import com.sun.jdi.Type;
import com.sun.jdi.Value;
import com.sun.jdi.VirtualMachine;
import java.util.HashMap;
import java.util.Map;

public class NumericFormatter
implements IValueFormatter {
    public static final String NUMERIC_FORMAT_OPTION = "numeric_format";
    public static final String NUMERIC_PRECISION_OPTION = "numeric_precision";
    private static final NumericFormatEnum DEFAULT_NUMERIC_FORMAT = NumericFormatEnum.DEC;
    private static final int DEFAULT_NUMERIC_PRECISION = 0;
    private static final Map<NumericFormatEnum, String> enumFormatMap = new HashMap<NumericFormatEnum, String>();

    @Override
    public String toString(Object obj, Map<String, Object> options) {
        Value value = (Value)obj;
        char signature0 = value.type().signature().charAt(0);
        if (signature0 == 'J' || signature0 == 'I' || signature0 == 'S' || signature0 == 'B') {
            return NumericFormatter.formatNumber(Long.parseLong(value.toString()), options);
        }
        if (NumericFormatter.hasFraction(signature0)) {
            return NumericFormatter.formatFloatDouble(Double.parseDouble(value.toString()), options);
        }
        throw new UnsupportedOperationException(String.format("%s is not a numeric type.", value.type().name()));
    }

    @Override
    public Value valueOf(String value, Type type, Map<String, Object> options) {
        VirtualMachine vm = type.virtualMachine();
        char signature0 = type.signature().charAt(0);
        if (signature0 == 'J' || signature0 == 'I' || signature0 == 'S' || signature0 == 'B') {
            long number = NumericFormatter.parseNumber(value);
            if (signature0 == 'J') {
                return vm.mirrorOf(number);
            }
            if (signature0 == 'I') {
                return vm.mirrorOf((int)number);
            }
            if (signature0 == 'S') {
                return vm.mirrorOf((short)number);
            }
            if (signature0 == 'B') {
                return vm.mirrorOf((byte)number);
            }
        } else if (NumericFormatter.hasFraction(signature0)) {
            double doubleNumber = NumericFormatter.parseFloatDouble(value);
            if (signature0 == 'D') {
                return vm.mirrorOf(doubleNumber);
            }
            return vm.mirrorOf((float)doubleNumber);
        }
        throw new UnsupportedOperationException(String.format("%s is not a numeric type.", type.name()));
    }

    @Override
    public boolean acceptType(Type type, Map<String, Object> options) {
        if (type == null) {
            return false;
        }
        char signature0 = type.signature().charAt(0);
        return signature0 == 'J' || signature0 == 'I' || signature0 == 'S' || signature0 == 'B' || signature0 == 'F' || signature0 == 'D';
    }

    @Override
    public Map<String, Object> getDefaultOptions() {
        HashMap<String, Object> options = new HashMap<String, Object>();
        options.put(NUMERIC_FORMAT_OPTION, (Object)DEFAULT_NUMERIC_FORMAT);
        options.put(NUMERIC_PRECISION_OPTION, 0);
        return options;
    }

    static String formatNumber(long value, Map<String, Object> options) {
        NumericFormatEnum formatEnum = NumericFormatter.getNumericFormatOption(options);
        return String.format(enumFormatMap.get((Object)formatEnum), value);
    }

    private static long parseNumber(String number) {
        return Long.decode(number);
    }

    private static double parseFloatDouble(String number) {
        return Double.parseDouble(number);
    }

    private static String formatFloatDouble(double value, Map<String, Object> options) {
        int precision = NumericFormatter.getFractionPrecision(options);
        return String.format(precision > 0 ? String.format("%%.%df", precision) : "%f", value);
    }

    private static NumericFormatEnum getNumericFormatOption(Map<String, Object> options) {
        return options.containsKey(NUMERIC_FORMAT_OPTION) ? (NumericFormatEnum)((Object)options.get(NUMERIC_FORMAT_OPTION)) : DEFAULT_NUMERIC_FORMAT;
    }

    private static boolean hasFraction(char signature0) {
        return signature0 == 'F' || signature0 == 'D';
    }

    private static int getFractionPrecision(Map<String, Object> options) {
        return options.containsKey(NUMERIC_PRECISION_OPTION) ? (Integer)options.get(NUMERIC_PRECISION_OPTION) : 0;
    }

    static {
        enumFormatMap.put(NumericFormatEnum.DEC, "%d");
        enumFormatMap.put(NumericFormatEnum.HEX, "%#x");
        enumFormatMap.put(NumericFormatEnum.OCT, "%#o");
    }
}

