/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.java.debug.core.adapter.handler;

import com.microsoft.java.debug.core.AsyncJdwpUtils;
import com.microsoft.java.debug.core.adapter.IDebugAdapterContext;
import com.microsoft.java.debug.core.adapter.IDebugRequestHandler;
import com.microsoft.java.debug.core.protocol.Events;
import com.microsoft.java.debug.core.protocol.Messages;
import com.microsoft.java.debug.core.protocol.Requests;
import com.sun.jdi.ObjectCollectedException;
import com.sun.jdi.ThreadReference;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import java.util.concurrent.CompletableFuture;

public class RefreshFramesHandler
implements IDebugRequestHandler {
    @Override
    public List<Requests.Command> getTargetCommands() {
        return Arrays.asList(Requests.Command.REFRESHFRAMES);
    }

    @Override
    public CompletableFuture<Messages.Response> handle(Requests.Command command, Requests.Arguments arguments, Messages.Response response, IDebugAdapterContext context) {
        Requests.RefreshFramesArguments refreshArgs = (Requests.RefreshFramesArguments)arguments;
        String[] affectedRootPaths = refreshArgs == null ? null : refreshArgs.affectedRootPaths;
        List<Long> pausedThreads = this.getPausedThreads(context);
        for (long threadId : pausedThreads) {
            if (affectedRootPaths == null || affectedRootPaths.length == 0) {
                this.refreshFrames(threadId, context);
                continue;
            }
            Set<String> decompiledClasses = context.getThreadCache().getDecompiledClassesByThread(threadId);
            if (decompiledClasses == null || decompiledClasses.isEmpty() || !this.anyInAffectedRootPaths(decompiledClasses, affectedRootPaths)) continue;
            this.refreshFrames(threadId, context);
        }
        return CompletableFuture.completedFuture(response);
    }

    List<Long> getPausedThreads(IDebugAdapterContext context) {
        ArrayList<Long> results = new ArrayList<Long>();
        ArrayList futures = new ArrayList();
        List<ThreadReference> threads = context.getThreadCache().visibleThreads(context);
        for (ThreadReference thread : threads) {
            if (context.asyncJDWP()) {
                futures.add(AsyncJdwpUtils.supplyAsync(() -> {
                    try {
                        if (thread.isSuspended()) {
                            return thread.uniqueID();
                        }
                    }
                    catch (ObjectCollectedException objectCollectedException) {
                        // empty catch block
                    }
                    return -1L;
                }));
                continue;
            }
            try {
                if (!thread.isSuspended()) continue;
                results.add(thread.uniqueID());
            }
            catch (ObjectCollectedException objectCollectedException) {}
        }
        List<Long> awaitedResutls = AsyncJdwpUtils.await(futures);
        for (Long threadId : awaitedResutls) {
            if (threadId <= 0L) continue;
            results.add(threadId);
        }
        return results;
    }

    void refreshFrames(long threadId, IDebugAdapterContext context) {
        Events.StoppedEvent stoppedEvent = new Events.StoppedEvent(context.getThreadCache().getThreadStoppedReason(threadId), threadId);
        stoppedEvent.preserveFocusHint = true;
        context.getProtocolServer().sendEvent(stoppedEvent);
    }

    boolean anyInAffectedRootPaths(Collection<String> classes, String[] affectedRootPaths) {
        if (affectedRootPaths == null || affectedRootPaths.length == 0) {
            return true;
        }
        for (String classUri : classes) {
            if (!classUri.startsWith("jdt://contents/")) continue;
            String jarName = classUri.substring("jdt://contents/".length());
            int sep = jarName.indexOf("/");
            jarName = sep >= 0 ? jarName.substring(0, sep) : jarName;
            for (String affectedRootPath : affectedRootPaths) {
                if (!affectedRootPath.endsWith("/" + jarName) && !affectedRootPath.endsWith("\\" + jarName)) continue;
                return true;
            }
        }
        return false;
    }
}

