/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.java.debug.core.protocol;

import com.microsoft.java.debug.core.protocol.Types;

public class Events {

    public static class ProcessIdNotification
    extends DebugEvent {
        public long processId = -1L;
        public long shellProcessId = -1L;

        public ProcessIdNotification(long processId) {
            super("processid");
            this.processId = processId;
        }

        public ProcessIdNotification(long processId, long shellProcessId) {
            super("processid");
            this.processId = processId;
            this.shellProcessId = shellProcessId;
        }
    }

    public static class InvalidatedEvent
    extends DebugEvent {
        public InvalidatedAreas[] areas;
        public long threadId;
        public int frameId;

        public InvalidatedEvent() {
            super("invalidated");
        }

        public InvalidatedEvent(InvalidatedAreas area) {
            super("invalidated");
            this.areas = new InvalidatedAreas[]{area};
        }

        public InvalidatedEvent(InvalidatedAreas area, long threadId) {
            super("invalidated");
            this.areas = new InvalidatedAreas[]{area};
            this.threadId = threadId;
        }

        public InvalidatedEvent(InvalidatedAreas area, int frameId) {
            super("invalidated");
            this.areas = new InvalidatedAreas[]{area};
            this.frameId = frameId;
        }
    }

    public static enum InvalidatedAreas {
        ALL,
        STACKS,
        THREADS,
        VARIABLES;

    }

    public static class TelemetryEvent
    extends DebugEvent {
        public String name;
        public Object properties;

        public TelemetryEvent(String name, Object data) {
            super("telemetry");
            this.name = name;
            this.properties = data;
        }
    }

    public static class UserNotificationEvent
    extends DebugEvent {
        public NotificationType notificationType;
        public String message;

        public UserNotificationEvent(NotificationType notifyType, String message) {
            super("usernotification");
            this.notificationType = notifyType;
            this.message = message;
        }

        public static enum NotificationType {
            ERROR,
            WARNING,
            INFORMATION;

        }
    }

    public static class HotCodeReplaceEvent
    extends DebugEvent {
        public ChangeType changeType;
        public String message;

        public HotCodeReplaceEvent(ChangeType changeType, String message) {
            super("hotcodereplace");
            this.changeType = changeType;
            this.message = message;
        }

        public static enum ChangeType {
            ERROR,
            WARNING,
            STARTING,
            END,
            BUILD_COMPLETE;

        }
    }

    public static class BreakpointEvent
    extends DebugEvent {
        public String reason;
        public Types.Breakpoint breakpoint;

        public BreakpointEvent(String reason, Types.Breakpoint breakpoint) {
            super("breakpoint");
            this.reason = reason;
            this.breakpoint = breakpoint;
        }
    }

    public static class OutputEvent
    extends DebugEvent {
        public Category category;
        public String output;
        public int variablesReference;
        public Types.Source source;
        public int line;
        public int column;
        public Object data;

        public OutputEvent(Category category, String output) {
            super("output");
            this.category = category;
            this.output = output;
        }

        public OutputEvent(Category category, String output, Types.Source source, int line) {
            super("output");
            this.category = category;
            this.output = output;
            this.source = source;
            this.line = line;
        }

        public static OutputEvent createConsoleOutput(String output) {
            return new OutputEvent(Category.console, output);
        }

        public static OutputEvent createStdoutOutput(String output) {
            return new OutputEvent(Category.stdout, output);
        }

        public static OutputEvent createStdoutOutputWithSource(String output, Types.Source source, int line) {
            return new OutputEvent(Category.stdout, output, source, line);
        }

        public static OutputEvent createStderrOutput(String output) {
            return new OutputEvent(Category.stderr, output);
        }

        public static OutputEvent createStderrOutputWithSource(String output, Types.Source source, int line) {
            return new OutputEvent(Category.stderr, output, source, line);
        }

        public static OutputEvent createTelemetryOutput(String output) {
            return new OutputEvent(Category.telemetry, output);
        }

        public static enum Category {
            console,
            stdout,
            stderr,
            telemetry;

        }
    }

    public static class ThreadEvent
    extends DebugEvent {
        public String reason;
        public long threadId;

        public ThreadEvent(String reason, long threadId) {
            super("thread");
            this.reason = reason;
            this.threadId = threadId;
        }
    }

    public static class TerminatedEvent
    extends DebugEvent {
        public boolean restart;

        public TerminatedEvent() {
            super("terminated");
        }

        public TerminatedEvent(boolean restart) {
            this();
            this.restart = restart;
        }
    }

    public static class ExitedEvent
    extends DebugEvent {
        public int exitCode;

        public ExitedEvent(int code) {
            super("exited");
            this.exitCode = code;
        }
    }

    public static class ContinuedEvent
    extends DebugEvent {
        public long threadId;
        public boolean allThreadsContinued;

        public ContinuedEvent(long threadId) {
            super("continued");
            this.threadId = threadId;
        }

        public ContinuedEvent(long threadId, boolean allThreadsContinued) {
            this(threadId);
            this.allThreadsContinued = allThreadsContinued;
        }

        public ContinuedEvent(boolean allThreadsContinued) {
            super("continued");
            this.allThreadsContinued = allThreadsContinued;
        }
    }

    public static class StoppedEvent
    extends DebugEvent {
        public long threadId;
        public String reason;
        public String description;
        public String text;
        public boolean allThreadsStopped;
        public Boolean preserveFocusHint;

        public StoppedEvent(String reason, long threadId) {
            super("stopped");
            this.reason = reason;
            this.threadId = threadId;
            this.allThreadsStopped = false;
        }

        public StoppedEvent(String reason, long threadId, boolean allThreadsStopped) {
            this(reason, threadId);
            this.allThreadsStopped = allThreadsStopped;
        }

        public StoppedEvent(String reason, long threadId, boolean allThreadsStopped, String description, String text) {
            this(reason, threadId, allThreadsStopped);
            this.description = description;
            this.text = text;
        }
    }

    public static class InitializedEvent
    extends DebugEvent {
        public InitializedEvent() {
            super("initialized");
        }
    }

    public static class DebugEvent {
        public String type;

        public DebugEvent(String type) {
            this.type = type;
        }
    }
}

