/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.java.debug.core.adapter;

import io.reactivex.functions.Consumer;
import io.reactivex.subjects.PublishSubject;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;

public class ProcessConsole {
    private Process process;
    private String name;
    private Charset encoding;
    private PublishSubject<String> stdoutSubject = PublishSubject.create();
    private PublishSubject<String> stderrSubject = PublishSubject.create();
    private Thread stdoutThread = null;
    private Thread stderrThread = null;

    public ProcessConsole(Process process) {
        this(process, "Process", StandardCharsets.UTF_8);
    }

    public ProcessConsole(Process process, String name, Charset encoding) {
        this.process = process;
        this.name = name;
        this.encoding = encoding;
    }

    public void start() {
        this.stdoutThread = new Thread(this.name + " Stdout Handler"){

            @Override
            public void run() {
                ProcessConsole.this.monitor(ProcessConsole.this.process.getInputStream(), (PublishSubject<String>)ProcessConsole.this.stdoutSubject);
            }
        };
        this.stdoutThread.setDaemon(true);
        this.stdoutThread.start();
        this.stderrThread = new Thread(this.name + " Stderr Handler"){

            @Override
            public void run() {
                ProcessConsole.this.monitor(ProcessConsole.this.process.getErrorStream(), (PublishSubject<String>)ProcessConsole.this.stderrSubject);
            }
        };
        this.stderrThread.setDaemon(true);
        this.stderrThread.start();
    }

    public void stop() {
        if (this.stdoutThread != null) {
            this.stdoutThread.interrupt();
            this.stdoutThread = null;
        }
        if (this.stderrThread != null) {
            this.stderrThread.interrupt();
            this.stderrThread = null;
        }
    }

    public void onStdout(Consumer<String> callback) {
        this.stdoutSubject.subscribe(callback);
    }

    public void onStderr(Consumer<String> callback) {
        this.stderrSubject.subscribe(callback);
    }

    private void monitor(InputStream input, PublishSubject<String> subject) {
        BufferedReader reader = new BufferedReader(new InputStreamReader(input, this.encoding));
        int BUFFERSIZE = 4096;
        char[] buffer = new char[4096];
        try {
            while (true) {
                if (Thread.interrupted()) {
                    subject.onComplete();
                    return;
                }
                int read = reader.read(buffer, 0, 4096);
                if (read == -1) {
                    subject.onComplete();
                    return;
                }
                subject.onNext((Object)new String(buffer, 0, read));
            }
        }
        catch (IOException e) {
            subject.onError((Throwable)e);
            return;
        }
    }
}

