/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.java.debug.core.adapter.handler;

import com.microsoft.java.debug.core.DebugSettings;
import com.microsoft.java.debug.core.adapter.AdapterUtils;
import com.microsoft.java.debug.core.adapter.ErrorCode;
import com.microsoft.java.debug.core.adapter.IDebugAdapterContext;
import com.microsoft.java.debug.core.adapter.IDebugRequestHandler;
import com.microsoft.java.debug.core.adapter.IEvaluationProvider;
import com.microsoft.java.debug.core.adapter.variables.IVariableFormatter;
import com.microsoft.java.debug.core.adapter.variables.StackFrameReference;
import com.microsoft.java.debug.core.adapter.variables.VariableProxy;
import com.microsoft.java.debug.core.adapter.variables.VariableUtils;
import com.microsoft.java.debug.core.protocol.Messages;
import com.microsoft.java.debug.core.protocol.Requests;
import com.microsoft.java.debug.core.protocol.Responses;
import com.sun.jdi.ArrayReference;
import com.sun.jdi.ObjectReference;
import com.sun.jdi.Value;
import com.sun.jdi.VoidValue;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionException;
import java.util.concurrent.ExecutionException;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.commons.lang3.StringUtils;

public class EvaluateRequestHandler
implements IDebugRequestHandler {
    private static final Logger logger = Logger.getLogger("java-debug");

    @Override
    public List<Requests.Command> getTargetCommands() {
        return Arrays.asList(Requests.Command.EVALUATE);
    }

    @Override
    public CompletableFuture<Messages.Response> handle(Requests.Command command, Requests.Arguments arguments, Messages.Response response, IDebugAdapterContext context) {
        Requests.EvaluateArguments evalArguments = (Requests.EvaluateArguments)arguments;
        boolean showStaticVariables = DebugSettings.getCurrent().showStaticVariables;
        Map<String, Object> options = context.getVariableFormatter().getDefaultOptions();
        VariableUtils.applyFormatterOptions(options, evalArguments.format != null && evalArguments.format.hex);
        String expression = evalArguments.expression;
        if (StringUtils.isBlank((CharSequence)expression)) {
            return AdapterUtils.createAsyncErrorResponse(response, ErrorCode.EVALUATE_FAILURE, "Failed to evaluate. Reason: Empty expression cannot be evaluated.");
        }
        StackFrameReference stackFrameReference = (StackFrameReference)context.getRecyclableIdPool().getObjectById(evalArguments.frameId);
        if (stackFrameReference == null) {
            return AdapterUtils.createAsyncErrorResponse(response, ErrorCode.EVALUATE_FAILURE, "Failed to evaluate. Reason: Cannot evaluate because the thread is resumed.");
        }
        return CompletableFuture.supplyAsync(() -> {
            try {
                IEvaluationProvider engine = context.getProvider(IEvaluationProvider.class);
                Value value = engine.evaluate(expression, stackFrameReference.getThread(), stackFrameReference.getDepth()).get();
                IVariableFormatter variableFormatter = context.getVariableFormatter();
                if (value instanceof VoidValue) {
                    response.body = new Responses.EvaluateResponseBody(value.toString(), 0, "<void>", 0);
                    return response;
                }
                long threadId = stackFrameReference.getThread().uniqueID();
                if (value instanceof ObjectReference) {
                    VariableProxy varProxy = new VariableProxy(stackFrameReference.getThread(), "eval", value);
                    int referenceId = VariableUtils.hasChildren(value, showStaticVariables) ? context.getRecyclableIdPool().addObject(threadId, varProxy) : 0;
                    int indexedVariableId = value instanceof ArrayReference ? ((ArrayReference)value).length() : 0;
                    response.body = new Responses.EvaluateResponseBody(variableFormatter.valueToString(value, options), referenceId, variableFormatter.typeToString(value == null ? null : value.type(), options), indexedVariableId);
                    return response;
                }
                response.body = new Responses.EvaluateResponseBody(variableFormatter.valueToString(value, options), 0, variableFormatter.typeToString(value == null ? null : value.type(), options), 0);
                return response;
            }
            catch (InterruptedException | ExecutionException e) {
                Throwable cause = e;
                if (e instanceof ExecutionException && e.getCause() != null) {
                    cause = e.getCause();
                }
                logger.log(Level.WARNING, String.format("Cannot evalution expression because of %s.", cause.toString()), cause);
                throw new CompletionException(cause);
            }
        });
    }
}

