/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.java.debug.plugin.internal;

import com.microsoft.java.debug.core.DebugException;
import com.microsoft.java.debug.core.adapter.ICompletionsProvider;
import com.microsoft.java.debug.core.adapter.IDebugAdapterContext;
import com.microsoft.java.debug.core.adapter.ISourceLookUpProvider;
import com.microsoft.java.debug.core.protocol.Types;
import com.microsoft.java.debug.plugin.internal.JdtSourceLookUpProvider;
import com.microsoft.java.debug.plugin.internal.JdtUtils;
import com.sun.jdi.StackFrame;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jdt.core.CompletionRequestor;
import org.eclipse.jdt.core.IBuffer;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.ls.core.internal.contentassist.CompletionProposalRequestor;
import org.eclipse.jdt.ls.core.internal.handlers.JsonRpcHelpers;
import org.eclipse.lsp4j.CompletionItem;

public class CompletionsProvider
implements ICompletionsProvider {
    private static final Logger logger = Logger.getLogger("java-debug");
    private IDebugAdapterContext context;

    public void initialize(IDebugAdapterContext context, Map<String, Object> options) {
        this.context = context;
    }

    public List<Types.CompletionItem> codeComplete(StackFrame frame, String snippet, int line, int column) {
        ArrayList<Types.CompletionItem> res = new ArrayList<Types.CompletionItem>();
        try {
            IType type = this.resolveType(frame);
            if (type != null) {
                int offset = JsonRpcHelpers.toOffset((IBuffer)type.getCompilationUnit().getBuffer(), (int)frame.location().lineNumber(), (int)0);
                CompletionProposalRequestor collector = new CompletionProposalRequestor(type.getCompilationUnit(), offset);
                collector.setAllowsRequiredProposals(2, 9, true);
                collector.setAllowsRequiredProposals(2, 23, true);
                collector.setAllowsRequiredProposals(2, 21, true);
                collector.setAllowsRequiredProposals(6, 9, true);
                collector.setAllowsRequiredProposals(6, 23, true);
                collector.setAllowsRequiredProposals(6, 22, true);
                collector.setAllowsRequiredProposals(26, 9, true);
                collector.setAllowsRequiredProposals(27, 9, true);
                collector.setAllowsRequiredProposals(1, 9, true);
                collector.setAllowsRequiredProposals(9, 9, true);
                type.codeComplete(snippet.toCharArray(), offset, snippet.length(), null, null, null, frame.location().method().isStatic(), (CompletionRequestor)collector);
                List items = collector.getCompletionItems();
                if (items != null) {
                    for (CompletionItem lspItem : items) {
                        res.add(this.convertFromLsp(lspItem));
                    }
                }
            }
        }
        catch (DebugException | CoreException e) {
            logger.log(Level.SEVERE, String.format("Failed to code complete because of %s", e.toString()), e);
        }
        return res;
    }

    private IType resolveType(StackFrame frame) throws CoreException, DebugException {
        IJavaProject project;
        ISourceLookUpProvider sourceProvider = (ISourceLookUpProvider)this.context.getProvider(ISourceLookUpProvider.class);
        if (sourceProvider instanceof JdtSourceLookUpProvider && (project = JdtUtils.findProject(frame, ((JdtSourceLookUpProvider)sourceProvider).getSourceContainers())) != null) {
            return project.findType(JdtUtils.getDeclaringTypeName(frame));
        }
        return null;
    }

    private Types.CompletionItem convertFromLsp(CompletionItem lspItem) {
        Types.CompletionItem item = new Types.CompletionItem(lspItem.getLabel(), lspItem.getInsertText());
        if (lspItem.getKind() != null) {
            item.type = lspItem.getKind().name().toLowerCase();
        }
        return item;
    }
}

