/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.java.debug.plugin.internal;

import com.microsoft.java.debug.plugin.internal.JdtLogHandler;
import com.microsoft.java.debug.plugin.internal.UsageDataLogHandler;
import java.util.logging.Level;
import java.util.logging.Logger;

public final class LogUtils {
    private static final Logger logger = Logger.getLogger("java-debug");
    private static final Logger usageDataLogger = Logger.getLogger("java-debug-usage-data");

    public static void initialize(Level level) {
        logger.addHandler(new JdtLogHandler());
        logger.addHandler(new UsageDataLogHandler(Level.SEVERE));
        usageDataLogger.addHandler(new UsageDataLogHandler(Level.ALL));
        logger.setLevel(level);
    }

    public static String configLogLevel(Object logLevel) {
        try {
            logger.setLevel(Level.parse((String)logLevel));
            logger.info(String.format("Set log level to : %s", logLevel));
        }
        catch (IllegalArgumentException illegalArgumentException) {
            logger.severe(String.format("Invalid log level: %s", logLevel));
        }
        catch (ClassCastException classCastException) {
            logger.severe("logLevel should be a string.");
        }
        return logger.getLevel().toString();
    }
}

