/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.java.debug.plugin.internal;

import com.microsoft.java.debug.plugin.internal.JdtUtils;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.stream.Collectors;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.search.IJavaSearchScope;
import org.eclipse.jdt.core.search.SearchEngine;
import org.eclipse.jdt.core.search.SearchMatch;
import org.eclipse.jdt.core.search.SearchParticipant;
import org.eclipse.jdt.core.search.SearchPattern;
import org.eclipse.jdt.core.search.SearchRequestor;
import org.eclipse.jdt.launching.JavaRuntime;

public class ResolveClasspathsHandler {
    private static final Logger logger = Logger.getLogger("java-debug");

    public String[][] resolveClasspaths(List<Object> arguments) throws Exception {
        try {
            return ResolveClasspathsHandler.computeClassPath((String)arguments.get(0), (String)arguments.get(1));
        }
        catch (CoreException e) {
            logger.log(Level.SEVERE, "Failed to resolve classpath: " + e.getMessage(), e);
            throw new Exception("Failed to resolve classpath: " + e.getMessage(), e);
        }
    }

    private static IJavaProject getJavaProjectFromName(String projectName) throws CoreException {
        IJavaProject javaProject = JdtUtils.getJavaProject(projectName);
        if (javaProject == null) {
            throw new CoreException((IStatus)new Status(4, "com.microsoft.java.debug.plugin", String.format("The project '%s' is not a valid java project.", projectName)));
        }
        return javaProject;
    }

    private static List<IJavaProject> getJavaProjectFromType(String fullyQualifiedTypeName) throws CoreException {
        String[] splitItems = fullyQualifiedTypeName.split("/");
        if (splitItems.length == 2) {
            fullyQualifiedTypeName = splitItems[1];
        }
        final String moduleName = splitItems.length == 2 ? splitItems[0] : null;
        SearchPattern pattern = SearchPattern.createPattern((String)fullyQualifiedTypeName, (int)0, (int)0, (int)0);
        IJavaSearchScope scope = SearchEngine.createWorkspaceScope();
        final ArrayList projects = new ArrayList();
        SearchRequestor requestor = new SearchRequestor(){

            public void acceptSearchMatch(SearchMatch match) {
                Object element = match.getElement();
                if (element instanceof IJavaElement) {
                    IJavaProject project = ((IJavaElement)element).getJavaProject();
                    if (moduleName == null || moduleName.equals(JdtUtils.getModuleName(project))) {
                        projects.add(project);
                    }
                }
            }
        };
        SearchEngine searchEngine = new SearchEngine();
        searchEngine.search(pattern, new SearchParticipant[]{SearchEngine.getDefaultSearchParticipant()}, scope, requestor, null);
        return projects.stream().distinct().collect(Collectors.toList());
    }

    private static String[][] computeClassPath(String mainClass, String projectName) throws CoreException {
        IJavaProject project = null;
        if (projectName != null) {
            project = ResolveClasspathsHandler.getJavaProjectFromName(projectName);
        } else {
            List<IJavaProject> projects = ResolveClasspathsHandler.getJavaProjectFromType(mainClass);
            if (projects.size() == 0) {
                throw new CoreException((IStatus)new Status(4, "com.microsoft.java.debug.plugin", String.format("Main class '%s' doesn't exist in the workspace.", mainClass)));
            }
            if (projects.size() > 1) {
                throw new CoreException((IStatus)new Status(4, "com.microsoft.java.debug.plugin", String.format("Main class '%s' isn't unique in the workspace, please pass in specified projectname.", mainClass)));
            }
            project = projects.get(0);
        }
        return ResolveClasspathsHandler.computeClassPath(project);
    }

    private static String[][] computeClassPath(IJavaProject javaProject) throws CoreException {
        if (javaProject == null) {
            throw new IllegalArgumentException("javaProject is null");
        }
        String[][] result = new String[2][];
        if (JavaRuntime.isModularProject((IJavaProject)javaProject)) {
            result[0] = JavaRuntime.computeDefaultRuntimeClassPath((IJavaProject)javaProject);
            result[1] = new String[0];
        } else {
            result[0] = new String[0];
            result[1] = JavaRuntime.computeDefaultRuntimeClassPath((IJavaProject)javaProject);
        }
        return result;
    }
}

