/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.java.debug.plugin.internal;

import com.microsoft.java.debug.plugin.internal.JdtUtils;
import com.microsoft.java.debug.plugin.internal.ResolveClasspathsHandler;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Objects;
import java.util.function.Function;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IMethod;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.core.search.IJavaSearchScope;
import org.eclipse.jdt.core.search.SearchEngine;
import org.eclipse.jdt.core.search.SearchMatch;
import org.eclipse.jdt.core.search.SearchParticipant;
import org.eclipse.jdt.core.search.SearchPattern;
import org.eclipse.jdt.core.search.SearchRequestor;
import org.eclipse.jdt.ls.core.internal.ResourceUtils;

public class ResolveMainClassHandler {
    private static final Logger logger = Logger.getLogger("java-debug");
    private static final String CLASSNAME_REGX = "([$\\w]+\\.)*[$\\w]+";

    public Object resolveMainClass(List<Object> arguments) {
        return this.resolveMainClassCore(arguments);
    }

    public Object validateLaunchConfig(List<Object> arguments) throws Exception {
        try {
            return this.validateLaunchConfigCore(arguments);
        }
        catch (CoreException ex) {
            logger.log(Level.SEVERE, "Failed to validate launch config: " + ex.getMessage(), ex);
            throw new Exception("Failed to validate launch config: " + ex.getMessage(), ex);
        }
    }

    private List<ResolutionItem> resolveMainClassCore(List<Object> arguments) {
        IPath rootPath = null;
        if (arguments != null && arguments.size() > 0 && arguments.get(0) != null) {
            rootPath = ResourceUtils.filePathFromURI((String)((String)arguments.get(0)));
        }
        final ArrayList<IPath> targetProjectPath = new ArrayList<IPath>();
        if (rootPath != null) {
            targetProjectPath.add(rootPath);
        }
        IJavaSearchScope searchScope = SearchEngine.createWorkspaceScope();
        SearchPattern pattern = SearchPattern.createPattern((String)"main(String[]) void", (int)1, (int)0, (int)8);
        final ArrayList res = new ArrayList();
        SearchRequestor requestor = new SearchRequestor(){

            public void acceptSearchMatch(SearchMatch match) {
                block7: {
                    Object element = match.getElement();
                    if (element instanceof IMethod) {
                        IMethod method = (IMethod)element;
                        try {
                            String projectName;
                            String moduleName;
                            IProject project;
                            IResource resource;
                            if (!method.isMainMethod() || (resource = method.getResource()) == null || (project = resource.getProject()) == null) break block7;
                            String mainClass = method.getDeclaringType().getFullyQualifiedName();
                            IJavaProject javaProject = JdtUtils.getJavaProject(project);
                            if (javaProject != null && (moduleName = JdtUtils.getModuleName(javaProject)) != null) {
                                mainClass = String.valueOf(moduleName) + "/" + mainClass;
                            }
                            String string = projectName = "jdt.ls-java-project".equals(project.getName()) ? null : project.getName();
                            if (projectName != null && !targetProjectPath.isEmpty() && !ResourceUtils.isContainedIn((IPath)project.getLocation(), (Collection)targetProjectPath)) break block7;
                            String filePath = null;
                            if (match.getResource() instanceof IFile) {
                                try {
                                    filePath = match.getResource().getLocation().toOSString();
                                }
                                catch (Exception exception) {}
                            }
                            res.add(new ResolutionItem(mainClass, projectName, filePath));
                        }
                        catch (JavaModelException javaModelException) {}
                    }
                }
            }
        };
        SearchEngine searchEngine = new SearchEngine();
        try {
            searchEngine.search(pattern, new SearchParticipant[]{SearchEngine.getDefaultSearchParticipant()}, searchScope, requestor, null);
        }
        catch (Exception e) {
            logger.log(Level.SEVERE, String.format("Searching the main class failure: %s", e.toString()), e);
        }
        List<ResolutionItem> resolutions = res.stream().distinct().collect(Collectors.toList());
        Collections.sort(resolutions);
        return resolutions;
    }

    private ValidationResponse validateLaunchConfigCore(List<Object> arguments) throws CoreException {
        ValidationResponse response = new ValidationResponse();
        String mainClass = null;
        String projectName = null;
        boolean containsExternalClasspaths = false;
        if (arguments != null) {
            if (arguments.size() > 1) {
                mainClass = (String)arguments.get(1);
            }
            if (arguments.size() > 2) {
                projectName = (String)arguments.get(2);
            }
            if (arguments.size() > 3) {
                containsExternalClasspaths = (Boolean)arguments.get(3);
            }
        }
        response.mainClass = this.validateMainClass(mainClass, projectName, containsExternalClasspaths);
        response.projectName = this.validateProjectName(mainClass, projectName);
        if (!response.mainClass.isValid || !response.projectName.isValid) {
            response.proposals = this.computeProposals(arguments, mainClass, projectName);
        }
        return response;
    }

    private ValidationResult validateMainClass(String mainClass, String projectName, boolean containsExternalClasspaths) throws CoreException {
        if (StringUtils.isEmpty((CharSequence)mainClass)) {
            return new ValidationResult(true);
        }
        if (!mainClass.matches(CLASSNAME_REGX)) {
            return new ValidationResult(false, String.format("ConfigError: '%s' is not a valid class name.", mainClass));
        }
        if (!containsExternalClasspaths && StringUtils.isEmpty((CharSequence)projectName)) {
            List<IJavaProject> javaProjects = this.searchClassInProjectClasspaths(mainClass);
            if (javaProjects.size() == 0) {
                return new ValidationResult(false, String.format("ConfigError: Main class '%s' doesn't exist in the workspace.", mainClass));
            }
            if (javaProjects.size() > 1) {
                return new ValidationResult(false, String.format("ConfigError: Main class '%s' isn't unique in the workspace.", mainClass));
            }
        }
        return new ValidationResult(true);
    }

    private List<IJavaProject> searchClassInProjectClasspaths(String fullyQualifiedClassName) throws CoreException {
        return ResolveClasspathsHandler.getJavaProjectFromType(fullyQualifiedClassName);
    }

    private ValidationResult validateProjectName(String mainClass, String projectName) {
        if (StringUtils.isEmpty((CharSequence)projectName)) {
            return new ValidationResult(true);
        }
        if (JdtUtils.getJavaProject(projectName) == null) {
            return new ValidationResult(false, String.format("ConfigError: The project '%s' is not a valid java project.", projectName));
        }
        return new ValidationResult(true);
    }

    private List<ResolutionItem> computeProposals(List<Object> arguments, String mainClass, String projectName) {
        List<ResolutionItem> proposals = this.resolveMainClassCore(arguments);
        Collections.sort(proposals, new ProposalItemComparator(item -> {
            if (Objects.equals(((ResolutionItem)item).mainClass, mainClass)) {
                return 1;
            }
            if (Objects.equals(((ResolutionItem)item).projectName, projectName)) {
                return 2;
            }
            return 999;
        }));
        return proposals;
    }

    class ProposalItemComparator
    implements Comparator<ResolutionItem> {
        Function<ResolutionItem, Integer> getRank;

        ProposalItemComparator(Function<ResolutionItem, Integer> getRank) {
            this.getRank = getRank;
        }

        @Override
        public int compare(ResolutionItem o1, ResolutionItem o2) {
            return this.getRank.apply(o1) - this.getRank.apply(o2);
        }
    }

    private class ResolutionItem
    implements Comparable<ResolutionItem> {
        private String mainClass;
        private String projectName;
        private String filePath;

        public ResolutionItem(String mainClass, String projectName, String filePath) {
            this.mainClass = mainClass;
            this.projectName = projectName;
            this.filePath = filePath;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o instanceof ResolutionItem) {
                ResolutionItem item = (ResolutionItem)o;
                return Objects.equals(this.mainClass, item.mainClass) && Objects.equals(this.projectName, item.projectName) && Objects.equals(this.filePath, item.filePath);
            }
            return false;
        }

        public int hashCode() {
            return Objects.hash(this.mainClass, this.projectName, this.filePath);
        }

        @Override
        public int compareTo(ResolutionItem o) {
            if (this.isDefaultProject(this.projectName) && !this.isDefaultProject(o.projectName)) {
                return 1;
            }
            if (!this.isDefaultProject(this.projectName) && this.isDefaultProject(o.projectName)) {
                return -1;
            }
            return (String.valueOf(this.projectName) + "|" + this.mainClass).compareTo(String.valueOf(o.projectName) + "|" + o.mainClass);
        }

        private boolean isDefaultProject(String projectName) {
            return StringUtils.isEmpty((CharSequence)projectName);
        }
    }

    class ValidationResponse {
        ValidationResult mainClass;
        ValidationResult projectName;
        List<ResolutionItem> proposals;

        ValidationResponse() {
        }
    }

    class ValidationResult {
        boolean isValid;
        String message;

        ValidationResult(boolean isValid) {
            this.isValid = isValid;
        }

        ValidationResult(boolean isValid, String message) {
            this.isValid = isValid;
            this.message = message;
        }
    }
}

