/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.java.debug.plugin.internal;

import com.microsoft.java.debug.plugin.internal.JdtUtils;
import java.io.IOException;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Date;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.stream.Collectors;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.apache.commons.lang3.StringUtils;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.internal.core.LaunchConfiguration;
import org.eclipse.debug.internal.core.LaunchConfigurationInfo;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IPackageFragmentRoot;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.search.IJavaSearchScope;
import org.eclipse.jdt.core.search.SearchEngine;
import org.eclipse.jdt.core.search.SearchMatch;
import org.eclipse.jdt.core.search.SearchParticipant;
import org.eclipse.jdt.core.search.SearchPattern;
import org.eclipse.jdt.core.search.SearchRequestor;
import org.eclipse.jdt.launching.IJavaLaunchConfigurationConstants;
import org.eclipse.jdt.launching.IRuntimeClasspathEntry;
import org.eclipse.jdt.launching.JavaRuntime;
import org.eclipse.jdt.ls.core.internal.ProjectUtils;
import org.w3c.dom.Element;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

public class ResolveClasspathsHandler {
    private static final Logger logger = Logger.getLogger("java-debug");

    public String[][] resolveClasspaths(List<Object> arguments) throws Exception {
        try {
            return ResolveClasspathsHandler.computeClassPath((String)arguments.get(0), (String)arguments.get(1));
        }
        catch (CoreException e) {
            logger.log(Level.SEVERE, "Failed to resolve classpath: " + e.getMessage(), e);
            throw new Exception("Failed to resolve classpath: " + e.getMessage(), e);
        }
    }

    private static IJavaProject getJavaProjectFromName(String projectName) throws CoreException {
        IJavaProject javaProject = JdtUtils.getJavaProject(projectName);
        if (javaProject == null) {
            throw new CoreException((IStatus)new Status(4, "com.microsoft.java.debug.plugin", String.format("The project '%s' is not a valid java project.", projectName)));
        }
        return javaProject;
    }

    public static List<IJavaProject> getJavaProjectFromType(String fullyQualifiedTypeName) throws CoreException {
        List<IJavaProject> javaProjects = JdtUtils.listJavaProjects(ResourcesPlugin.getWorkspace().getRoot());
        if (javaProjects.size() <= 1) {
            return javaProjects;
        }
        String[] splitItems = fullyQualifiedTypeName.split("/");
        if (splitItems.length == 2) {
            fullyQualifiedTypeName = splitItems[1];
        }
        final String moduleName = splitItems.length == 2 ? splitItems[0] : null;
        final String className = fullyQualifiedTypeName;
        SearchPattern pattern = SearchPattern.createPattern((String)fullyQualifiedTypeName, (int)0, (int)0, (int)0);
        IJavaSearchScope scope = SearchEngine.createWorkspaceScope();
        final ArrayList projects = new ArrayList();
        SearchRequestor requestor = new SearchRequestor(){

            public void acceptSearchMatch(SearchMatch match) {
                Object element = match.getElement();
                if (element instanceof IType) {
                    IType type = (IType)element;
                    IJavaProject project = type.getJavaProject();
                    if (className.equals(type.getFullyQualifiedName()) && (moduleName == null || moduleName.equals(JdtUtils.getModuleName(project)))) {
                        projects.add(project);
                    }
                }
            }
        };
        SearchEngine searchEngine = new SearchEngine();
        searchEngine.search(pattern, new SearchParticipant[]{SearchEngine.getDefaultSearchParticipant()}, scope, requestor, null);
        return projects.stream().distinct().collect(Collectors.toList());
    }

    private static String[][] computeClassPath(String mainClass, String projectName) throws CoreException {
        IJavaProject project = null;
        if (StringUtils.isNotBlank((CharSequence)projectName)) {
            project = ResolveClasspathsHandler.getJavaProjectFromName(projectName);
        } else {
            List<IJavaProject> projects = ResolveClasspathsHandler.getJavaProjectFromType(mainClass);
            if (projects.size() == 0) {
                throw new CoreException((IStatus)new Status(4, "com.microsoft.java.debug.plugin", String.format("Main class '%s' doesn't exist in the workspace.", mainClass)));
            }
            if (projects.size() > 1) {
                throw new CoreException((IStatus)new Status(4, "com.microsoft.java.debug.plugin", String.format("Main class '%s' isn't unique in the workspace, please pass in specified projectname.", mainClass)));
            }
            project = projects.get(0);
        }
        IJavaElement testElement = ResolveClasspathsHandler.findMainClassInTestFolders(project, mainClass);
        List<IResource> mappedResources = testElement != null && testElement.getResource() != null ? Arrays.asList(testElement.getResource()) : Collections.EMPTY_LIST;
        return ResolveClasspathsHandler.computeClassPath(project, testElement == null, mappedResources);
    }

    private static String[][] computeClassPath(IJavaProject javaProject, boolean excludeTestCode, List<IResource> mappedResources) throws CoreException {
        if (javaProject == null) {
            throw new IllegalArgumentException("javaProject is null");
        }
        JavaApplicationLaunchConfiguration launchConfig = new JavaApplicationLaunchConfiguration(javaProject.getProject(), excludeTestCode, mappedResources);
        IRuntimeClasspathEntry[] unresolved = JavaRuntime.computeUnresolvedRuntimeClasspath((ILaunchConfiguration)launchConfig);
        IRuntimeClasspathEntry[] resolved = JavaRuntime.resolveRuntimeClasspath((IRuntimeClasspathEntry[])unresolved, (ILaunchConfiguration)launchConfig);
        LinkedHashSet<String> classpaths = new LinkedHashSet<String>();
        LinkedHashSet<String> modulepaths = new LinkedHashSet<String>();
        IRuntimeClasspathEntry[] iRuntimeClasspathEntryArray = resolved;
        int n = resolved.length;
        int n2 = 0;
        while (n2 < n) {
            IRuntimeClasspathEntry entry = iRuntimeClasspathEntryArray[n2];
            String location = entry.getLocation();
            if (location != null) {
                if (entry.getClasspathProperty() == 3 || entry.getClasspathProperty() == 5) {
                    classpaths.add(location);
                } else if (entry.getClasspathProperty() == 4) {
                    modulepaths.add(location);
                }
            }
            ++n2;
        }
        return new String[][]{modulepaths.toArray(new String[modulepaths.size()]), classpaths.toArray(new String[classpaths.size()])};
    }

    private static IJavaElement findMainClassInTestFolders(IJavaProject project, String mainClass) {
        if (project == null || StringUtils.isBlank((CharSequence)mainClass)) {
            return null;
        }
        int constraints = 1;
        IPackageFragmentRoot[] testFolders = JdtUtils.getTestPackageFragmentRoots(project);
        if (testFolders.length > 0) {
            try {
                final ArrayList mainClassesInTestFolder = new ArrayList();
                SearchPattern pattern = SearchPattern.createPattern((String)mainClass, (int)5, (int)0, (int)8);
                SearchEngine searchEngine = new SearchEngine();
                IJavaSearchScope scope = SearchEngine.createJavaSearchScope((IJavaElement[])testFolders, (int)constraints);
                SearchRequestor requestor = new SearchRequestor(){

                    public void acceptSearchMatch(SearchMatch match) {
                        Object element = match.getElement();
                        if (element instanceof IJavaElement) {
                            mainClassesInTestFolder.add((IJavaElement)element);
                        }
                    }
                };
                searchEngine.search(pattern, new SearchParticipant[]{SearchEngine.getDefaultSearchParticipant()}, scope, requestor, null);
                if (!mainClassesInTestFolder.isEmpty()) {
                    return (IJavaElement)mainClassesInTestFolder.get(0);
                }
            }
            catch (Exception e) {
                logger.log(Level.SEVERE, String.format("Searching the main class failure: %s", e.toString()), e);
            }
        }
        return null;
    }

    private static class JavaApplicationLaunchConfiguration
    extends LaunchConfiguration {
        public static final String JAVA_APPLICATION_LAUNCH = "<?xml version=\"1.0\" encoding=\"UTF-8\" standalone=\"no\"?>\n<launchConfiguration type=\"org.eclipse.jdt.launching.localJavaApplication\">\n<listAttribute key=\"org.eclipse.debug.core.MAPPED_RESOURCE_PATHS\">\n</listAttribute>\n<listAttribute key=\"org.eclipse.debug.core.MAPPED_RESOURCE_TYPES\">\n</listAttribute>\n</launchConfiguration>";
        private IProject project;
        private boolean excludeTestCode;
        private List<IResource> mappedResources;
        private String classpathProvider;
        private String sourcepathProvider;
        private LaunchConfigurationInfo launchInfo;

        protected JavaApplicationLaunchConfiguration(IProject project, boolean excludeTestCode, List<IResource> mappedResources) throws CoreException {
            super(String.valueOf(new Date().getTime()), null, false);
            this.project = project;
            this.excludeTestCode = excludeTestCode;
            this.mappedResources = mappedResources;
            if (ProjectUtils.isMavenProject((IProject)project)) {
                this.classpathProvider = "org.eclipse.m2e.launchconfig.classpathProvider";
                this.sourcepathProvider = "org.eclipse.m2e.launchconfig.sourcepathProvider";
            } else if (ProjectUtils.isGradleProject((IProject)project)) {
                this.classpathProvider = "org.eclipse.buildship.core.classpathprovider";
            }
            this.launchInfo = new JavaLaunchConfigurationInfo(JAVA_APPLICATION_LAUNCH);
        }

        public boolean getAttribute(String attributeName, boolean defaultValue) throws CoreException {
            if (IJavaLaunchConfigurationConstants.ATTR_EXCLUDE_TEST_CODE.equalsIgnoreCase(attributeName)) {
                return this.excludeTestCode;
            }
            return super.getAttribute(attributeName, defaultValue);
        }

        public String getAttribute(String attributeName, String defaultValue) throws CoreException {
            if (IJavaLaunchConfigurationConstants.ATTR_PROJECT_NAME.equalsIgnoreCase(attributeName)) {
                return this.project.getName();
            }
            if (IJavaLaunchConfigurationConstants.ATTR_CLASSPATH_PROVIDER.equalsIgnoreCase(attributeName)) {
                return this.classpathProvider;
            }
            if (IJavaLaunchConfigurationConstants.ATTR_SOURCE_PATH_PROVIDER.equalsIgnoreCase(attributeName)) {
                return this.sourcepathProvider;
            }
            return super.getAttribute(attributeName, defaultValue);
        }

        public IResource[] getMappedResources() throws CoreException {
            return this.mappedResources.toArray(new IResource[0]);
        }

        protected LaunchConfigurationInfo getInfo() throws CoreException {
            return this.launchInfo;
        }
    }

    private static class JavaLaunchConfigurationInfo
    extends LaunchConfigurationInfo {
        public JavaLaunchConfigurationInfo(String launchXml) {
            try {
                DocumentBuilder parser = DocumentBuilderFactory.newInstance().newDocumentBuilder();
                parser.setErrorHandler(new DefaultHandler());
                StringReader reader = new StringReader(launchXml);
                InputSource source = new InputSource(reader);
                Element root = parser.parse(source).getDocumentElement();
                this.initializeFromXML(root);
            }
            catch (IOException | ParserConfigurationException | CoreException | SAXException throwable) {}
        }
    }
}

