/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.java.debug.plugin.internal;

import com.microsoft.java.debug.core.DebugException;
import com.microsoft.java.debug.plugin.internal.JdtUtils;
import java.net.URI;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.ls.core.internal.IDelegateCommandHandler;
import org.eclipse.jdt.ls.core.internal.JDTUtils;
import org.eclipse.jdt.ls.core.internal.ProjectUtils;
import org.eclipse.jdt.ls.core.internal.ResourceUtils;

public class JavaDebugDelegateCommandHandler
implements IDelegateCommandHandler {
    public static final String FETCH_USER_DATA = "vscode.java.fetchUsageData";
    public static final String DEBUG_STARTSESSION = "vscode.java.startDebugSession";
    public static final String RESOLVE_CLASSPATH = "vscode.java.resolveClasspath";
    public static final String RESOLVE_MAINCLASS = "vscode.java.resolveMainClass";
    public static final String BUILD_WORKSPACE = "vscode.java.buildWorkspace";
    public static final String UPDATE_DEBUG_SETTINGS = "vscode.java.updateDebugSettings";
    public static final String VALIDATE_LAUNCHCONFIG = "vscode.java.validateLaunchConfig";
    public static final String RESOLVE_MAINMETHOD = "vscode.java.resolveMainMethod";
    public static final String INFER_LAUNCH_COMMAND_LENGTH = "vscode.java.inferLaunchCommandLength";
    public static final String CHECK_PROJECT_SETTINGS = "vscode.java.checkProjectSettings";
    public static final String RESOLVE_ELEMENT_AT_SELECTION = "vscode.java.resolveElementAtSelection";
    public static final String RESOLVE_BUILD_FILES = "vscode.java.resolveBuildFiles";
    public static final String IS_ON_CLASSPATH = "vscode.java.isOnClasspath";
    public static final String RESOLVE_JAVA_EXECUTABLE = "vscode.java.resolveJavaExecutable";
    public static final String FETCH_PLATFORM_SETTINGS = "vscode.java.fetchPlatformSettings";

    /*
     * Exception decompiling
     */
    public Object executeCommand(String commandId, List<Object> arguments, IProgressMonitor progress) throws Exception {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Can't sort instructions [@NONE, blocks:[17] lbl121 : CaseStatement: default:\u000a, @NONE, blocks:[17] lbl121 : CaseStatement: default:\u000a]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op3rewriters.CompareByIndex.compare(CompareByIndex.java:25)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op3rewriters.CompareByIndex.compare(CompareByIndex.java:8)
         *     at java.base/java.util.TimSort.countRunAndMakeAscending(TimSort.java:360)
         *     at java.base/java.util.TimSort.sort(TimSort.java:220)
         *     at java.base/java.util.Arrays.sort(Arrays.java:1308)
         *     at java.base/java.util.ArrayList.sort(ArrayList.java:1804)
         *     at java.base/java.util.Collections.sort(Collections.java:178)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op3rewriters.SwitchReplacer.buildSwitchCases(SwitchReplacer.java:271)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op3rewriters.SwitchReplacer.replaceRawSwitch(SwitchReplacer.java:258)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op3rewriters.SwitchReplacer.replaceRawSwitches(SwitchReplacer.java:66)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:517)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private List<String> getBuildFiles() {
        ArrayList<String> result = new ArrayList<String>();
        List<IJavaProject> javaProjects = JdtUtils.listJavaProjects(ResourcesPlugin.getWorkspace().getRoot());
        for (IJavaProject javaProject : javaProjects) {
            IFile buildFile = null;
            if (ProjectUtils.isMavenProject((IProject)javaProject.getProject())) {
                buildFile = javaProject.getProject().getFile("pom.xml");
            } else if (ProjectUtils.isGradleProject((IProject)javaProject.getProject())) {
                buildFile = javaProject.getProject().getFile("build.gradle");
            }
            if (buildFile == null || !buildFile.exists() || buildFile.getLocationURI() == null) continue;
            result.add(ResourceUtils.fixURI((URI)buildFile.getLocationURI()));
        }
        return result;
    }

    private boolean isOnClasspath(List<Object> arguments) throws DebugException {
        if (arguments.size() < 1) {
            throw new DebugException("No file uri is specified.");
        }
        String uri = (String)arguments.get(0);
        ICompilationUnit unit = JDTUtils.resolveCompilationUnit((String)uri);
        if (unit == null || unit.getResource() == null || !unit.getResource().exists()) {
            throw new DebugException("The compilation unit " + uri + " doesn't exist.");
        }
        IJavaProject javaProject = unit.getJavaProject();
        return javaProject == null || javaProject.isOnClasspath((IJavaElement)unit);
    }
}

