/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.java.debug.plugin.internal.eval;

import com.microsoft.java.debug.core.IEvaluatableBreakpoint;
import com.microsoft.java.debug.core.adapter.AdapterUtils;
import com.microsoft.java.debug.core.adapter.ErrorCode;
import com.microsoft.java.debug.core.adapter.IDebugAdapterContext;
import com.microsoft.java.debug.core.adapter.IEvaluationProvider;
import com.microsoft.java.debug.core.adapter.ISourceLookUpProvider;
import com.microsoft.java.debug.plugin.internal.JdtSourceLookUpProvider;
import com.microsoft.java.debug.plugin.internal.JdtUtils;
import com.sun.jdi.BooleanValue;
import com.sun.jdi.ObjectReference;
import com.sun.jdi.StackFrame;
import com.sun.jdi.StringReference;
import com.sun.jdi.ThreadReference;
import com.sun.jdi.Value;
import com.sun.jdi.VirtualMachine;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.logging.Logger;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.reflect.FieldUtils;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.debug.core.DebugException;
import org.eclipse.debug.core.ILaunch;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.model.IDebugTarget;
import org.eclipse.debug.core.model.IProcess;
import org.eclipse.debug.core.model.ISourceLocator;
import org.eclipse.debug.core.model.IStackFrame;
import org.eclipse.debug.core.sourcelookup.AbstractSourceLookupDirector;
import org.eclipse.debug.core.sourcelookup.ISourceContainer;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.debug.core.IJavaDebugTarget;
import org.eclipse.jdt.debug.core.IJavaObject;
import org.eclipse.jdt.debug.core.IJavaStackFrame;
import org.eclipse.jdt.debug.core.IJavaThread;
import org.eclipse.jdt.debug.core.IJavaValue;
import org.eclipse.jdt.debug.eval.ICompiledExpression;
import org.eclipse.jdt.internal.debug.core.model.JDIDebugTarget;
import org.eclipse.jdt.internal.debug.core.model.JDIObjectValue;
import org.eclipse.jdt.internal.debug.core.model.JDIStackFrame;
import org.eclipse.jdt.internal.debug.core.model.JDIThread;
import org.eclipse.jdt.internal.debug.core.model.JDIValue;
import org.eclipse.jdt.internal.debug.eval.ast.engine.ASTEvaluationEngine;
import org.eclipse.jdt.internal.launching.JavaSourceLookupDirector;

public class JdtEvaluationProvider
implements IEvaluationProvider {
    private static final Logger logger = Logger.getLogger("java-debug");
    private IJavaProject project;
    private ILaunch launch;
    private JDIDebugTarget debugTarget;
    private Map<ThreadReference, JDIThread> threadMap = new HashMap<ThreadReference, JDIThread>();
    private HashMap<String, Object> options = new HashMap();
    private IDebugAdapterContext context;
    private List<IJavaProject> projectCandidates;
    private Set<String> visitedClassNames = new HashSet<String>();

    public void initialize(IDebugAdapterContext context, Map<String, Object> props) {
        if (props == null) {
            throw new IllegalArgumentException("argument is null");
        }
        this.options.putAll(props);
        this.context = context;
    }

    public CompletableFuture<Value> evaluateForBreakpoint(IEvaluatableBreakpoint breakpoint, ThreadReference thread) {
        if (breakpoint == null) {
            throw new IllegalArgumentException("The breakpoint is null.");
        }
        if (!breakpoint.containsEvaluatableExpression()) {
            throw new IllegalArgumentException("The breakpoint doesn't contain the evaluatable expression.");
        }
        if (StringUtils.isNotBlank((CharSequence)breakpoint.getLogMessage())) {
            return this.evaluate(this.logMessageToExpression(breakpoint.getLogMessage()), thread, 0, breakpoint);
        }
        return this.evaluate(breakpoint.getCondition(), thread, 0, breakpoint);
    }

    public CompletableFuture<Value> evaluate(String expression, ThreadReference thread, int depth) {
        return this.evaluate(expression, thread, depth, null);
    }

    public CompletableFuture<Value> evaluate(String expression, ObjectReference thisContext, ThreadReference thread) {
        CompletableFuture<Value> completableFuture = new CompletableFuture<Value>();
        try {
            this.ensureDebugTarget(thisContext.virtualMachine(), thisContext.type().name());
            JDIThread jdiThread = this.getMockJDIThread(thread);
            JDIObjectValue jdiObject = new JDIObjectValue(this.debugTarget, thisContext);
            ASTEvaluationEngine engine = new ASTEvaluationEngine(this.project, (IJavaDebugTarget)this.debugTarget);
            ICompiledExpression compiledExpression = engine.getCompiledExpression(expression, (IJavaObject)jdiObject);
            this.internalEvaluate(engine, compiledExpression, (IJavaObject)jdiObject, (IJavaThread)jdiThread, completableFuture);
            return completableFuture;
        }
        catch (Exception ex) {
            completableFuture.completeExceptionally(ex);
            return completableFuture;
        }
    }

    private CompletableFuture<Value> evaluate(String expression, ThreadReference thread, int depth, IEvaluatableBreakpoint breakpoint) {
        CompletableFuture<Value> completableFuture = new CompletableFuture<Value>();
        try {
            StackFrame sf = thread.frame(depth);
            String typeName = sf.location().method().declaringType().name();
            this.ensureDebugTarget(thread.virtualMachine(), typeName);
            JDIThread jdiThread = this.getMockJDIThread(thread);
            JDIStackFrame stackframe = this.createStackFrame(jdiThread, depth);
            if (stackframe == null) {
                throw new IllegalStateException("Cannot evaluate because the stackframe is not available.");
            }
            ICompiledExpression compiledExpression = null;
            ASTEvaluationEngine engine = new ASTEvaluationEngine(this.project, (IJavaDebugTarget)this.debugTarget);
            boolean newExpression = false;
            if (breakpoint != null) {
                long threadId = thread.uniqueID();
                compiledExpression = (ICompiledExpression)breakpoint.getCompiledExpression(threadId);
                if (compiledExpression == null) {
                    newExpression = true;
                    compiledExpression = engine.getCompiledExpression(expression, (IJavaStackFrame)stackframe);
                    breakpoint.setCompiledExpression(threadId, (Object)compiledExpression);
                }
            } else {
                compiledExpression = engine.getCompiledExpression(expression, (IJavaStackFrame)stackframe);
            }
            if (compiledExpression.hasErrors()) {
                if (!newExpression && breakpoint != null) {
                    if (StringUtils.isNotBlank((CharSequence)breakpoint.getLogMessage())) {
                        StringReference emptyValue = thread.virtualMachine().mirrorOf("");
                        completableFuture.complete(emptyValue);
                    } else {
                        BooleanValue trueValue = thread.virtualMachine().mirrorOf(true);
                        completableFuture.complete(trueValue);
                    }
                    return completableFuture;
                }
                completableFuture.completeExceptionally((Throwable)AdapterUtils.createUserErrorDebugException((String)String.format("Cannot evaluate because of compilation error(s): %s.", StringUtils.join((Object[])compiledExpression.getErrorMessages(), (String)"\n")), (ErrorCode)ErrorCode.EVALUATION_COMPILE_ERROR));
                return completableFuture;
            }
            this.internalEvaluate(engine, compiledExpression, (IJavaStackFrame)stackframe, completableFuture);
            return completableFuture;
        }
        catch (Exception ex) {
            completableFuture.completeExceptionally(ex);
            return completableFuture;
        }
    }

    public CompletableFuture<Value> invokeMethod(ObjectReference thisContext, String methodName, String methodSignature, Value[] args, ThreadReference thread, boolean invokeSuper) {
        CompletableFuture<Value> completableFuture = new CompletableFuture<Value>();
        try {
            this.ensureDebugTarget(thisContext.virtualMachine(), thisContext.type().name());
            JDIThread jdiThread = this.getMockJDIThread(thread);
            JDIObjectValue jdiObject = new JDIObjectValue(this.debugTarget, thisContext);
            ArrayList<JDIValue> arguments = null;
            if (args == null) {
                arguments = Collections.EMPTY_LIST;
            } else {
                arguments = new ArrayList<JDIValue>(args.length);
                Value[] valueArray = args;
                int n = args.length;
                int n2 = 0;
                while (n2 < n) {
                    Value arg = valueArray[n2];
                    arguments.add(new JDIValue(this.debugTarget, arg));
                    ++n2;
                }
            }
            IJavaValue javaValue = jdiObject.sendMessage(methodName, methodSignature, arguments.toArray(new IJavaValue[0]), (IJavaThread)jdiThread, invokeSuper);
            Value value = (Value)FieldUtils.readField((Object)javaValue, (String)"fValue", (boolean)true);
            completableFuture.complete(value);
            return completableFuture;
        }
        catch (Exception ex) {
            completableFuture.completeExceptionally(ex);
            return completableFuture;
        }
    }

    private String logMessageToExpression(String logMessage) {
        String format = logMessage.replaceAll("\\{(.*?)\\}", "%s");
        Pattern pattern = Pattern.compile("\\{(.*?)\\}");
        Matcher matcher = pattern.matcher(logMessage);
        ArrayList<String> arguments = new ArrayList<String>();
        while (matcher.find()) {
            arguments.add("(" + matcher.group(1) + ")");
        }
        if (arguments.size() > 0) {
            return "System.out.println(String.format(\"" + format + "\"," + String.join((CharSequence)",", arguments) + "))";
        }
        return "System.out.println(\"" + format + "\")";
    }

    private void initializeProjectCandidates(String mainclass) {
        IWorkspaceRoot root = ResourcesPlugin.getWorkspace().getRoot();
        this.projectCandidates = Arrays.stream(root.getProjects()).map(JdtUtils::getJavaProject).filter(p -> {
            try {
                return p != null && p.hasBuildState();
            }
            catch (Exception exception) {
                return false;
            }
        }).collect(Collectors.toList());
        if (StringUtils.isNotBlank((CharSequence)mainclass)) {
            this.filterProjectCandidatesByClass(mainclass);
        }
    }

    private void filterProjectCandidatesByClass(String className) {
        this.projectCandidates = this.visitedClassNames.contains(className) ? this.projectCandidates : this.projectCandidates.stream().filter(p -> {
            try {
                return p.findType(className) != null;
            }
            catch (Exception exception) {
                return false;
            }
        }).collect(Collectors.toList());
        this.visitedClassNames.add(className);
    }

    private IJavaProject findJavaProjectByType(String typeName) {
        if (this.projectCandidates == null) {
            this.initializeProjectCandidates((String)this.options.get("mainClass"));
        }
        if (this.projectCandidates.size() == 0) {
            logger.severe("No project is available for evaluation.");
            throw new IllegalStateException("Cannot evaluate, please specify projectName in launch.json.");
        }
        try {
            this.filterProjectCandidatesByClass(typeName);
        }
        catch (Exception ex) {
            logger.severe("Cannot evaluate when the project is not specified, due to exception: " + ex.getMessage());
            throw new IllegalStateException("Cannot evaluate, please specify projectName in launch.json.");
        }
        if (this.projectCandidates.size() == 1) {
            return this.projectCandidates.get(0);
        }
        if (this.projectCandidates.size() == 0) {
            logger.severe("No project is available for evaluation.");
            throw new IllegalStateException("Cannot evaluate, please specify projectName in launch.json.");
        }
        logger.severe("Multiple projects are valid for evaluation.");
        throw new IllegalStateException("Cannot evaluate, please specify projectName in launch.json.");
    }

    private JDIStackFrame createStackFrame(JDIThread thread, int depth) {
        try {
            IStackFrame[] jdiStackFrames = thread.getStackFrames();
            return jdiStackFrames.length > depth ? (JDIStackFrame)jdiStackFrames[depth] : null;
        }
        catch (DebugException debugException) {
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private JDIThread getMockJDIThread(final ThreadReference thread) {
        Map<ThreadReference, JDIThread> map = this.threadMap;
        synchronized (map) {
            return this.threadMap.computeIfAbsent(thread, threadKey -> new JDIThread(this.debugTarget, thread){

                protected synchronized void invokeComplete(int restoreTimeout) {
                    super.invokeComplete(restoreTimeout);
                    JdtEvaluationProvider.this.context.getStackFrameManager().reloadStackFrames(thread);
                }
            });
        }
    }

    private void internalEvaluate(ASTEvaluationEngine engine, ICompiledExpression compiledExpression, IJavaStackFrame stackframe, CompletableFuture<Value> completableFuture) {
        try {
            engine.evaluateExpression(compiledExpression, stackframe, evaluateResult -> {
                if (evaluateResult == null || evaluateResult.hasErrors()) {
                    Object ex = evaluateResult.getException() != null ? evaluateResult.getException() : new RuntimeException(StringUtils.join((Object[])evaluateResult.getErrorMessages()));
                    completableFuture.completeExceptionally((Throwable)ex);
                    return;
                }
                try {
                    Value value = (Value)FieldUtils.readField((Object)evaluateResult.getValue(), (String)"fValue", (boolean)true);
                    completableFuture.complete(value);
                }
                catch (IllegalAccessException | IllegalArgumentException ex) {
                    completableFuture.completeExceptionally(ex);
                }
            }, 0, false);
        }
        catch (Exception ex) {
            completableFuture.completeExceptionally(ex);
        }
    }

    private void internalEvaluate(ASTEvaluationEngine engine, ICompiledExpression compiledExpression, IJavaObject object, IJavaThread thread, CompletableFuture<Value> completableFuture) {
        try {
            engine.evaluateExpression(compiledExpression, object, thread, evaluateResult -> {
                if (evaluateResult == null || evaluateResult.hasErrors()) {
                    Object ex = evaluateResult.getException() != null ? evaluateResult.getException() : new RuntimeException(StringUtils.join((Object[])evaluateResult.getErrorMessages()));
                    completableFuture.completeExceptionally((Throwable)ex);
                    return;
                }
                try {
                    Value value = (Value)FieldUtils.readField((Object)evaluateResult.getValue(), (String)"fValue", (boolean)true);
                    completableFuture.complete(value);
                }
                catch (IllegalAccessException | IllegalArgumentException ex) {
                    completableFuture.completeExceptionally(ex);
                }
            }, 0, false);
        }
        catch (Exception ex) {
            completableFuture.completeExceptionally(ex);
        }
    }

    public boolean isInEvaluation(ThreadReference thread) {
        if (this.debugTarget == null) {
            return false;
        }
        JDIThread jdiThread = this.getMockJDIThread(thread);
        return jdiThread != null && (jdiThread.isPerformingEvaluation() || jdiThread.isInvokingMethod());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clearState(ThreadReference thread) {
        if (this.debugTarget != null) {
            Map<ThreadReference, JDIThread> map = this.threadMap;
            synchronized (map) {
                JDIThread jdiThread = this.threadMap.get(thread);
                if (jdiThread != null) {
                    try {
                        jdiThread.terminateEvaluation();
                    }
                    catch (DebugException e) {
                        logger.warning(String.format("Error stopping evaluation on thread %d: %s", thread.uniqueID(), e.toString()));
                    }
                    this.threadMap.remove(thread);
                }
            }
        }
    }

    private void ensureDebugTarget(VirtualMachine vm, String typeName) {
        if (this.debugTarget == null) {
            if (this.project == null) {
                String projectName = (String)this.options.get("projectName");
                if (StringUtils.isBlank((CharSequence)projectName)) {
                    this.project = this.findJavaProjectByType(typeName);
                } else {
                    IJavaProject javaProject = JdtUtils.getJavaProject(projectName);
                    if (javaProject == null) {
                        throw new IllegalStateException(String.format("Project %s cannot be found.", projectName));
                    }
                    this.project = javaProject;
                }
            }
            if (this.launch == null) {
                ISourceLookUpProvider sourceProvider = (ISourceLookUpProvider)this.context.getProvider(ISourceLookUpProvider.class);
                this.launch = JdtEvaluationProvider.createILaunchMock(this.project, ((JdtSourceLookUpProvider)sourceProvider).getSourceContainers());
            }
            this.debugTarget = new JDIDebugTarget(this.launch, vm, "", false, false, null, false){

                protected synchronized void initialize() {
                }
            };
        }
    }

    private static ILaunch createILaunchMock(IJavaProject project, final ISourceContainer[] containers) {
        return new ILaunch(){
            private AbstractSourceLookupDirector locator;

            public boolean canTerminate() {
                return false;
            }

            public boolean isTerminated() {
                return false;
            }

            public void terminate() throws DebugException {
            }

            public <T> T getAdapter(Class<T> arg0) {
                return null;
            }

            public void addDebugTarget(IDebugTarget arg0) {
            }

            public void addProcess(IProcess arg0) {
            }

            public String getAttribute(String arg0) {
                return null;
            }

            public Object[] getChildren() {
                return null;
            }

            public IDebugTarget getDebugTarget() {
                return null;
            }

            public IDebugTarget[] getDebugTargets() {
                return null;
            }

            public ILaunchConfiguration getLaunchConfiguration() {
                return null;
            }

            public String getLaunchMode() {
                return null;
            }

            public IProcess[] getProcesses() {
                return null;
            }

            public ISourceLocator getSourceLocator() {
                if (this.locator != null) {
                    return this.locator;
                }
                this.locator = new JavaSourceLookupDirector();
                try {
                    this.locator.setSourceContainers(containers);
                }
                catch (Exception e) {
                    logger.severe(String.format("Cannot initialize JavaSourceLookupDirector: %s", e.toString()));
                }
                this.locator.initializeParticipants();
                return this.locator;
            }

            public boolean hasChildren() {
                return false;
            }

            public void removeDebugTarget(IDebugTarget arg0) {
            }

            public void removeProcess(IProcess arg0) {
            }

            public void setAttribute(String arg0, String arg1) {
            }

            public void setSourceLocator(ISourceLocator arg0) {
            }
        };
    }
}

