/*
 * Decompiled with CFR 0.152.
 */
package com.morpheusdata.core;

import com.morpheusdata.core.MorpheusContext;
import com.morpheusdata.core.PluginInterface;
import com.morpheusdata.core.PluginManager;
import com.morpheusdata.core.PluginProvider;
import com.morpheusdata.model.Permission;
import com.morpheusdata.views.Renderer;
import com.morpheusdata.web.PluginController;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;

public abstract class Plugin
implements PluginInterface {
    protected Map<String, PluginProvider> pluginProviders = new LinkedHashMap<String, PluginProvider>();
    private PluginManager pluginManager;
    protected MorpheusContext morpheusContext;
    private ClassLoader classLoader;
    protected Renderer<?> renderer;
    protected List<PluginController> controllers = new ArrayList<PluginController>();
    protected List<Permission> permissions = new ArrayList<Permission>();
    protected String name;
    protected String fileName;
    protected String version;
    protected String author;
    protected String description;
    protected String websiteUrl;
    protected String sourceCodeLocationUrl;
    protected String issueTrackerUrl;

    public void setControllers(List<PluginController> controllers) {
        this.controllers = controllers;
    }

    public List<PluginController> getControllers() {
        return this.controllers;
    }

    public void setRenderer(Renderer<?> renderer) {
        this.renderer = renderer;
    }

    public boolean hasCustomRender() {
        return this.renderer != null;
    }

    protected Renderer<?> getRenderer() {
        if (this.renderer != null) {
            return this.renderer;
        }
        return this.pluginManager.getRenderer();
    }

    void setPluginManager(PluginManager manager) {
        this.pluginManager = manager;
    }

    void setMorpheusContext(MorpheusContext morpheusContext) {
        this.morpheusContext = morpheusContext;
    }

    public PluginManager getPluginManager() {
        return this.pluginManager;
    }

    public Collection<PluginProvider> getProviders() {
        ArrayList<PluginProvider> providers = new ArrayList<PluginProvider>();
        for (String key : this.pluginProviders.keySet()) {
            providers.add(this.pluginProviders.get(key));
        }
        return providers;
    }

    public PluginProvider getProviderByCode(String code) {
        return this.pluginProviders.get(code);
    }

    public Collection<PluginProvider> getProvidersByType(Class clazz) {
        ArrayList<PluginProvider> providers = new ArrayList<PluginProvider>();
        for (String key : this.pluginProviders.keySet()) {
            PluginProvider currentProvider = this.pluginProviders.get(key);
            if (!clazz.isInstance(currentProvider)) continue;
            providers.add(currentProvider);
        }
        return providers;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public void setName(String name) {
        this.name = name;
    }

    @Override
    public String getFileName() {
        return this.fileName;
    }

    @Override
    public void setFileName(String fileName) {
        this.fileName = fileName;
    }

    @Override
    public String getVersion() {
        return this.version;
    }

    @Override
    public void setVersion(String version) {
        this.version = version;
    }

    @Override
    public String getDescription() {
        return this.description;
    }

    @Override
    public void setDescription(String description) {
        this.description = description;
    }

    @Override
    public String getAuthor() {
        return this.author;
    }

    @Override
    public void setAuthor(String author) {
        this.author = author;
    }

    @Override
    public String getWebsiteUrl() {
        return this.websiteUrl;
    }

    @Override
    public void setWebsiteUrl(String websiteUrl) {
        this.websiteUrl = websiteUrl;
    }

    @Override
    public String getSourceCodeLocationUrl() {
        return this.sourceCodeLocationUrl;
    }

    @Override
    public void setSourceCodeLocationUrl(String sourceCodeLocationUrl) {
        this.sourceCodeLocationUrl = sourceCodeLocationUrl;
    }

    @Override
    public String getIssueTrackerUrl() {
        return this.issueTrackerUrl;
    }

    @Override
    public void setIssueTrackerUrl(String issueTrackerUrl) {
        this.issueTrackerUrl = issueTrackerUrl;
    }

    public void setClassLoader(ClassLoader classLoader) {
        this.classLoader = classLoader;
    }

    public ClassLoader getClassLoader() {
        return this.classLoader;
    }

    public List<Permission> getPermissions() {
        return this.permissions;
    }

    public void setPermissions(List<Permission> permissions) {
        this.permissions = permissions;
    }
}

