/*
 * Decompiled with CFR 0.152.
 */
package com.morpheusdata.core;

import com.morpheusdata.core.ChildFirstClassLoader;
import com.morpheusdata.core.MorpheusContext;
import com.morpheusdata.core.Plugin;
import com.morpheusdata.core.PluginProvider;
import com.morpheusdata.views.HandlebarsRenderer;
import com.morpheusdata.views.Renderer;
import com.morpheusdata.views.ViewModel;
import com.morpheusdata.web.Dispatcher;
import com.morpheusdata.web.PluginController;
import com.morpheusdata.web.Route;
import java.io.File;
import java.io.FileInputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.jar.Attributes;
import java.util.jar.JarInputStream;
import java.util.jar.Manifest;

public class PluginManager {
    private ArrayList<Plugin> plugins = new ArrayList();
    private MorpheusContext morpheusContext;
    private Dispatcher dispatcher;
    private Renderer<?> renderer = new HandlebarsRenderer();
    private final ClassLoader mainLoader = PluginManager.class.getClassLoader();
    private final ClassLoader pluginManagerClassLoader = new ClassLoader(this.mainLoader){};

    PluginManager(MorpheusContext context, Collection<Class<Plugin>> plugins) throws InstantiationException, IllegalAccessException {
        this.morpheusContext = context;
        this.dispatcher = new Dispatcher(this);
        if (this.morpheusContext == null) {
            throw new IllegalArgumentException("Context must not be null when passed to the constructor of the Morpheus Plugin Manager");
        }
    }

    public PluginManager(MorpheusContext context) {
        this.morpheusContext = context;
        this.dispatcher = new Dispatcher(this);
        if (this.morpheusContext == null) {
            throw new IllegalArgumentException("Context must not be null when passed to the constructor of the Morpheus Plugin Manager");
        }
    }

    public Object handleRoute(String route, ViewModel<?> model, List<Map<String, String>> permissions) {
        return this.dispatcher.handleRoute(route, model, permissions);
    }

    MorpheusContext getMorpheusContext() {
        return this.morpheusContext;
    }

    Plugin registerPlugin(Class<Plugin> pluginClass, File jarFile, String version) throws IllegalAccessException, InstantiationException, MalformedURLException {
        URL jarUrl = new URL("file", null, jarFile.getAbsolutePath());
        ChildFirstClassLoader pluginClassLoader = new ChildFirstClassLoader(new URL[]{jarUrl}, this.pluginManagerClassLoader);
        Plugin plugin = pluginClass.newInstance();
        plugin.setPluginManager(this);
        plugin.setMorpheusContext(this.morpheusContext);
        plugin.setName(pluginClass.toString());
        plugin.setFileName(jarFile.getAbsolutePath());
        plugin.setVersion(version);
        plugin.setClassLoader(pluginClassLoader);
        plugin.initialize();
        if (plugin.getControllers().size() > 0 && !plugin.hasCustomRender()) {
            this.renderer.addTemplateLoader(pluginClassLoader);
        }
        this.plugins.add(plugin);
        return plugin;
    }

    public Plugin registerPlugin(String pathToJar) throws Exception {
        File jarFile = new File(pathToJar);
        URL jarUrl = new URL("file", null, jarFile.getAbsolutePath());
        URLClassLoader pluginLoader = URLClassLoader.newInstance(new URL[]{jarUrl}, this.pluginManagerClassLoader);
        JarInputStream jarStream = new JarInputStream(new FileInputStream(jarFile));
        Manifest mf = jarStream.getManifest();
        Attributes attributes = mf.getMainAttributes();
        String pluginClassName = attributes.getValue("Plugin-Class");
        String pluginVersion = attributes.getValue("Plugin-Version");
        try {
            Class<Plugin> pluginClass = pluginLoader.loadClass(pluginClassName);
            System.out.println("Loading Plugin " + pluginClassName + ":" + pluginVersion + " from " + pathToJar);
            return this.registerPlugin(pluginClass, jarFile, pluginVersion);
        }
        catch (Exception e) {
            System.out.println("Unable to load plugin class from " + pathToJar);
            e.printStackTrace();
            return null;
        }
    }

    void deregisterPlugin(Plugin plugin) {
        plugin.onDestroy();
        this.renderer.removeTemplateLoader(plugin.getClassLoader());
        this.plugins.remove(plugin);
    }

    public ArrayList<Plugin> getPlugins() {
        return this.plugins;
    }

    public Map<Class, List<Route>> getRoutes() {
        HashMap<Class, List<Route>> routes = new HashMap<Class, List<Route>>();
        for (Plugin p : this.getPlugins()) {
            for (PluginController c : p.getControllers()) {
                if (c.getRoutes().size() <= 0) continue;
                routes.put(c.getClass(), c.getRoutes());
            }
        }
        return routes;
    }

    public PluginProvider findByCode(String code) {
        for (Plugin plugin : this.plugins) {
            PluginProvider pp = plugin.getProviderByCode(code);
            if (pp == null) continue;
            return pp;
        }
        return null;
    }

    public Renderer<?> getRenderer() {
        return this.renderer;
    }
}

