/*
 * Decompiled with CFR 0.152.
 */
package com.morpheusdata.core.util;

import com.morpheusdata.model.NetworkProxy;
import java.net.InetSocketAddress;
import java.net.Proxy;
import java.net.Socket;
import java.util.concurrent.TimeUnit;

public class ConnectionUtils {
    static Boolean testHostConnectivity(String hostname) {
        return ConnectionUtils.testHostConnectivity(hostname, null, true, true, null);
    }

    static Boolean testHostConnectivity(String hostname, Integer port) {
        return ConnectionUtils.testHostConnectivity(hostname, port, true, true, null);
    }

    static Boolean testHostConnectivity(String hostname, Integer port, Boolean doPingTest) {
        return ConnectionUtils.testHostConnectivity(hostname, port, doPingTest, true, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Boolean testHostConnectivity(String hostname, Integer port, Boolean doPingTest, Boolean doSocketTest, NetworkProxy networkProxy) {
        Boolean rtn = false;
        if (doPingTest.booleanValue() && networkProxy == null) {
            try {
                String command = "ping -c 1 " + hostname;
                Process process = Runtime.getRuntime().exec(command);
                process.waitFor(60000L, TimeUnit.MILLISECONDS);
                Integer exitValue = process.exitValue();
                if (exitValue == 0) {
                    rtn = true;
                }
            }
            catch (Exception command) {
                // empty catch block
            }
        }
        if (!rtn.booleanValue() && doSocketTest.booleanValue() && port != null) {
            Integer soTimeout2;
            Socket testSocket;
            if (port == -1) {
                port = 80;
            }
            if (networkProxy != null) {
                testSocket = null;
                try {
                    soTimeout2 = 20000;
                    InetSocketAddress proxyHost = new InetSocketAddress(networkProxy.getProxyHost(), (int)networkProxy.getProxyPort());
                    Proxy serverProxy = new Proxy(Proxy.Type.SOCKS, proxyHost);
                    testSocket = new Socket(serverProxy);
                    testSocket.setSoTimeout(soTimeout2);
                    testSocket.connect(new InetSocketAddress(hostname, (int)port), soTimeout2);
                    rtn = true;
                }
                catch (Exception soTimeout2) {
                }
                finally {
                    if (testSocket != null) {
                        try {
                            testSocket.close();
                        }
                        catch (Exception soTimeout2) {}
                    }
                }
            } else {
                testSocket = null;
                try {
                    soTimeout2 = 10000;
                    testSocket = new Socket();
                    testSocket.setSoTimeout(soTimeout2);
                    testSocket.connect(new InetSocketAddress(hostname, (int)port), soTimeout2);
                    rtn = true;
                }
                catch (Exception exception) {
                }
                finally {
                    if (testSocket != null) {
                        try {
                            testSocket.close();
                        }
                        catch (Exception exception) {}
                    }
                }
            }
        }
        return rtn;
    }
}

