/*
 * Decompiled with CFR 0.152.
 */
package com.morpheusdata.model;

import java.io.Reader;
import java.io.StringReader;
import java.lang.reflect.Field;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.json.Json;
import javax.json.JsonArray;
import javax.json.JsonNumber;
import javax.json.JsonObject;
import javax.json.JsonObjectBuilder;
import javax.json.JsonReader;
import javax.json.JsonValue;

public class MorpheusModel {
    protected Long id;
    protected String config;
    private LinkedHashMap<String, Object> dirtyProperties = new LinkedHashMap();

    public Long getId() {
        return this.id;
    }

    public void setId(Long id) {
        this.id = id;
    }

    protected void markDirty(String propertyName, Object value) {
        this.dirtyProperties.put(propertyName, value);
    }

    public void markClean() {
        this.dirtyProperties.clear();
    }

    public Set<String> getDirtyProperties() {
        return this.dirtyProperties.keySet();
    }

    public LinkedHashMap<String, Object> getDirtyPropertyValues() {
        return this.dirtyProperties;
    }

    public HashMap<String, Object> getProperties() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        for (Class<?> clazz = this.getClass(); clazz != null && clazz != Object.class; clazz = clazz.getSuperclass()) {
            Field[] fields;
            for (Field field : fields = clazz.getDeclaredFields()) {
                String name = field.getName();
                Object value = null;
                try {
                    value = field.get(this);
                }
                catch (IllegalAccessException illegalAccessException) {
                    // empty catch block
                }
                map.put(name, value);
            }
        }
        return map;
    }

    public String getConfig() {
        return this.config;
    }

    public void setConfig(String config) {
        this.config = config;
    }

    public Map getConfigMap() {
        Map map = new HashMap();
        try {
            JsonReader jsonReader = Json.createReader((Reader)new StringReader(this.config));
            JsonObject object = jsonReader.readObject();
            jsonReader.close();
            map = this.toMap(object);
        }
        catch (Exception exception) {
            // empty catch block
        }
        return map;
    }

    public void setConfigMap(Map<String, Object> map) {
        JsonObject object = this.mapToJson(map);
        this.config = object.toString();
    }

    private JsonObject mapToJson(Map<String, Object> map) {
        JsonObjectBuilder builder = Json.createObjectBuilder();
        for (String key : map.keySet()) {
            Object val = map.get(key);
            if (val instanceof String) {
                builder.add(key, (String)val);
                continue;
            }
            if (val instanceof Number) {
                if (val instanceof Integer) {
                    builder.add(key, ((Integer)val).intValue());
                    continue;
                }
                builder.add(key, (BigDecimal)val);
                continue;
            }
            if (val instanceof Boolean) {
                builder.add(key, ((Boolean)val).booleanValue());
                continue;
            }
            if (val instanceof Map) {
                builder.add(key, (JsonValue)this.mapToJson((Map)val));
                continue;
            }
            builder.add(key, val.toString());
        }
        return builder.build();
    }

    private Map toMap(JsonObject object) {
        HashMap<String, Object> map = new HashMap<String, Object>();
        for (String key : object.keySet()) {
            Object val = new List<Object>();
            JsonValue value = (JsonValue)object.get((Object)key);
            if (value instanceof JsonArray) {
                val = this.toList((JsonArray)value);
            } else if (value instanceof JsonObject) {
                val = this.toMap((JsonObject)value);
            } else if (value.getValueType() == JsonValue.ValueType.STRING) {
                val = object.getString(key);
            } else if (value.getValueType() == JsonValue.ValueType.NUMBER) {
                JsonNumber number = object.getJsonNumber(key);
                val = number.isIntegral() ? (double)number.longValue() : number.doubleValue();
            } else if (value.getValueType() == JsonValue.ValueType.FALSE || value.getValueType() == JsonValue.ValueType.TRUE) {
                val = object.getBoolean(key);
            }
            map.put(key, val);
        }
        return map;
    }

    private List<Object> toList(JsonArray array) {
        ArrayList<Object> list = new ArrayList<Object>();
        for (int i = 0; i < array.size(); ++i) {
            JsonValue value = (JsonValue)array.get(i);
            Object val = new List<Object>();
            if (value instanceof JsonArray) {
                val = this.toList((JsonArray)value);
            } else if (value instanceof JsonObject) {
                val = this.toMap((JsonObject)value);
            } else if (value.getValueType() == JsonValue.ValueType.STRING) {
                val = array.getString(i);
            } else if (value.getValueType() == JsonValue.ValueType.NUMBER) {
                JsonNumber number = array.getJsonNumber(i);
                val = number.isIntegral() ? (double)number.longValue() : number.doubleValue();
            } else if (value.getValueType() == JsonValue.ValueType.FALSE || value.getValueType() == JsonValue.ValueType.TRUE) {
                val = array.getBoolean(i);
            }
            list.add(val);
        }
        return list;
    }

    public Object getConfigProperty(String prop) {
        Map configMap = this.getConfigMap();
        Object propertyValue = null;
        if (!prop.contains(".")) {
            propertyValue = configMap.get(prop);
        } else {
            String[] parts = prop.split("\\.");
            Map nestedPart = configMap;
            for (String part : parts) {
                if (part.equals(parts[parts.length - 1])) {
                    propertyValue = nestedPart.get(part);
                } else {
                    nestedPart = (Map)nestedPart.get(part);
                }
                if (nestedPart == null) break;
            }
        }
        return propertyValue;
    }
}

