/*
 * Decompiled with CFR 0.152.
 */
package com.morpheusdata.model;

import com.morpheusdata.model.MorpheusModel;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class Permission
extends MorpheusModel {
    public String name;
    public String code;
    public List<AccessType> availableAccessTypes;

    public Permission(String name, String code, List<AccessType> availableAccessTypes) {
        this.name = name;
        this.code = code;
        this.availableAccessTypes = availableAccessTypes;
    }

    public Permission(String code, List<AccessType> availableAccessTypes) {
        this.name = code;
        this.code = code;
        this.availableAccessTypes = availableAccessTypes;
    }

    public Map<String, String> asMap() {
        HashMap<String, String> map = new HashMap<String, String>();
        List<String> types = this.typesAsString();
        String highestType = types.get(types.size() - 1);
        map.put(this.code, highestType);
        return map;
    }

    public List<String> typesAsString() {
        ArrayList<String> types = new ArrayList<String>();
        for (AccessType accessType : this.availableAccessTypes) {
            types.add(accessType.name());
        }
        return types;
    }

    public static Permission build(String name, String code, List<AccessType> availableAccessTypes) {
        return new Permission(name, code, availableAccessTypes);
    }

    public static Permission build(String code, List<AccessType> availableAccessTypes) {
        return new Permission(code, availableAccessTypes);
    }

    public static Permission build(String code, String availableAccessType) {
        ArrayList<AccessType> availableAccessTypes = new ArrayList<AccessType>();
        availableAccessTypes.add(AccessType.valueOf(availableAccessType));
        return new Permission(code, availableAccessTypes);
    }

    public List<Permission> toList() {
        ArrayList<Permission> list = new ArrayList<Permission>();
        list.add(this);
        return list;
    }

    public static enum AccessType {
        none,
        read,
        full;

    }
}

